
#define		uCHAR	unsigned char
#define		uINT	unsigned short
#define		uLONG	unsigned long

#include "REG_MG84FG516.H"
#include "delay.H"

#define	CR0			0x01
#define	CR1			0x02
#define	AA			0x04
#define	SI			0x08
#define	STO			0x10
#define	STA			0x20
#define	ENSI		0x40
#define	CR2			0x80


uCHAR I2C_Read(uCHAR Dev_Addr, uCHAR Reg_Addr)
  {	
	uCHAR	usData = 0;

	SICON |= STA;
	SICON &= ~SI;
	while(( SICON & SI ) != SI );
	SICON &= ~STA;

	SIDAT = Dev_Addr;							// send device address
	SICON &= ~SI;
	while(( SICON & SI ) != SI );

	SIDAT = Reg_Addr;							// send register address
	SICON &= ~SI;
	while(( SICON & SI ) != SI );


	SICON |= STA;								// restart
	SICON &= ~SI;
	while(( SICON & SI ) != SI );
	SICON &= ~STA;

	SIDAT = Dev_Addr | 0x01;					// send device address
	SICON &= ~SI;
	while(( SICON & SI ) != SI );

	SICON &= ~SI;
	while(( SICON & SI ) != SI );
	usData = SIDAT;

    SICON |= STO;
    SICON &= ~SI;
    while(( SICON & STO ) == STO ); 

	return usData;
  }


void I2C_Write(uCHAR Dev_Addr, uCHAR Reg_Addr, uCHAR ucData)
{
	SICON |= STA;
	SICON &= ~SI;
	while(( SICON & SI ) != SI );
	SICON &= ~STA;

	SIDAT = Dev_Addr;							// send device address
	SICON &= ~SI;
	while(( SICON & SI ) != SI );

	SIDAT = Reg_Addr;							// send register address
	SICON &= ~SI;
	while(( SICON & SI ) != SI );

	SIDAT = ucData;								// send data
	SICON &= ~SI;
	while(( SICON & SI ) != SI );

    SICON |= STO;
    SICON &= ~SI;
    while(( SICON & STO ) == STO ); 
}

void Timer3_Initial(void)
{
	SFRPI = 1;									//select SFR page index to "1"
	
	T3MOD = 0x10;
	T3CON = 0;
	RCAP3H = 0xFF;
	TH3 = 0xFF;
	RCAP3L = 0xEC;								//0x10000 - 0xFFEC = 0x14h = 20d
	TL3 = 0xEC;									//20*6 = 120 * 83ns = 9.96us
	
	TR3 = 1;
	
	
	SFRPI = 0;
}

void main()
{
	SICON |= ( CR2 | ENSI | CR1 | CR0 );		//enable TWSI and clock source Timer3 overflow
	Timer3_Initial();							//I2C freq is 100K @ MCU run 12MHz.

	I2C_Write(0xA0, 0x30, 0x55);
	delay_ms(10);
	P0 = I2C_Read(0xA0, 0x30);

	while(1);
}
