/**
  ******************************************************************************
 *
 * @file        Sample_MID_WWDT_Period.c
 *
 * @brief       The sample code of WWDT period into interrupt
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */
 

/* Includes ------------------------------------------------------------------*/
#include "MG32_WWDT_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
void Sample_MID_WWDT_Period(void);

/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief       WWDT period into interrupt.
 * @details     1.Initial WWDT
 *    \n        2.Initial clock.
 * @return      None
 *******************************************************************************
 */
void Sample_MID_WWDT_Period(void)
{
    WWDT_HandleTypeDef mWWDT;
    
    // make sure :
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //CK_LS clock can from ILRCO or external XTAL
    //Please open "Manage Run Time Environment",then enable WWDT IRQ in MG32_IRQ_Handler.
    // ------------------------------------------------------------------------
    // 1.Initial WWDT. 
    // ------------------------------------------------------------------------
    mWWDT.Instance = WWDT;                                              //Mapping WWDT base address
    mWWDT.Init.WWDT_RLR = 32;                                           //SET WWDT reload register
    mWWDT.Init.WWDT_WIN = 64;                                           //SET WWDT window compare register
    mWWDT.Init.WWDT_WRN = 64;                                           //SET WWDT warnning compare register
    mWWDT.Init.WWDT_INT_SEL = (WWDT_IT_WRN|WWDT_IT_TIE);    			//Enable WWDT interrupt
    mWWDT.Init.WWDT_CLK_SEL = WWDT_CLK_UT;                              //Select WWDT clock source from UT
    if (MID_WWDT_Init(&mWWDT) != MID_OK)                                //WWDT initial and return value check
    {
            WWDT_Error_Handler(&mWWDT);
    }
}




