

/**
 ******************************************************************************
 *
 * @file        Sample_MID_URT_RX.c
 * @brief       The sample code is that use middleware to receive data
 *     \n       (The middleware is use polling flag).
 * @par         Project
 *              MG32
 * @version     V1.03
 * @date        2025/09/17
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */



/* Includes ------------------------------------------------------------------*/
#include "MG32_CSC_Init.h"
#include "MG32_GPIO_MID.h"
#include "MG32_URT_MID.h"


/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static URT_HandleTypeDef MURT_RX;
static uint8_t MID_URTRX_RXBUF[10];

/* Private function prototypes -----------------------------------------------*/
void Sample_MID_URT_Receive(void);
void SysTick_Handler(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief     The is SysTick Handler Sample.
 * @details   Call the MID_IncTick() function into SysTick_Handler() if 
 *            the SysTick_Handler() already  exists, or uncommenting 
 *            the SysTick_Handler() function in the sample code.   
 * @return      
 * @exception No
 * @note      No
 *******************************************************************************
 */
//void SysTick_Handler(void)
//{
//    MID_IncTick();
//}


/**
 *******************************************************************************
 * @brief     Initalize the URT MSP.
 * @details    
 * @param[in] MURT : URT control struct. 
 * @return      
 * @exception No
 * @note      No
 *******************************************************************************
 */
void MID_URT_MspInit(URT_HandleTypeDef* MURT)
{
    GPIO_InitTypeDef PINX_InitStruct;
    
    //==============================================================================
    //CSC Inital 
    //You can:
    //    1. Tick CSC checkbox of MG32_ChipInit in Manage Run-Time Environment.
    //    2. In MG32_ChipInit_Wizard of Project window use MG32_CSC_Init.h file
    //       to select that you want CSC environment.
    
    //==============================================================================
    //GPIO Inital : 
    //You can :
    //    1. Tick CSC checkbox of MG32_ChipInit in Manage Run-Time Environment.
    //       In MG32_ChipInit_Wizard of Project window use MG32_CSC_Init.h file
    //       to select that you want CSC environment.
    //    or
    //    2. Use MID_GPIO_Pin_Init() or MID_GPIO_Init()
    //       the following sample code is MID_GPIO_Pin_Init().
    //    - TX : 
    //        1. Pin : PB8 
    //        2. Mode : Push pull mode.
    //    - RX : 
    //        1. Pin : PB9
    //        2. Mode : Open drain with internal pull up R. 
    PINX_InitStruct.Mode		   = GPIO_MODE_OPENDRAIN_O;
    PINX_InitStruct.Pull           = GPIO_PULLUP;
    PINX_InitStruct.Speed          = GPIO_SPEED_LOW;
    PINX_InitStruct.OUTDrive       = GPIO_OUTDRIVE_LEVEL0;
    PINX_InitStruct.FilterDivider  = GPIO_FILTERDIVIDER_BYPASS;
    PINX_InitStruct.Inverse        = GPIO_INVERSE_DISABLE;
    PINX_InitStruct.Alternate      = 3;
    MID_GPIO_Pin_Init(PINB(9),&PINX_InitStruct);
    
    PINX_InitStruct.Mode	       = GPIO_MODE_PUSHPULL_O;
    MID_GPIO_Pin_Init(PINB(8),&PINX_InitStruct);
    
    //==============================================================================
    // Prevent unused argument(s) compilation warning 
    UNUSED(MURT);               /*Becase the sample code no use the parameter, the code
                                 is that prevent unused argument(s) compilation warning*/
}
/**
 *******************************************************************************
 * @brief	    The sample code is that use blocking mode to receive data.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void Sample_MID_URT_Receive(void)
{
    //==============================================================================
    //Enable systick for Timeout use.
    MID_InitTick(0);          // *.1ms Tick period and Tick Priority is '0'
                              //
                              // *.Have to option IRQ_handler of MG32_ChipInit_Wizard
                              //   in Manage Run-Time Environment or own write 
                              //   SysTick_Handler() and call MID_IncTick().
    //==============================================================================
    //Select URT : The sample select UART0 
    MURT_RX.Instance            =  URT0;
    
    //==============================================================================
    //URT standard inital :
    //    - Baudrate.
    //    - Data Size.  
    //    - Hardware Flow Control. (CTS / RTS)
    //    - Sample time.
    //    - Parity bit.
    //    - Stop bit.
    MURT_RX.Init.BaudRate       =  115200;                            
    MURT_RX.Init.WordLength     =  UART_WORDLENGTH_8B;
    MURT_RX.Init.HWFlowCtrl     =  URT_HWCONTROL_NONE;
    MURT_RX.Init.Mode           =  URT_TX_RX;
    MURT_RX.Init.OneBitSampling =  URT_ONEBIT_SAMPLE_THREE;
    MURT_RX.Init.Parity         =  URT_PARITY_NO;
    MURT_RX.Init.StopBits       =  URT_STOPBIT_1_0;
    
    //==============================================================================
    //URT advanced inital. 
    
    //-------------------------------------------------------------
    //Exsample 1 :
    //    - No need Advanced inital.
    MURT_RX.AdvancedInit.AdvFeatureInit     = URT_ADVFEATURE_NO_INIT;
    
    
    //-------------------------------------------------------------
    //Exsample 2 :
    //    - AdvFeatureInit select to deal with item :
    //        -1. TXDataInvert : Control TX Data bit whether inverse or not.
    //        -2. RXDataInvert : Control RX Data bit whether inverse or not.
    //        -3. TXMSBFirst   : Control TX Data bit order is MSB or LSB.
    //        -4. RXMSBFirst   : Control RX Data bit order is MSB or LSB.
   
//    MURT_RX.AdvancedInit.AdvFeatureInit     = (URT_ADVFEATURE_TXDATAINVERT_INIT | URT_ADVFEATURE_TXMSBFIRST_INIT | \
//                                               URT_ADVFEATURE_RXDATAINVERT_INIT | URT_ADVFEATURE_RXMSBFIRST_INIT); 

//    MURT_RX.AdvancedInit.TXDataInvert       = URT_ADVFEATURE_TXDATAINV_ENABLE;
//    MURT_RX.AdvancedInit.RXDataInvert       = URT_ADVFEATURE_RXDATAINV_ENABLE;
//    MURT_RX.AdvancedInit.TXMSBFirst         = URT_ADVFEATURE_MSBFIRST;
//    MURT_RX.AdvancedInit.RXMSBFirst         = URT_ADVFEATURE_MSBFIRST;

    MID_URT_Init( &MURT_RX);
    
    //==============================================================================
    //Enable NVIC IRQ 
    NVIC_EnableIRQ( URT0_IRQn);
    
    //==============================================================================
    //To start receive
    MID_URT_Receive( &MURT_RX , &MID_URTRX_RXBUF[0]  , 10 , 10);      //Receive 10 byte to SampleMID_URT_RXBUF[] , and receive timeout is 10ms

}
