/**
  ******************************************************************************
 *
 * @file        Sample_MID_SYS_GetChipID.c
 *
 * @brief       SYS get chip body sample code
 *
 * @par         Project
 *              MG32
 * @version     V2.5.1
 * @date        2021/09/17
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_Common_MID.h"
#include "MG32_SYS_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_MID_SYS_GetChipID (void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief       RST sample code.
 * @details     1.Get chip ID
 *    \n        2.Check chip ID and show message
 * @return      None
 *******************************************************************************
 */
void Sample_MID_SYS_GetChipID (void)
{
    uint16_t Chip_ID;
    
    
    
    // ------------------------------------------------------------------------
    // 1.Initial master clock
    // ------------------------------------------------------------------------
    Chip_ID = MID_SYS_GetChipBody();
    
    // ------------------------------------------------------------------------
    // 2.Check chip ID and show message
    // ------------------------------------------------------------------------
    // When chip body is A132
    if(Chip_ID == MG32F02A132_ID)
    {
        // Show message "MG32F02A132"
    }
    // When chip body is A072
    else if(Chip_ID == MG32F02A072_ID)
    {
        // Show message "MG32F02A072"
    }
    // When chip body is MA862
    else if(Chip_ID == MA862_ID)
    {
        // Show message "MA862"
    }
    
    else if(Chip_ID == MG32F02A032_ID)
    {
        // Show message "MG32F02A032"
    }
    
    else if(Chip_ID == MG32F02A128_ID)
    {
        // Show message "MG32F02A128"
    }
    else if(Chip_ID == MG32F02A064_ID)
    {
        // Show message "MG32F02A064"
    }
    else if(Chip_ID == MG32F02U128_ID)
    {
        // Show message "MG32F02U128"
    }
    else if(Chip_ID == MG32F02U064_ID)
    {
        // Show message "MG32F02U064"
    }
    
    else if(Chip_ID == MG32F02V032_ID)
    {
        // Show message "MG32F02V032"
        while(1);
    }

}



