/**
  ******************************************************************************
 *
 * @file        Sample_MID_DMA_M2M.c
 *
 * @brief       Example code of DMA M2M with interrupt.
 *
 * @par         Project
 *              MG32
 * @version     V1.12
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_DMA_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
static uint8_t  SrcData[] =
    {
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10
    };
    
static uint8_t  SrcData2[] =
    {
    10, 9, 8, 7, 6, 5, 4, 3, 2, 1
    };
    
static uint8_t  DestArea[10];

/* Private variables ---------------------------------------------------------*/
#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
    #pragma clang diagnostic push
    #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
        DMA_HandleTypeDef mDMA;
    #pragma clang diagnostic pop
#else
    DMA_HandleTypeDef mDMA;
#endif

/* Private function prototypes -----------------------------------------------*/
void DMACopyAgain(DMA_HandleTypeDef *mDMA);
void Sample_MID_DMA_M2M(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


///**
// *******************************************************************************
// * @brief	    DMA IRQ Handler  
// * @details     
// * @return      
// * @exception   No
// * @note
// * @par         Example
// * @code
// * @endcode
// *******************************************************************************
// */
//void DMA_IRQHandler(void)
//{
//    MID_DMA_IRQHandler(&mDMA);
//}

/**
 *******************************************************************************
 * @brief       Start the other DMA M2M routine when the previous DMA complete.
 * @param[in]   mDMAtt : Indicate DMA_HandleTypeDef pointer.
 * @return      None
 *******************************************************************************
 */
void DMACopyAgain(DMA_HandleTypeDef *mDMAtt)
{
    __DRV_DMA_DISABLE_ITEA(mDMAtt);

    MID_DMA_Start(mDMAtt, (uint32_t ) &SrcData2, (uint32_t ) &DestArea, 10);
}

/**
 *******************************************************************************
 * @brief       prepare ADC conversion bypass analog ADC macro
 * @details     1.Setup DMA M2M parameters.
 *    \n        2.indicate DMA complete function call
 *    \n        3.Start DMA M2M (SrcData copy to DestArea - 10 bytes).
 * @return      None
 *******************************************************************************
 */
void Sample_MID_DMA_M2M(void)
{

    // make sure :
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12M
    //  Select CK_PLLI Divider = CK_HS/2
    //  Select CK_PLL Multiplication factor = CK_PLLIx16
    //  Select CK_PLLO Divider = CK_PLL/4
    //Select CK_MAIN Source = CK_PLLO
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->DMA = Enable
    
    // ------------------------------------------------------------------------
    // 1.Setup DMA M2M parameters.
    // ------------------------------------------------------------------------
    mDMA.Instance           = DMA;
    mDMA.DMAChannelIndex    = DMAChannel0;          // only DMA channel0 can support M2M mode  
#if defined(MG32_1ST)
    mDMA.PriorityMode       = DMA_ROUND_ROBIN;      // priority mode
#endif   
    mDMA.ExtraGPL_Channel   = NULL;

    mDMA.Init.SrcPeri       = MID_DMA_MEMORY_READ;  // Source symbol is memory
    mDMA.Init.DesPeri       = MID_DMA_MEMORY_WRITE; // Destination symbol is memory
    mDMA.Init.BSize         = DMA_BSIZE_1BYTE;      // Burst size is 1 byte
    mDMA.Init.MEMMode       = MID_DMA_MEMORY_NORMAL;// Normal memory access mode     
#if defined(MG32_1ST)    
    mDMA.Init.Priority      = DMA_PRIORITY_LOW;     // Priority level setting
#endif   
    mDMA.Init.LoopMode      = DMA_LOOP_DISABLE;     // DISABLE Loop mode
    MID_DMA_Init(&mDMA);

    // ------------------------------------------------------------------------
    // 2.indicate DMA complete function call.
    // ------------------------------------------------------------------------
    mDMA.XferCpltCallback = DMACopyAgain;

    // ------------------------------------------------------------------------
    // 3.Start DMA M2M (SrcData copy to DestArea - 10 bytes).
    // ------------------------------------------------------------------------
    // 3.1 User must select MG32_IRQHandler in ChipInit_Wizard of Manage Run-Time Environment.
    // 3.2 User select 'Enable DMA NVIC' in IRQ_Handler of Manage Run-Time Environment.
    MID_DMA_Start_IT(&mDMA, (uint32_t ) &SrcData, (uint32_t ) &DestArea, 10);
}


