



/**
 ******************************************************************************
 *
 * @file        Sample_EXIC_NMI_Source_Select.c
 * @brief       The demo CPU wake up event pin initialize and confiuration sample C file
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2024/12/04
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *  
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 

/* Includes ------------------------------------------------------------------*/
#include "MG32__Common_DRV.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_EXIC_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_NMI_Source_Select(void);
void NMI_Handler(void);
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
*******************************************************************************
* @brief	   NMI interrupt source select
* @details     1.Port A all pins initialize.
*    \n        2.Port A EXIC Initialize.
*    \n        3.NMI source selection from EXICA
*    \n        4.Enter SLEEP mode to await NMI wake-up signal input.
* @return      
* @exception   No
* @note        
* @par         Example
* @code
* @endcode             
*******************************************************************************
*/
void Sample_NMI_Source_Select(void)
{
    PIN_InitTypeDef  PINX_InitStruct;
    EXIC_TRGSTypeDef EXIC_TRGS;
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 11.0592M or 12.0000MHz
    //Select CK_MAIN Source = CK_HS
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->Port A = Enable if EXIC Port is PortA
    
    
    //====GPIO Initial==== 
    PINX_InitStruct.PINX_Pin                = PX_Pin_All;            // Select the pin of the port to initialize (PX_Pin_All represents all pins of the port).
    PINX_InitStruct.PINX_Mode               = PINX_Mode_OpenDrain_O;          // Select GPIO mode 
                                                                              //     1.QB: Quasi-Bidirection mode only for PC ) 
    PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Enable;        // Please select whether to enable the internal pull-up resistor or not.
    PINX_InitStruct.PINX_Speed              = PINX_Speed_Low;                 // Select wehter enable high speed mode
                                                                              //     1.(PINX_Speed_High mode only for PC0~3 , PD0~3 )    
    PINX_InitStruct.PINX_OUTDrive           = PINX_OUTDrive_Level0;           // Select output drive strength 
                                                                              //     1.(Level 0 & level 3 only for PE0~PE3)
    PINX_InitStruct.PINX_FilterDivider      = PINX_FilterDivider_Bypass;      // Select input filter divider.
    PINX_InitStruct.PINX_Inverse            = PINX_Inverse_Disable;           // Select input signal whether inverse or not.
                                                                              //     1.PINX_Inverse_Disable = L level or falling edge.
                                                                              //     2.PINX_Inverse_Enable  = H level or Rising edge.
    PINX_InitStruct.PINX_Alternate_Function = 0;                              // Select GPIO mode
    GPIO_PortMode_Config(IOMA,&PINX_InitStruct);                              // PorA configuration
    GPIO_WritePort(GPIOA,0xFFFF);                                             // Initialize PortA
    
    //====Port A EXIC function has been initialized.====
    
    
    //===Send Event====
    EXIC_NMI_Cmd(ENABLE);
    EXIC_NMI_Select(EXIC_NMI_EXIN0);
    
    EXIC_GetPxAllTriggerEventFlagStatus(EXIC_PA);
    EXIC_PxTriggerITEA_Cmd(EXIC_PA_IT, ENABLE);
    //EXIC->INT.W = 0x01;             //Enable port A exiternal interrupt
    EXIC_PxTriggerAndMask_Select(EXIC_PA, EXIC_PX_PIN0);
    //EXIC->PA_MSK.W = 0x00010000;    //Enable Port A Mask.(Mask external data can input to chip)
    EXIC_TRGS.EXIC_Pin = EXIC_TRGS_PIN0;
    EXIC_TRGS.EXIC_TRGS_Mode = Edge;
    EXIC_PxTriggerMode_Select(EXIC_PA,&EXIC_TRGS);
    //EXIC->PA_TRGS.W = 2;   //Set trigger is edge trigger.
    
    //=====Enter SLEEP Mode Await Event Input====
    SLEEP_WFI();            // To wake up the CPU, an signal should be sent to PA14.
}

/**
*******************************************************************************
* @brief	   NMI interrupt Handler
* @details     1.Clear EXIC pin trigger event
*    \n        2.Clear EXIC AND trigger event
* @return      
* @exception   No
* @note        
* @par         Example
* @code
* @endcode             
*******************************************************************************
*/
void NMI_Handler(void)
{
    /* USER CODE BEGIN NonMaskableInt_IRQ 0 */
    // to do...
    EXIC_ClearPxTriggerEventFlag(EXIC_PA,EXIC_PX_PIN0);         // Clear EXIC interrupt event.
    EXIC_ClearPxTriggerITFlag(EXIC_PA_ITF, EXIC_PX_AF);         // Clear EXICA AND interrupt flag
    /* USER CODE END NonMaskableInt_IRQ 0 */

    /* USER CODE BEGIN NonMaskableInt_IRQ 1 */
    // to do...
    /* USER CODE END NonMaskableInt_IRQ 1 */
}


