/**
  ******************************************************************************
 *
 * @file        Sample_I2C_ByteMode_Simple.h
 *
 * @brief       This is the C code format sample file for I2C.
 *              include function :
 *                  I2C Module Initial : void Sample_I2C0_Init(void);
 *                  Bus Start : Sample_StatusTypeDef I2C_BusStart(I2C_Struct* I2Cx);
 *                  Master Bus Stop : Sample_StatusTypeDef I2C_Master_BusStop(I2C_Struct* I2Cx);
 *                  Data Transmit : Sample_StatusTypeDef I2C_Transmiter(I2C_Struct* I2Cx, uint8_t TxData);
 *                  Receive Data : Sample_StatusTypeDef I2C_Receive(I2C_Struct* I2Cx, uint8_t *RxData, uint8_t Acknowledge)
 *                  Access 24C EEPROM Sample Code : void Sample_I2C0_Code(void);
 *
 * @par         Project
 *              MG32
 * @version     V1.05
 * @date        2023/06/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2023 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _SAMPLE_I2C_BYTEMODE_SIMPLE_H
#define _SAMPLE_I2C_BYTEMODE_SIMPLE_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"
#include "MG32_I2C.h"

/* Private includes ----------------------------------------------------------*/
/* External functions --------------------------------------------------------*/

/* Private define ------------------------------------------------------------*/
#define I2C_ACK     1   /*!< I2C Ack bit State                              */
#define I2C_NACK    0   /*!< I2C Ack bit State                              */

/* Private macro -------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/

/**
 *******************************************************************************
 * Sample function return state
 *******************************************************************************
 */
typedef enum{
    SUCCESS  = 0x00,    /*!< Success    */
    FAILURE  = 0x01,    /*!< Failure    */
    OK       = 0x00,    /*!< OK         */
    ERROR    = 0x01,    /*!< Error      */
    BUSY     = 0x02,    /*!< Busy       */
    TIMEOUT  = 0x03,    /*!< Timout     */
}Sample_StatusTypeDef;

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
Sample_StatusTypeDef I2C_BusStart(I2C_Struct* I2Cx);
Sample_StatusTypeDef I2C_Master_BusStop(I2C_Struct* I2Cx);
Sample_StatusTypeDef I2C_Transmiter(I2C_Struct* I2Cx, uint8_t TxData);
Sample_StatusTypeDef I2C_Receive(I2C_Struct* I2Cx, uint8_t *RxData, uint8_t Acknowledge);

void Sample_I2C0_Init(void);
void Sample_I2C0_Code(void);

#ifdef __cplusplus
}
#endif

#endif

