

/**
 ******************************************************************************
 *
 * @file        Sample_CAN_Init.h
 * @brief       CAN module initial, transmit and receive sample code.
 *              The sample code use TCAN1462 transceiver.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2025/06/05
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_GPIO_DRV.h"
#include "MG32_CAN_DRV.h"

/* Menu ----------------------------------------------------------------------*/
/* Typedef -------------------------------------------------------------------*/
/* Define --------------------------------------------------------------------*/
#define SMP_CAN_TXMAILBOX_MAX        3        /*!< The CAN module has max tx mailbox buffer*/

#define SMP_CAN_TX_USE_TXMAILBOX0    0        /*!< This trigger transmit use TX mailbox 0..*/
#define SMP_CAN_TX_USE_TXMAILBOX1    1        /*!< This trigger transmit use TX mailbox 1.*/
#define SMP_CAN_TX_USE_TXMAILBOX2    2        /*!< This trigger transmit use TX mailbox 2.*/
#define SMP_CAN_TX_BUSY              0xFA     /*!< This trigger transmit is failure because all TX mailboxs are busy.*/

#define SMP_CAN_TRANSCEIVER_NORMAL   0        /*!< TCAN1462 transceiver normal mode..*/
#define SMP_CAN_TRANSCEIVER_STANDBY  1        /*!< TCAN1462 transceiver standby mode.*/



/* Macro ---------------------------------------------------------------------*/
/* variables -----------------------------------------------------------------*/
/* Functions -----------------------------------------------------------------*/
void Sample_CAN_Init(void);
void Sample_CAN_TransceiverMode_Select( uint8_t CAN_TransceiverMode);
void Sample_CAN_main(void);

uint8_t Sample_CAN_TransmitDataFrame( uint32_t DF_ID, uint8_t DF_IDE, uint8_t DF_DLC, uint8_t *DF_Buf);
uint8_t Sample_CAN_TransmitRemoteFrame( uint32_t DF_ID, uint8_t DF_IDE, uint8_t DF_DLC);

void CAN_TXBuf_CpltCallback(CAN_TXIndex_TypeDef CAN_TxBuf_Index);
void CAN_RxFIFO0_CpltCallback(CAN_RXBuf_TypeDef CAN_Rx1_Frame);
void CAN_RxFIFO1_CpltCallback(CAN_RXBuf_TypeDef CAN_Rx1_Frame);
void CAN_BusError_Callback(void);




