/*
*********************************************************************************************************
*                                     MICIRUM BOARD SUPPORT PACKAGE
*
*                             (c) Copyright 2012; Micrium, Inc.; Weston, FL
*
*               All rights reserved.  Protected by international copyright laws.
*               Knowledge of the source code may NOT be used to develop a similar product.
*               Please help us continue to provide the Embedded community with the finest
*               software available.  Your honesty is greatly appreciated.
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*
*                                        BOARD SUPPORT PACKAGE
*
*                                           megawin MG32
*                                              on the
*
*                                          MG32F02A132-EVAL
*                                          Evaluation Board
*
* Filename      : bsp.h
* Version       : V1.00
* Programmer(s) : FF
*                 MD
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                                 MODULE
*
* Note(s) : (1) This header file is protected from multiple pre-processor inclusion through use of the
*               BSP present pre-processor macro definition.
*
*           (2) This file and its dependencies requires IAR v6.20 or later to be compiled.
*
*********************************************************************************************************
*/

#ifndef  BSP_PRESENT
#define  BSP_PRESENT


/*
*********************************************************************************************************
*                                                 EXTERNS
*********************************************************************************************************
*/

#ifdef   BSP_MODULE
#define  BSP_EXT
#else
#define  BSP_EXT  extern
#endif


/*
*********************************************************************************************************
*                                              INCLUDE FILES
*********************************************************************************************************
*/

#include  <stdio.h>
#include  <stdarg.h>

#include  <cpu.h>
#include  <cpu_core.h>

#include  <lib_def.h>
#include  <lib_ascii.h>

#include  <MG32_DRV.h>
#include "MG32_CSC_Init.h"

/*
*********************************************************************************************************
*                                               CONSTANTS
*********************************************************************************************************
*/


/*
*********************************************************************************************************
*                                             PERIPH DEFINES
*********************************************************************************************************
*/


/*
*********************************************************************************************************
*                                               DATA TYPES
*********************************************************************************************************
*/
typedef struct
{
    CPU_INT32U CK_IHRCO;
    CPU_INT32U CK_HS;
    CPU_INT32U CK_PLLO;
    CPU_INT32U CK_MAIN;
    CPU_INT32U CK_APB;
    CPU_INT32U CK_AHB;
}CSC_ClockTypeDef;


/*
*********************************************************************************************************
*                                            GLOBAL VARIABLES
*********************************************************************************************************
*/


/*
*********************************************************************************************************
*                                                 MACRO'S
*********************************************************************************************************
*/


/*
*********************************************************************************************************
*                                               INT DEFINES
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                             PERIPH DEFINES
*********************************************************************************************************
*/

                                                                /* --------------ENABLES--------------- */
/* AHB                                                          */
#define  BSP_PERIPH_ID_IOPAEN                              0
#define  BSP_PERIPH_ID_IOPBEN                              1
#define  BSP_PERIPH_ID_IOPCEN                              2
#define  BSP_PERIPH_ID_IOPDEN                              3
#define  BSP_PERIPH_ID_IOPEEN                              4
#define  BSP_PERIPH_ID_IOPFEN                              5
#define  BSP_PERIPH_ID_IOPGEN                              6
#define  BSP_PERIPH_ID_IOPHEN                              7
#define  BSP_PERIPH_ID_GPLEN                               8
#define  BSP_PERIPH_ID_EMBEN                               9
#define  BSP_PERIPH_ID_DMAEN                              10

/* APB0                                                         */
#define  BSP_PERIPH_ID_ADC0EN                             32

#define  BSP_PERIPH_ID_CMPEN                              34
#define  BSP_PERIPH_ID_DACEN                              35

#define  BSP_PERIPH_ID_RTCEN                              37
#define  BSP_PERIPH_ID_IWDTEN                             38
#define  BSP_PERIPH_ID_WWDTEN                             39
#define  BSP_PERIPH_ID_I2C0EN                             40
#define  BSP_PERIPH_ID_I2C1EN                             41

#define  BSP_PERIPH_ID_SPI0EN                             44

#define  BSP_PERIPH_ID_URT0                               48
#define  BSP_PERIPH_ID_URT1                               49
#define  BSP_PERIPH_ID_URT2                               50
#define  BSP_PERIPH_ID_URT3                               51

#define  BSP_PERIPH_ID_USB                                56

/* APB1                                                         */
#define  BSP_PERIPH_ID_TM00EN                             64
#define  BSP_PERIPH_ID_TM01EN                             65

#define  BSP_PERIPH_ID_TM10EN                             68

#define  BSP_PERIPH_ID_TM16EN                             71
#define  BSP_PERIPH_ID_TM20EN                             72

#define  BSP_PERIPH_ID_TM26EN                             75

#define  BSP_PERIPH_ID_TM36EN                             79


/*
*********************************************************************************************************
*                                           FUNCTION PROTOTYPES
*********************************************************************************************************
*/

void        BSP_Init                          (void);

void        BSP_IntDisAll                     (void);

void        BSP_ClkFreq                       (CSC_ClockTypeDef* CSC_Clock);

CPU_INT32U  BSP_CPU_ClkFreq                   (void);

/*
*********************************************************************************************************
*                                           INTERRUPT SERVICES
*********************************************************************************************************
*/

void        BSP_IntInit                       (void);

void        BSP_IntEn                         (CPU_DATA       int_id);

void        BSP_IntDis                        (CPU_DATA       int_id);

void        BSP_IntClr                        (CPU_DATA       int_id);

void        BSP_IntVectSet                    (CPU_DATA       int_id,
                                               CPU_FNCT_VOID  isr);

void        BSP_IntPrioSet                    (CPU_DATA       int_id,
                                               CPU_INT08U     prio);

void    WWDT_IRQHandler     (void);
void    SYS_IRQHandler      (void);
void    EXINT0_IRQHandler   (void);
void    EXINT1_IRQHandler   (void);
void    EXINT2_IRQHandler   (void);
void    EXINT3_IRQHandler   (void);
void    COMP_IRQHandler     (void);
void    DMA_IRQHandler      (void);
void    ADC_IRQHandler      (void);
void    DAC_IRQHandler      (void);
void    TM0x_IRQHandler     (void);
void    TM10_IRQHandler     (void);
void    TM1x_IRQHandler     (void);
void    TM20_IRQHandler     (void);
void    TM2x_IRQHandler     (void);
void    TM3x_IRQHandler     (void);
void    URT0_IRQHandler     (void);
void    URT123_IRQHandler   (void);
void    SPI0_IRQHandler     (void);
void    I2C0_IRQHandler     (void);
void    I2Cx_IRQHandler     (void);
void    USB_IRQHandler      (void);



/*
*********************************************************************************************************
*                                     PERIPHERAL POWER/CLOCK SERVICES
*********************************************************************************************************
*/

CPU_INT32U  BSP_PeriphClkFreqGet               (CPU_DATA       pwr_clk_id);

void        BSP_PeriphEn                       (CPU_DATA       pwr_clk_id);

void        BSP_PeriphDis                      (CPU_DATA       pwr_clk_id);

/*
*********************************************************************************************************
*                                              LED SERVICES
*********************************************************************************************************
*/

void        BSP_LED_On                          (CPU_INT08U     led);

void        BSP_LED_Off                         (CPU_INT08U     led);

void        BSP_LED_Toggle                      (CPU_INT08U     led);

/*
*********************************************************************************************************
*                                             MODULE END
*********************************************************************************************************
*/


#endif                                                          /* End of module include.                               */

