


/**
 ******************************************************************************
 *
 * @file        MG32_RGBTable_API.c
 * @brief       The RGB Table c file.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/05/03
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
 
#include "MG32.h"
#include "MG32_RGB_API.h"
#include "MG32_USBD_Keyboard_API.h"


#if MG32_USBD_KEYBOARD_RGB_EN != API_RGB_DISABLE

/**
 * @name Control RGB Power Pin Define. 
 *   		
 */ 
///@{
uint16_t  API_RGB_PWPIN_TABLE[11] = { API_RGB_Y0_PIN, API_RGB_Y1_PIN, API_RGB_Y2_PIN, API_RGB_Y3_PIN, API_RGB_Y4_PIN, API_RGB_Y5_PIN,
                                      API_RGB_Y6_PIN, API_RGB_Y7_PIN, API_RGB_Y8_PIN, API_RGB_Y9_PIN, API_RGB_Y10_PIN };
///@}

                                      
                                                                           
uint8_t  API_RGB_DOT_TABLE[45] = {
                                      80,   110,   110,           // { R0 , G0  , B0  }
                                      80,   110,   110,           // { R1 , G1  , B1  }
                                      80,   110,   110,           // { R2 , G2  , B2  }
                                      80,   110,   110,           // { R3 , G3  , B3  }
                                      80,   110,   110,           // { R4 , G4  , B4  }
                                      80,   110,   110,           // { R5 , G5  , B5  }
                                      80,   110,   110,           // { R6 , G6  , B6  }
                                      80,   110,   110,           // { R7 , G7  , B7  }
                                      80,   110,   110,           // { R8 , G8  , B8  }
                                      80,   110,   110,           // { R9 , G9  , B9  }
                                      80,   110,   110,           // { R10, G10 , B10 }
                                      80,   110,   110,           // { R11, G11 , B11 }
                                      80,   110,   110,           // { R12, G12 , B12 }
                                      80,   110,   110,           // { R13, G13 , B13 }
                                      80,   110,   110,           // { R14, G14 , B14 }
                                  };



uint8_t const API_KB_ATable[KB_TOTAL_KEY] = 
{         //        V           V           V           V           V           V              V            V           V           V           V  
//Column            0           1           2           3           4           5              6            7           8           9          10          11     // Row
                    3,         25,         48,         71, API_RGB_NA,        117,            15,          36,         59, API_RGB_NA, API_RGB_NA,        129,    // 2
                    4,         26,         49,         72,         95,        118,    API_RGB_NA,          37,         61,         83,        106,        130,    // 3
                    5,         27,         50,         73,         96, API_RGB_NA,            16,          39,         62, API_RGB_NA, API_RGB_NA,        131,    // 4
                    6,         28,         51,         74,         97, API_RGB_NA,            17,          40,         63, API_RGB_NA,        109,        132,    // 5
                    0,         23,         46,         69,         92,        115,            13,          34,         57,         80,        103,        127,    // 0
                    1,         24,         47,         70,         93,        116,            14,          35,         58,         81,        104, API_RGB_NA,    // 1
           API_RGB_NA, API_RGB_NA, API_RGB_NA, API_RGB_NA, API_RGB_NA, API_RGB_NA,    API_RGB_NA,  API_RGB_NA, API_RGB_NA, API_RGB_NA, API_RGB_NA, API_RGB_NA,    // 11  
                    7,         29,         52,         75,         98,        122,            18,          41,         64, API_RGB_NA, API_RGB_NA,        133,    // 6
                    8,         30,         53,         76,         99, API_RGB_NA,    API_RGB_NA,  API_RGB_NA,         42,         65,         88,        111,    // 7	
                    9,         31,         54,         77,        100, API_RGB_NA,    API_RGB_NA,          43,         66,         89,        112,        134,    // 8
                   10,         32,         55,         78,        101, API_RGB_NA,    API_RGB_NA,          44,         67,         90,        113,        136,    // 9
                   12,         33,         56,         79,        102,        126,    API_RGB_NA,          45,         68, API_RGB_NA,        114, API_RGB_NA,    // 10
};

/**
 * @name RGB Static User Mode table.
 *   		
 */ 
///@{ 
uint16_t const API_KBRGBDefault_RColorTable[API_RGB_KBTotalLine][API_RGB_KBTotalColume] = 
{
    
    {65025, 65025, 65025, 65025, 65025, 63495, 51255, 40290, 28050, 17340,   255,   255,   255,   255,   255,   255,   255,   255,   255, 35700, 46410, 58905, 65025},
    {65025, 65025, 65025, 65025, 65025, 60180, 49215, 39525, 28560, 18870,  3825,  3825,  3825,  3825,  3825,  3825,  3825,  3825,  3825, 35445, 44880, 55845, 61455},
    {65025, 65025, 65025, 65025, 65025, 56610, 47175, 38760, 29070, 20655,  7395,  7395,  7395,  7395,  7395,  7395,  7395,  7395,  7395, 34935, 43350, 53040, 57885},
    {65025, 65025, 65025, 65025, 65025, 53295, 45135, 37740, 29580, 22440, 10965, 10965, 10965, 10965, 10965, 10965, 10965, 10965, 10965, 34680, 41820, 50235, 54315},
    {65025, 65025, 65025, 65025, 65025, 49980, 43095, 36975, 30090, 23970, 14535, 14535, 14535, 14535, 14535, 14535, 14535, 14535, 14535, 34425, 40290, 47175, 50745},
    {65025, 65025, 65025, 65025, 65025, 46410, 41055, 36210, 30600, 25755, 18105, 18105, 18105, 18105, 18105, 18105, 18105, 18105, 18105, 33915, 38760, 44370, 47175},
};

uint16_t const API_KBRGBDefault_GColorTable[API_RGB_KBTotalLine][API_RGB_KBTotalColume] = 
{
    {  255, 23460, 34170, 46410, 57375, 65025, 65025, 65025, 65025, 65025, 65025, 65025, 65025, 57375, 44880, 34170, 21930, 10965,   255,   255,   255,   255,   255}, 
    { 3825, 24480, 33915, 44880, 54570, 61455, 61455, 61455, 61455, 61455, 61455, 61455, 61455, 54570, 43605, 33915, 22950, 13515,  3825,  3825,  3825,  3825,  3825}, 
    { 7395, 25500, 33915, 43350, 51765, 57885, 57885, 57885, 57885, 57885, 57885, 57885, 57885, 51765, 42330, 33915, 24225, 15810,  7395,  7395,  7395,  7395,  7395}, 
    {10965, 26520, 33660, 41820, 49215, 54315, 54315, 54315, 54315, 54315, 54315, 54315, 54315, 49215, 40800, 33660, 25500, 18105, 10965, 10965, 10965, 10965, 10965}, 
    {14535, 27540, 33405, 40290, 45410, 50745, 50745, 50745, 50745, 50745, 50745, 50745, 50745, 46410, 39525, 33405, 26520, 20655, 14535, 14535, 14535, 14535, 14535}, 
    {18105, 28560, 33405, 38760, 43605, 47175, 47175, 47175, 47175, 47175, 47175, 47175, 47175, 43605, 38250, 33405, 27795, 22950, 18105, 18105, 18105, 18105, 18105}, 
};  
    
uint16_t const API_KBRGBDefault_BColorTable[API_RGB_KBTotalLine][API_RGB_KBTotalColume] = 
{
    {  255,   255,   255,   255,   255,   255,   255,   255,   255,   255, 40290, 52785, 63495, 63495, 63495, 63495, 63495, 63495, 63495, 63495, 63495, 65025, 61965},
    { 3825,  3825,  3825,  3825,  3825,  3825,  3825,  3825,  3825,  3825, 39525, 50490, 60180, 60180, 60180, 60180, 60180, 60180, 60180, 60180, 60180, 61455, 58650},
    { 7395,  7395,  7395,  7395,  7395,  7395,  7395,  7395,  7395,  7395, 38760, 48195, 56610, 56610, 56610, 56610, 56610, 56610, 56610, 56610, 56610, 57885, 55590},
    {10965, 10965, 10965, 10965, 10965, 10965, 10965, 10965, 10965, 10965, 37740, 46155, 53295, 53295, 53295, 53295, 53295, 53295, 53295, 53295, 53295, 54315, 52275},
    {14535, 14535, 14535, 14535, 14535, 14535, 14535, 14535, 14535, 14535, 36975, 43860, 49980, 49980, 49980, 49980, 49980, 49980, 49980, 49980, 49980, 50745, 48960},
    {18105, 18105, 18105, 18105, 18105, 18105, 18105, 18105, 18105, 18105, 36210, 41565, 47175, 47175, 47175, 47175, 47175, 47175, 47175, 47175, 47175, 47175, 45900},
};    
///@}
/**
 * @name 
 *   		
 */ 
///@{
uint8_t const API_KBRGBDemo_RColorTable[6] = { 255, 255,   0,   0,   0, 255};
uint8_t const API_KBRGBDemo_GColorTable[6] = {   0, 255, 255, 255,   0,   0};
uint8_t const API_KBRGBDemo_BColorTable[6] = {   0,   0,   0, 255, 255, 255};
///@}



/**
 * @name RGB Physical Location Mapping To LED Driver Data Format Table.
 *   		
 */ 
///@{

#if MG32_USBD_KEYBOARD_RGB_EN == API_RGB_TLC5948
// Bit15 ~ Bit12 : It is which LED driver. , Bit11 ~ Bit0 : It is which data byte.
uint16_t const API_RGB_PWMData_Table[API_RGB_KBTotalLine][API_RGB_KBTotalColume] = 
{
  //            0,           1,           2,            3,            4,            5,            6             7,            8,            9,           10,           11,           12,           13,           14,           15,           16,           17,           18,           19,           20,           21,           22,                                           
     {0x1000 | 24, 0x1000 | 56, 0x0000 |  0, 0x1000 |  88, 0x1000 | 120, 0x1000 | 152, 0x1000 | 184, 0x1000 | 216, 0x1000 | 248, 0x1000 | 280, 0x1000 | 312, 0x0000 |   0, 0x1000 | 344, 0x2000 |  18, 0x2000 |  50, 0x2000 |  82, 0x2000 | 146, 0x2000 | 178, 0x2000 | 210, 0x0000 |   0, 0x0000 |   0, 0x0000 |   0, 0x0000 |   0}, // 0
     {0x1000 | 18, 0x1000 | 50, 0x1000 | 82, 0x1000 | 114, 0x1000 | 146, 0x1000 | 178, 0x1000 | 210, 0x1000 | 242, 0x1000 | 274, 0x1000 | 306, 0x1000 | 338, 0x2000 |  12, 0x2000 |  44, 0x2000 |  76, 0x2000 | 108, 0x0000 |   0, 0x2000 | 140, 0x2000 | 172, 0x2000 | 204, 0x2000 | 230, 0x2000 | 268, 0x2000 | 300, 0x2000 | 332}, // 1
     {0x1000 | 12, 0x1000 | 44, 0x1000 | 76, 0x1000 | 108, 0x1000 | 140, 0x1000 | 172, 0x1000 | 204, 0x1000 | 236, 0x1000 | 268, 0x1000 | 300, 0x1000 | 332, 0x2000 |   6, 0x2000 |  38, 0x2000 |  70, 0x0000 |   0, 0x2000 | 102, 0x2000 | 134, 0x2000 | 166, 0x2000 | 198, 0x2000 | 224, 0x2000 | 262, 0x2000 | 294, 0x2000 | 326}, // 2
     {0x1000 |  6, 0x1000 | 38, 0x1000 | 70, 0x1000 | 102, 0x1000 | 134, 0x1000 | 166, 0x1000 | 198, 0x1000 | 230, 0x1000 | 262, 0x1000 | 294, 0x1000 | 326, 0x2000 |   0, 0x2000 |  32, 0x0000 |   0, 0x2000 |  96, 0x0000 |   0, 0x0000 |   0, 0x0000 |   0, 0x0000 |   0, 0x3000 | 248, 0x2000 | 256, 0x2000 | 288, 0x0000 |   0}, // 3
     {0x1000 |  0, 0x1000 | 32, 0x0000 |  0, 0x1000 |  96, 0x1000 | 128, 0x1000 | 160, 0x1000 | 192, 0x1000 | 224, 0x1000 | 256, 0x1000 | 288, 0x1000 | 320, 0x3000 |  24, 0x3000 |  56, 0x0000 |   0, 0x3000 | 120, 0x0000 |   0, 0x0000 |   0, 0x3000 | 184, 0x0000 |   0, 0x3000 | 242, 0x3000 | 280, 0x3000 | 312, 0x3000 | 344}, // 4
     {0x2000 | 24, 0x2000 | 56, 0x2000 | 88, 0x2000 | 120, 0x0000 |   0, 0x0000 |   0, 0x0000 |   0, 0x2000 | 216, 0x0000 |   0, 0x0000 |   0, 0x0000 |   0, 0x2000 | 344, 0x3000 |  18, 0x0000 |   0, 0x3000 |  82, 0x3000 | 114, 0x3000 | 146, 0x3000 | 178, 0x3000 | 210, 0x3000 | 274, 0x0000 |   0, 0x3000 | 306, 0x0000 |   0}, // 5
};
#endif
#if MG32_USBD_KEYBOARD_RGB_EN == API_RGB_MBIA045
// Bit15 ~ Bit12 : It is which LED power line ( If the value is F represent no RGB). , Bit11 ~ Bit0 : It is which data byte.
uint16_t const API_RGB_PWMData_Table[API_RGB_KBTotalLine][API_RGB_KBTotalColume] = 
{
  //            0,           1,           2,           3,           4,           5,           6            7,           8,           9,          10,          11,          12,          13,          14,          15,          16,          17,          18,          19,          20,          21,          22,                                           
     {0x0000 | 76, 0x1000 | 76, 0xF000 | 00, 0x2000 | 76, 0x3000 | 76, 0x4000 | 76, 0x5000 | 76, 0x6000 | 76, 0x7000 | 76, 0x8000 | 76, 0x9000 | 76, 0xF000 | 00, 0xA000 | 76, 0x0000 | 56, 0x1000 | 56, 0x2000 | 56, 0x4000 | 56, 0x5000 | 56, 0x6000 | 56, 0xF000 | 00, 0xF000 | 00, 0xF000 | 00, 0xF000 | 00}, // 0
     {0x0000 | 58, 0x1000 | 58, 0x2000 | 58, 0x3000 | 58, 0x4000 | 58, 0x5000 | 58, 0x6000 | 58, 0x7000 | 58, 0x8000 | 58, 0x9000 | 58, 0xA000 | 58, 0x0000 | 38, 0x1000 | 38, 0x2000 | 38, 0x3000 | 38, 0xF000 | 00, 0x4000 | 38, 0x5000 | 38, 0x6000 | 38, 0x7000 | 20, 0x8000 | 38, 0x9000 | 38, 0xA000 | 38}, // 1
     {0x0000 | 40, 0x1000 | 40, 0x2000 | 40, 0x3000 | 40, 0x4000 | 40, 0x5000 | 40, 0x6000 | 40, 0x7000 | 40, 0x8000 | 40, 0x9000 | 40, 0xA000 | 40, 0x0000 | 20, 0x1000 | 20, 0x2000 | 20, 0xF000 | 00, 0x3000 | 20, 0x4000 | 20, 0x5000 | 20, 0x6000 | 20, 0x7000 | 02, 0x8000 | 20, 0x9000 | 20, 0xA000 | 20}, // 2
     {0x0000 | 22, 0x1000 | 22, 0x2000 | 22, 0x3000 | 22, 0x4000 | 22, 0x5000 | 22, 0x6000 | 22, 0x7000 | 22, 0x8000 | 22, 0x9000 | 22, 0xA000 | 22, 0x0000 | 02, 0x1000 | 02, 0xF000 | 00, 0x3000 | 02, 0xF000 | 00, 0xF000 | 00, 0xF000 | 00, 0xF000 | 00, 0x7000 | 72, 0x8000 | 02, 0x9000 | 02, 0xF000 | 00}, // 3
     {0x0000 | 04, 0x1000 | 04, 0xF000 | 00, 0x3000 | 04, 0x4000 | 04, 0x5000 | 04, 0x6000 | 04, 0x7000 | 04, 0x8000 | 04, 0x9000 | 04, 0xA000 | 04, 0x0000 | 72, 0x1000 | 72, 0xF000 | 00, 0x3000 | 72, 0xF000 | 00, 0xF000 | 00, 0x5000 | 72, 0xF000 | 00, 0x7000 | 54, 0x8000 | 72, 0x9000 | 72, 0xA000 | 72}, // 4
     {0x0000 | 74, 0x1000 | 74, 0x2000 | 74, 0x3000 | 74, 0xF000 | 00, 0xF000 | 00, 0xF000 | 00, 0x6000 | 74, 0xF000 | 00, 0xF000 | 00, 0xF000 | 00, 0xA000 | 74, 0x0000 | 54, 0xF000 | 00, 0x2000 | 54, 0x3000 | 54, 0x4000 | 54, 0x5000 | 54, 0x6000 | 54, 0x8000 | 54, 0xF000 | 00, 0x9000 | 54, 0xF000 | 00}, // 5
};

#endif
///@}



#endif
































                          
                                  

