

/**
 ******************************************************************************
 *
 * @file        BSP_EEPROM.h
 * @brief       This is EEPROM (24C16) H file.
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2022/04/20
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _BSP_14_EEPROM_H

#define _BSP_14_EEPROM_H

#include "MG32_GPIO_DRV.h"
#include "MG32_TM_DRV.h"
#include "MG32_I2C_DRV.h"


/**
 * @name define
 *   		
 */ 
///@{
//EEPROM status define
#define EEPROM_STATUS_SUCCESS  0
#define EEPROM_STATUS_FAILURE  1

///@}

/**
 * @name function
 *   		
 */ 
///@{
void BSP_EEPROM_Init(void);

void BSP_EEPROM_Read(uint8_t Address, uint8_t *pData, uint16_t Size);
void BSP_EEPROM_PageWrite( uint8_t Address, uint8_t* pData, uint16_t Size);
///@}


#endif



