

/**
 ******************************************************************************
 *
 * @file        main.C
 * @brief       MG32 demo main c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.06
 * @date        2024/09/24
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */



/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"
#include "MG32_ChipInit.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#if defined(MG32_2ND)
    #define MG_EB_LED1     PD8
    #define MG_EB_LED2     PD9
    #define MG_EB_LED3     PD10
    #define MG_EB_RGBR     PC2               /*!< RGB Red control pin for EV Board*/
    #define MG_EB_RGBG     PD0               /*!< RGB Green control pin for EV Board*/
    #define MG_EB_RGBB     PC0               /*!< RGB Blue control pin for EV Board*/
    
    #define MG_EB_LED1SET  PIND(8)
    #define MG_EB_LED2SET  PIND(9)
    #define MG_EB_LED3SET  PIND(10)
    #define MG_EB_RGBRSET  PINC(2)
    #define MG_EB_RGBGSET  PIND(0)
    #define MG_EB_RGBBSET  PINC(0)    
#endif
#if defined(MG32_1ST) || defined(MG32_3RD)                     
    #define MG_EB_LED1     PE13
    #define MG_EB_LED2     PE14
    #define MG_EB_LED3     PE15
    #define MG_EB_RGBR     PC2               /*!< RGB Red control pin for EV Board*/
    #define MG_EB_RGBG     PD0               /*!< RGB Green control pin for EV Board*/
    #define MG_EB_RGBB     PC0               /*!< RGB Blue control pin for EV Board*/
    
    #define MG_EB_LED1SET  PINE(13)
    #define MG_EB_LED2SET  PINE(14)
    #define MG_EB_LED3SET  PINE(15)
    #define MG_EB_RGBRSET  PINC(2)
    #define MG_EB_RGBGSET  PIND(0)
    #define MG_EB_RGBBSET  PINC(0)
#endif
#if defined(MG32_4TH)
    #define MG_EB_LED1     PA8
    #define MG_EB_LED2     PC1
    #define MG_EB_LED3     PC13
    #define MG_EB_RGBR     PC14              /*!< RGB Red control pin for EV Board*/
    #define MG_EB_RGBG     PA10              /*!< RGB Green control pin for EV Board*/
    #define MG_EB_RGBB     PC0               /*!< RGB Blue control pin for EV Board*/
    
    #define MG_EB_LED1SET  PINA(8)
    #define MG_EB_LED2SET  PINC(1)
    #define MG_EB_LED3SET  PINC(13)
    #define MG_EB_RGBRSET  PINC(14)
    #define MG_EB_RGBGSET  PINA(10)
    #define MG_EB_RGBBSET  PINC(0)
#endif
#if defined(MG32_5TH)
    #define MG_EB_LED1     PC0
    #define MG_EB_LED2     PC2
    #define MG_EB_LED3     PA2
    
    #define MG_EB_LED1SET  PINC(0)
    #define MG_EB_LED2SET  PINC(2)
    #define MG_EB_LED3SET  PINA(2)
#endif

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


int main(void)
{    
    PIN_InitTypeDef        PINX_InitStruct;
    
    // ------------------------------------------------------------------------
    // chip initial (User can enable CSC, GPIO, TM, ADC, EXIC ... wizard)
    // ------------------------------------------------------------------------
    ChipInit();    
    
    
    // ------------------------------------------------------------------------
    //System Tick initial
    InitTick(12000000UL, 0); // 1ms Tick
    
    // ------------------------------------------------------------------------
    PINX_InitStruct.PINX_Mode				= PINX_Mode_PushPull_O;
    PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Enable;
    PINX_InitStruct.PINX_Speed              = PINX_Speed_Low;
    PINX_InitStruct.PINX_OUTDrive           = PINX_OUTDrive_Level0;
    PINX_InitStruct.PINX_FilterDivider      = PINX_FilterDivider_Bypass;
    PINX_InitStruct.PINX_Inverse            = PINX_Inverse_Disable;
    PINX_InitStruct.PINX_Alternate_Function = 0;

    #if defined(MG_EB_LED1)
        GPIO_PinMode_Config(MG_EB_LED1SET,&PINX_InitStruct);
    #endif
    #if defined(MG_EB_LED2)
        GPIO_PinMode_Config(MG_EB_LED2SET,&PINX_InitStruct);
    #endif
    #if defined(MG_EB_LED3)
        GPIO_PinMode_Config(MG_EB_LED3SET,&PINX_InitStruct);
    #endif
    #if defined(MG_EB_RGBR) && defined(MG_EB_RGBG) && defined(MG_EB_RGBB)
        GPIO_PinMode_Config(MG_EB_RGBRSET,&PINX_InitStruct);
        GPIO_PinMode_Config(MG_EB_RGBGSET,&PINX_InitStruct);
        GPIO_PinMode_Config(MG_EB_RGBBSET,&PINX_InitStruct);
    #endif
    
    while(1)
    {
        //To do......
        #if defined(MG_EB_LED1)
            MG_EB_LED1 = 0;
        #endif
        #if defined(MG_EB_LED2)        
            MG_EB_LED2 = 1;
        #endif
        #if defined(MG_EB_LED3)        
            MG_EB_LED3 = 1;
        #endif
        #if defined(MG_EB_RGBR) && defined(MG_EB_RGBG) && defined(MG_EB_RGBB)
            MG_EB_RGBR = 0; 
            MG_EB_RGBG = 1; 
            MG_EB_RGBB = 1;
        #endif
        Delay(600);
        #if defined(MG_EB_LED1)
            MG_EB_LED1 = 1; 
        #endif
        #if defined(MG_EB_LED2)
            MG_EB_LED2 = 0;
        #endif
        #if defined(MG_EB_LED3)
            MG_EB_LED3 = 1;
        #endif
        #if defined(MG_EB_RGBR) && defined(MG_EB_RGBG) && defined(MG_EB_RGBB)
            MG_EB_RGBR = 0; 
            MG_EB_RGBG = 0; 
            MG_EB_RGBB = 1;
        #endif
        Delay(600);
        #if defined(MG_EB_LED1)
            MG_EB_LED1 = 1;
        #endif
        #if defined(MG_EB_LED2)
            MG_EB_LED2 = 1;
        #endif
        #if defined(MG_EB_LED3)        
            MG_EB_LED3 = 0;
        #endif
        #if defined(MG_EB_RGBR) && defined(MG_EB_RGBG) && defined(MG_EB_RGBB)
            MG_EB_RGBR = 1; 
            MG_EB_RGBG = 0; 
            MG_EB_RGBB = 1;
        #endif
        Delay(600);
    }
}




















