
/**
 ******************************************************************************
 *
 * @file        Common.c
 *
 * @brief       
 *
 * @par         Project
 *              Smart Card
 * @version     V1.00
 * @date        2022/11/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */ 


/* Includes ------------------------------------------------------------------*/
#include "MG32_GPIO_DRV.h"
#include "MG32_DMA_DRV.h"

/* Typedef -----------------------------------------------------------*/

/*! @enum   PINX_Mode_TypeDef
    @brief  Pin IO mode control options .
*/
typedef enum
{
    Analog_Mode          = 0,       /*!< Analog IO*/
    Data_DIR_OUT_QB      = 1,       /*!< Qusi-bidirection output*/
    Data_DIR_OUT_OD_NoRU = 2,       /*!< Open drain output and disable internal pull-up resistance*/
    Data_DIR_OUT_OD_RU   = 3,       /*!< Open drain output with internal pull-up resistance*/
    Data_DIR_OUT_PP      = 4,       /*!< Push pull output.*/
    Data_DIR_IN_NoRU     = 5,       /*!< Digital input and disable internal pull-up resistance.*/
    Data_DIR_IN_RU       = 6,       /*!< Digital input with internal pull up resistance*/
    
}GPIO_Mode_TypeDef;



/* Define ------------------------------------------------------------*/
//DMA
#define SmartCard_TX_DMA_Channel        DMAChannel1
#define SmartCard_RX_DMA_Channel        DMAChannel2

#define SmartCard_TX_DMA_FLAG           DMA_FLAG_CH1_TCF
#define SmartCard_RX_DMA_FLAG           DMA_FLAG_CH2_TCF

#define SmartCard_TX_DMA_DEST           DMA_URT1_TX
#define SmartCard_RX_DMA_SRC            DMA_URT1_RX

/* Macro -------------------------------------------------------------*/
/* Exported variables ------------------------------------------------*/
/* Exported functions -----------------------------------------------*/
void DMA_Init(void);
void Delay( uint32_t DelayTime);

void API_GPIO_PinConfig(Pin_Struct* PinName , GPIO_Mode_TypeDef PinMode , uint8_t PinAFS);
void API_UARTConnector0_Init(void);
void API_IncTick(void);
uint32_t API_GetTick(void);
void API_InitTick( uint32_t BSP_TickPriority);


