

/**
 ******************************************************************************
 *
 * @file        BSP_VariableResistor.h
 * @brief       This is Variable Resistor H file.
 
 * @par         Project
 *              MG32F02N128
 * @version     V1.00
 * @date        2024/08/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
#ifndef _BSP_VARIABLERESISTOR_H

#define _BSP_VARIABLERESISTOR_H


/* Includes ------------------------------------------------------------------*/
#include "MG32_GPIO_DRV.h"
#include "MG32_ADC_DRV.h"


/* Menu ----------------------------------------------------------------------*/
/* Define --------------------------------------------------------------------*/
#define VR1_ADC_CHANNEL     0                       /*!< VR1 use ADC channel.*/

/* Typedef -------------------------------------------------------------------*/
/* Macro ---------------------------------------------------------------------*/
/* variables -----------------------------------------------------------------*/
/* Functions -----------------------------------------------------------------*/
void BSP_VR_Init(void);
void BSP_VR_Trigger(void);
void BSP_VR_DischargeTrigger(void);
void BSP_VR_Handler(void);

void     BSP_VR_SkipADCData(void);
uint16_t BSP_VR_GetADCData(void); 
uint8_t  BSP_VR_GetPercentage(void); 

void     BSP_VR_ChangeCallback(void);
 
#endif














