



/**
 ******************************************************************************
 *
 * @file        
 * @brief        
 *
 * @par         Project
 *              MG32F02N128
 * @version     V1.00
 * @date        2024/08/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_APX_DRV.h"

/* Menu ----------------------------------------------------------------------*/
/* Typedef -------------------------------------------------------------------*/
/* Define --------------------------------------------------------------------*/
#define BSP_ARGB_SUCCESS        0
#define BSP_ARGB_FAILURE        1


#define __BSP_ARGB_IT_DISABLE(__INT__)   APX->INT.W = APX->INT.W & (~(__INT__))
#define __BSP_ARGB_IT_ENABLE(__INT__)    APX->INT.W = APX->INT.W | (__INT__)



/* Macro ---------------------------------------------------------------------*/
/* variables -----------------------------------------------------------------*/
/* Functions -----------------------------------------------------------------*/
void BSP_ARGB_Init(void);
void BSP_ARGB_ParameterInit(void);

void BSP_ARGB_IRQHandler(void);

void BSP_ARGB_SendDataCpltCallback(void);
uint32_t BSP_ARGB_SendData(uint8_t *ARGB_Buf, uint16_t ARGB_UpdateByteSize);





