/**
 *******************************************************************************
 * @file        MG32_SPI_Init.h
 *
 * @brief       The SPI initial code h file
 *
 * MG32 remote controller
 * @version     V1.04
 * @date        2023/04/06
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#include "MG32.h"
#include "MG32_SPI.h"
#include "MG32_SPI_DRV.h"
#if defined(IRQHandler_Middleware_Level_)       
    #include "MG32_SPI_MID.h"
#endif

#ifndef _MG32_SPI_INIT_H

#define _MG32_SPI_INIT_H


/**
 ******************************************************************************
 *
 * @struct      SPI_InitConfig[]
 *              SPI initial configuration array
 *
 ******************************************************************************
 */
//*** <<< Use Configuration Wizard in Context Menu >>> ***
//<h> SPI0 Configure
//  <o> Mode <0=> Disable
//           <1=> Slave 
//           <17=> Master
#define     CONF_SPI0_MODE              17

    /*=== Master Configuration ===*/
//  <h> Master Configuration
//      <e.8> Enable NSS Signal
#define     CONF_SPI0_MST_NSSO_EN       0x00000000
//          <o> Select NSS Output Control By <0x00000000=> Hardware
//                                           <0x00000800=> Software
//          <i> When select software NSS output control by "SPI_NSSOutputStatusControl_SW".
#define     CONF_SPI0_MST_NSS_SWEN      0x00000000
//      </e>

//      <h> Basic Parameter
//          <o> Data Size <0x00040000=> 4 Bits  
//                        <0x00050000=> 5 Bits  
//                        <0x00060000=> 6 Bits  
//                        <0x00070000=> 7 Bits  
//                        <0x00080000=> 8 Bits  
//                        <0x00090000=> 9 Bits  
//                        <0x000A0000=> 10 Bits  
//                        <0x000B0000=> 11 Bits  
//                        <0x000C0000=> 12 Bits  
//                        <0x000D0000=> 13 Bits  
//                        <0x000E0000=> 14 Bits  
//                        <0x000F0000=> 15 Bits  
//                        <0x00100000=> 16 Bits  
//                        <0x00110000=> 17 Bits  
//                        <0x00120000=> 18 Bits  
//                        <0x00130000=> 19 Bits  
//                        <0x00140000=> 20 Bits  
//                        <0x00150000=> 21 Bits  
//                        <0x00160000=> 22 Bits  
//                        <0x00170000=> 23 Bits  
//                        <0x00180000=> 24 Bits  
//                        <0x00190000=> 25 Bits  
//                        <0x001A0000=> 26 Bits  
//                        <0x001B0000=> 27 Bits  
//                        <0x001C0000=> 28 Bits  
//                        <0x001D0000=> 29 Bits  
//                        <0x001E0000=> 30 Bits  
//                        <0x001F0000=> 31 Bits  
//                        <0x00000000=> 32 Bits
#define     CONF_SPI0_MST_DATA_SIZE     0x00080000
//          <o> First Bit <0x00000000=> MSB First
//                        <0x00000008=> LSB First
#define     CONF_SPI0_MST_LSB           0x00000000
//      </h>

//      <h> Clock Parameter
//          <o> Predivider <0x00000000=> 1
//                         <0x00001000=> 2
//                         <0x00002000=> 4
//                         <0x00003000=> 8
#define     CONF_SPI0_MST_PDIVIDER      0x00000000
//          <o> Prescaler <0x00000000=> 1
//                        <0x00000100=> 2
//                        <0x00000200=> 3
//                        <0x00000300=> 4
//                        <0x00000400=> 5
//                        <0x00000500=> 6
//                        <0x00000600=> 7
//                        <0x00000700=> 8
#define     CONF_SPI0_MST_PRESCALER     0x00000200
//          <o> Divider <0x00000000=> 2
//                      <0x00000010=> 4
//                      <0x00000020=> 8
//                      <0x00000030=> 16
#define     CONF_SPI0_MST_DIVIDER       0x00000000
//          <o> Clock Source <0x00000000=> PROC
//                           <0x00000008=> TM00_TRGO
#define     CONF_SPI0_MST_CLOCK_SOURCE  0x00000000
//          <o> Clock Polarity (CPOL) <0x00000000=> Low
//                                    <0x00000002=> High                    
#define     CONF_SPI0_MST_CPOL          0x00000000
//          <o> Clock Phase (CPHA) <0x00000000=> Leading edge (1 Edge)
//                                 <0x00000004=> Trailing edge (2 Edge)
#define     CONF_SPI0_MST_CPHA          0x00000000
//      </h>

//      <h> Advanced Parameter  
//          <o> Data Line Number <0x00000000=> Standard SPI
//                               <0x00000010=> 1-Line Bidirectional
//                               <0x00000020=> 2-Lines Bidirectional
//                               <0x00000030=> 4-Lines Bidirectional
//                               <0x00000040=> 4-Lines Duplicate
//                               <0x00000050=> 8-Lines Bidirectional
//          <i> MG32F02A128/A064/U128/U064 support 4-Lines duplicate.
//          <i> MG32F02A128/A064/U128/U064 support 8-Lines bidirectional.
#define     CONF_SPI0_MST_DAT_LINE      0x00000000
//          <o> Data Receive Sampling Edge <0x00000000=> Normal
//                                         <0x00040000=> Next
//          <i> When Select "Normal", CPHA selected clock edge.
//          <i> When Select "Next", next clock edge of CPHA selected edge.
#define     CONF_SPI0_MST_RX_CTL        0x00000000
//      </h>
//  </h>

    /*=== Slave Configuration ===*/
//  <h> Slave Configuration
//      <e.9> Enable NSS Signal
#define     CONF_SPI0_SLV_NSSI_EN       0x00000200
//          <o> Select The SPI Pin For The NSS Input Signal <0x00000000=> NSS
//                                                          <0x00000400=> NSSI
#define     CONF_SPI0_SLV_NSSI_SLE      0x00000000
//      </e>

//      <h> Basic Parameter
//          <o> Data Size <0x00040000=> 4 Bits  
//                        <0x00050000=> 5 Bits  
//                        <0x00060000=> 6 Bits  
//                        <0x00070000=> 7 Bits  
//                        <0x00080000=> 8 Bits  
//                        <0x00090000=> 9 Bits  
//                        <0x000A0000=> 10 Bits  
//                        <0x000B0000=> 11 Bits  
//                        <0x000C0000=> 12 Bits  
//                        <0x000D0000=> 13 Bits  
//                        <0x000E0000=> 14 Bits  
//                        <0x000F0000=> 15 Bits  
//                        <0x00100000=> 16 Bits  
//                        <0x00110000=> 17 Bits  
//                        <0x00120000=> 18 Bits  
//                        <0x00130000=> 19 Bits  
//                        <0x00140000=> 20 Bits  
//                        <0x00150000=> 21 Bits  
//                        <0x00160000=> 22 Bits  
//                        <0x00170000=> 23 Bits  
//                        <0x00180000=> 24 Bits  
//                        <0x00190000=> 25 Bits  
//                        <0x001A0000=> 26 Bits  
//                        <0x001B0000=> 27 Bits  
//                        <0x001C0000=> 28 Bits  
//                        <0x001D0000=> 29 Bits  
//                        <0x001E0000=> 30 Bits  
//                        <0x001F0000=> 31 Bits  
//                        <0x00000000=> 32 Bits
#define     CONF_SPI0_SLV_DATA_SIZE     0x00080000
//          <o> First Bit <0x00000000=> MSB First
//                        <0x00000008=> LSB First
#define     CONF_SPI0_SLV_LSB           0x00000000
//      </h>

//      <h> Clock Parameter
//          <o> Clock Source <0x00000000=> PROC
//                           <0x00000008=> TM00_TRGO
#define     CONF_SPI0_SLV_CLOCK_SOURCE  0x00000000
//          <o> Clock Polarity (CPOL) <0x00000000=> Low
//                                    <0x00000002=> High                    
#define     CONF_SPI0_SLV_CPOL          0x00000000
//          <o> Clock Phase (CPHA) <0x00000000=> Leading edge (1 Edge)
//                                 <0x00000004=> Trailing edge (2 Edge)
#define     CONF_SPI0_SLV_CPHA          0x00000000
//      </h>

//      <h> Advanced Parameter   
//          <o> Data Line Number <0x00000000=> Standard SPI
//                               <0x00000010=> 1-Line Bidirectional
//                               <0x00000020=> 2-Lines Bidirectional
//                               <0x00000030=> 4-Lines Bidirectional
//                               <0x00000040=> 4-Lines Duplicate
//                               <0x00000050=> 8-Lines Bidirectional
//          <i> MG32F02A128/A064/U128/U064 support 4-Lines duplicate.
//          <i> MG32F02A128/A064/U128/U064 support 8-Lines bidirectional.
#define     CONF_SPI0_SLV_DAT_LINE      0x00000000
//          <o> The SPI Shift Buffer Clock Select <0x00000000=> Synchronized
//                                                <0x04000000=> Asynchronous
//          <i> Support MG32F02A128/A064/U128/U064/V032.
#define     CONF_SPI0_SLV_ASYNC_EN      0x00000000
//          <q.25> Enable High Speed Function
//          <i> When this bit is enabled and SPI is slave synchronous mode (SPI0_ASYNC_EN=0), the SPI clock frequency can operate up to 1/3 APB clcok frequency.
//          <i> Support MG32F02A032/A128/A064/U128/U064/V032.
#define     CONF_SPI0_SLV_HS_EN         0x00000000
//          <o> Standard Mode Data Transmit Timing Select <0x00000000=> Normal Edge
//                                                        <0x00010000=> Previous Clock Edge
//          <i> The function is no effect if "The SPI Shift Buffer Clock Select" synchronized (SPI0_ASYNC_EN=0).
//          <i> Support MG32F02V032.
#define     CONF_SPI0_SLV_TX_CTL        0x00000000
//      </h>
//  </h>

    /*=== Interrupt Configuration ===*/
//  <h> Interrupt Configuration
//      <e.0> IEA
#define     CONF_SPI0_INT_IEA           0x00000000
//          <i> SPI interrupt all enable.
//          <i> When IDE is Keil, 
//          <q.3> IDL_IE
//          <i> SPI slave mode NSS idle detect interrupt enable.
#define     CONF_SPI0_INT_IDL_IE        0x00000000
//          <q.4> TC_IE
//          <i> SPI transmission complete interrupt enable.
#define     CONF_SPI0_INT_TC_IE         0x00000000
//          <q.6> RX_IE
//          <i> SPI receive data register not empty interrupt enable.
#define     CONF_SPI0_INT_RX_IE         0x00000000
//          <q.7> TX_IE
//          <i> SPI TX buffer underflow the threshold SPI0_TX_TH Interrupt enable.
#define     CONF_SPI0_INT_TX_IE         0x00000000
//          <q.8> MODF_IE
//          <i> SPI mode detect fault interrupt enable.
#define     CONF_SPI0_INT_MODF_IE       0x00000000
//          <q.9> WE_IE
//          <i> SPI slave mode write error interrupt enable.
#define     CONF_SPI0_INT_WE_IE         0x00000000
//          <q.10> ROVR_IE
//          <i> SPI RX buffer receive overrun interrupt enable.
#define     CONF_SPI0_INT_ROVR_IE       0x00000000
//          <q.11> TUDR_IE
//          <i> SPI TX buffer transmit underrun interrupt enable.
#define     CONF_SPI0_INT_TUDR_IE       0x00000000
//      </e>
//  </h>
//</h>

//*** <<< end of configuration section >>>    ***


/**
 * @name	Function announce
 *   		
 */
///@{  
void SPI_Init (void);
///@}


#endif  // _MG32_SPI0_INIT_H


