#ifndef __LCD_H
#define __LCD_H


#include "Common.h"

//*** <<< Use Configuration Wizard in Context Menu >>> ***
//    <o0> SPI TFT LCD Driver  <0=>ILI9341 <1=>ILI9328 <2=>ILI9325 <3=>ILI9320 <4=>NT35510 <9=>Auto Detect

#define LCDPanel_Type      0
//*** <<< end of configuration section >>> ***

//LCD?????
//typedef struct  
//{
//    __IO uint16_t    width;         //LCD 撖砍漲
//    __IO uint16_t    height;        //LCD 擃漲
//    __IO uint16_t    id;            //LCD ID
//    __IO uint8_t     dir;           //璈怠??鞊??批嚗?嚗?撅?1嚗帖撅?
//    __IO uint16_t    wramcmd;       //??撖剋ram?誘
//    __IO uint16_t    setxcmd;       //閮剔蔭x???誘
//    __IO uint16_t    setycmd;       //閮剔蔭y???誘
//}_lcd_dev;


////LCD?
//extern _lcd_dev lcddev;   //蝞∠?LCD???

////LCD?蝑??脣????
//extern uint16_t  POINT_COLOR;//暺?蝝
//extern uint16_t  BACK_COLOR; //?憿.暺??箇??

typedef struct{
    void(* Reset)(uint16_t Times);
    void(* BackLight)(uint16_t Duty);       // Duty OFF 0x0000, ON 0xFFFF.

    void(* SelectReg)(uint16_t Register);

    void(* WriteRegister)(uint16_t Register, uint16_t Value); 
    void(* WriteData)(uint16_t Value);
    void(* WriteData8)(uint8_t Value);

    //uint16_t(* ReadRegister)(uint16_t Register, uint16_t Length); 
    uint16_t(* ReadData)(void);
    //uint16_t(* ReadData8)(void);

    void(* DataReverse)(FunctionalState State);

    __IO uint32_t   State;          //

    __IO uint32_t   HWIF    :1;     // Haedware Interface 0:Parallel, 1:Serial 
    __IO uint32_t   DataRevers :1;  // Data Reverse : 0 Enable, 1 Disable.
    __IO uint32_t   Direct  :1;     // 璈怠??鞊??批嚗?嚗?撅?1嚗帖撅?
    __IO uint32_t   Reserved:29;  // Reserved bit
    
    __IO uint16_t   ID;             // LCD ID
    __IO uint16_t   Width;          // LCD 撖砍漲
    __IO uint16_t   Height;         // LCD 擃漲
    __IO uint16_t   SetXcmd;        // 閮剔蔭x???誘
    __IO uint16_t   SetYcmd;        // 閮剔蔭y???誘
    __IO uint16_t   GRAMcmd;        // ??撖亮RAM?誘
    __IO uint16_t   PointColor;
    __IO uint16_t   BackColor;
}Display_HandleTypeDef;


extern Display_HandleTypeDef LCD1st;

extern uint16_t GrayBar_1[];


////////////////////////////////////////////////////////////////////
//-----------------LCD蝡臬摰儔---------------- 
#define LCD_LED PCout(10)               //LCD?? 

#define __LCD_BackLight_On()    GPIOE->SC.W = PX_SC_SET8_mask_w
#define __LCD_BackLight_Off()   GPIOE->SC.W = PX_SC_CLR8_mask_w

#define __LCD_Reset_ENABLE()    GPIOB->SC.W = PX_SC_SET4_mask_w
#define __LCD_Reset_DISABLE()   GPIOB->SC.W = PX_SC_CLR4_mask_w

#if !defined(MG0404)
  #define __LCD_BACKLIGHT_ON()    GPIOE->SC.W = PX_SC_SET9_mask_w
  #define __LCD_BACKLIGHT_OFF()   GPIOE->SC.W = PX_SC_CLR9_mask_w
#endif

#define __LCD_CS_SET()    
#define __LCD_CS_CLR()    

#define __LCD_RS_SET()    GPIOC->SC.W = PX_SC_SET7_mask_w
#define __LCD_RS_CLR()    GPIOC->SC.W = PX_SC_CLR7_mask_w

#define __LCD_WR_SET()    
#define __LCD_WR_CLR()    

#define __LCD_RD_SET()    
#define __LCD_RD_CLR()    

//PB0~15, External Address
#define __DATAOUT(x) *(volatile uint16_t *)0x60000000 = (x)
#define __DATAIN()   *(volatile uint16_t *)0x60000000

//-------------------------------------
#define __I80_LCD_RESET_ENABLE()    GPIOB->SC.W = PX_SC_CLR4_mask_w
#define __I80_LCD_RESET_DISABLE()   GPIOB->SC.W = PX_SC_SET4_mask_w

#if defined(MG0404)
  #define __I80_LCD_BACKLIGHT_ON()    GPIOE->SC.W = PX_SC_SET8_mask_w
  #define __I80_LCD_BACKLIGHT_OFF()   GPIOE->SC.W = PX_SC_CLR8_mask_w
#else
  #define __I80_LCD_BACKLIGHT_ON()    GPIOE->SC.W = PX_SC_SET9_mask_w
  #define __I80_LCD_BACKLIGHT_OFF()   GPIOE->SC.W = PX_SC_CLR9_mask_w
#endif

#define __I80_LCD_CS_SET()    
#define __I80_LCD_CS_CLR()    

#define __I80_LCD_RS_SET()    GPIOC->SC.W = PX_SC_SET7_mask_w
#define __I80_LCD_RS_CLR()    GPIOC->SC.W = PX_SC_CLR7_mask_w

#define __I80_LCD_WR_SET()    
#define __I80_LCD_WR_CLR()    

#define __I80_LCD_RD_SET()    
#define __I80_LCD_RD_CLR()    

//-------------------------------------

#define __SPI_LCD_RESET_PIN()       PINB(4)
#define __SPI_LCD_RESET_PIN_AFS()   0
#define __SPI_LCD_RESET_ENABLE()    GPIOB->SC.B[2] = PX_SC_CLR4_mask_b2
#define __SPI_LCD_RESET_DISABLE()   GPIOB->SC.B[0] = PX_SC_SET4_mask_b0

#define __SPI_LCD_BACKLIGHT_PIN()   PINE(9)
#define __SPI_LCD_BACKLIGHT_PIN_AFS() 0
#define __SPI_LCD_BACKLIGHT_ON()    GPIOE->SC.B[1] = PX_SC_SET9_mask_b1
#define __SPI_LCD_BACKLIGHT_OFF()   GPIOE->SC.B[3] = PX_SC_CLR9_mask_b3

#define __SPI_LCD_CS_PIN()          PINA(7)
#define __SPI_LCD_CS_PIN_AFS()      11
#define __SPI_LCD_CS_SET()          
#define __SPI_LCD_CS_CLR()          

#define __SPI_LCD_DC_PIN()          PINC(7)
#define __SPI_LCD_DC_PIN_AFS()      0
#define __SPI_LCD_DC_DAT()          GPIOC->SC.W = PX_SC_SET7_mask_w
#define __SPI_LCD_DC_CMD()          GPIOC->SC.W = PX_SC_CLR7_mask_w

#define __SPI_LCD_CLK_PIN_AFS()     11
#define __SPI_LCD_CLK_PIN()         PINA(6)
#define __SPI_LCD_SDI_PIN_AFS()     11
#define __SPI_LCD_SDI_PIN()         PINA(4)     // to TFT LCD Module SDI Pin
#define __SPI_LCD_SDO_PIN_AFS()     11
#define __SPI_LCD_SDO_PIN()         PINA(5)     // to TFT LCD Module SDO Pin

//#define __SPI_LCD_WR_SET()        
//#define __SPI_LCD_WR_CLR()        

//#define __SPI_LCD_RD_SET()        
//#define __SPI_LCD_RD_CLR()        

//////////////////////////////////////////////////////////////////////
//Display Scan Direction
#define L2R_U2D  0 //from Left to Right and from Up to Down.
#define L2R_D2U  1 //from Left to Right and from Down to Up.
#define R2L_U2D  2 //from Right to Left and from Up to Down.
#define R2L_D2U  3 //from Right to Left and from Down to Up.
#define U2D_L2R  4 //from Up to Down.and from Left to Right.
#define U2D_R2L  5 //from Up to Down.and from Right to Left.
#define D2U_L2R  6 //from Down to Up.and from Left to Right.
#define D2U_R2L  7 //from Down to Up.and from Right to Left.

#define DFT_SCAN_DIR  L2R_U2D  // Default 

//Brush Color
#define WHITE               0xFFFF
#define BLACK               0x0000

#define BLUE                0x001F  
#define BRED                0XF81F
#define GRED                0XFFE0
#define GBLUE               0X07FF
#define RED                 0xF800
#define MAGENTA             0xF81F
#define YELLOW              0xFFE0
#define GREEN               0x07E0
#define CYAN                0x7FFF
#define BROWN               0XBC40  //
#define BRRED               0XFC07  //
#define GRAY                0X8430  //
// GUI Color

#define DARKBLUE            0X01CF  //
#define LIGHTBLUE           0X7D7C  //
#define GRAYBLUE            0X5458  //
// 
 
#define LIGHTGREEN          0X841F //
#define LGRAY               0XC618 //

#define LGRAYBLUE           0XA651 //
#define LBBLUE              0X2B12 //

extern void SPI_LCD_Interface_Initial(void);

void SPI_LCD_Reset(uint16_t Time);
void SPI_LCD_BackLight(uint16_t Duty);
void SPI_LCD_DataReverse(FunctionalState State);
void SPI_LCD_SelectRegister(uint16_t Register);
void SPI_LCD_WriteRegister(uint16_t Register, uint16_t Value);
uint16_t SPI_LCD_ReadRegister(uint16_t Register);
void SPI_LCD_WriteData(uint16_t Data);
void SPI_LCD_WriteData8(uint8_t Data);
uint16_t SPI_LCD_ReadData(void);

void I80_LCD_Reset(uint16_t Duty);
void I80_LCD_BackLight(uint16_t Duty);
void I80_LCD_SelectRegister(uint16_t Register);
void I80_LCD_WriteRegister(uint16_t Register, uint16_t Value);
uint16_t I80_LCD_ReadRegister(uint16_t Register);
void I80_LCD_WriteData(uint16_t Data);
void I80_LCD_WriteData8(uint8_t Data);
uint16_t I80_LCD_ReadData(void);

void LCD_Interface_Init(void);

void LCD_Scan_Dir(Display_HandleTypeDef *DispX, uint8_t dir);                                                                                                                             //閮剔蔭撅????
void LCD_Display_Dir(Display_HandleTypeDef *DispX, uint8_t dir);                                                                                                                          //閮剔蔭撅?憿舐內?孵?
void LCD_Init(Display_HandleTypeDef *DISPLAYx);                                                                                                          // ????

void LCD_Set_Window(Display_HandleTypeDef *DispX, uint16_t sx,uint16_t sy, uint16_t width, uint16_t height);                                             // 閮剔蔭蝒
void Set_Printf_Window(Display_HandleTypeDef *DispX, uint16_t sx, uint16_t sy, uint16_t width, uint16_t height);

void LCD_DisplayOn(Display_HandleTypeDef *DispX);                                                                                                        // ?＊蝷?
void LCD_DisplayOff(Display_HandleTypeDef *DispX);                                                                                                       // ?＊蝷?

void LCD_Clear(Display_HandleTypeDef *DispX, uint16_t Color);                                                                                            // 皜?
void LCD_Clear2(Display_HandleTypeDef *DispX, uint16_t sx, uint16_t sy, uint16_t width, uint16_t height, uint16_t color);                                // 蝭?皜?
void LCD_SetCursor(Display_HandleTypeDef *DispX, uint16_t Xpos, uint16_t Ypos);                                                                          // 閮剔蔭??
void LCD_DrawPoint(Display_HandleTypeDef *DispX, uint16_t x, uint16_t y, uint16_t Color);                                                                // ?恍?
uint16_t LCD_ReadPoint(Display_HandleTypeDef *DispX, uint16_t x, uint16_t y);                                                                            // 霈暺?
void LCD_Fill(Display_HandleTypeDef *DispX, uint16_t sx, uint16_t sy, uint16_t ex, uint16_t ey, uint16_t color);                                         // 憛怠??株
void LCD_Color_Fill(Display_HandleTypeDef *DispX, uint16_t sx, uint16_t sy, uint16_t ex, uint16_t ey, __I uint16_t *color);                                  // 憛怠???憿
void LCD_Color_FillX(Display_HandleTypeDef *DispX, uint16_t sx, uint16_t sy, uint16_t ex, uint16_t ey, uint16_t *color);                                 //  

void LCD_Draw_Circle(Display_HandleTypeDef *DispX, uint16_t x0, uint16_t y0, uint8_t r, uint16_t Color);                                                 // ?怠?
void LCD_DrawLine(Display_HandleTypeDef *DispX, uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color);                                     // ?怎?
void LCD_DrawRectangle(Display_HandleTypeDef *DispX, uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color);                                // ?怎敶?
void LCD_ShowChar(Display_HandleTypeDef *DispX, uint16_t x, uint16_t y, uint8_t num, uint8_t size, uint8_t mode, uint16_t Color);                        // 憿舐內銝??蝚?
void LCD_ShowCharX(Display_HandleTypeDef *DispX, uint16_t x, uint16_t y, uint8_t num, uint8_t size, uint16_t Color, uint16_t BackColor);
void LCD_ShowNum(Display_HandleTypeDef *DispX, uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t size, uint16_t Color);                         // 憿舐內銝?摮?
void LCD_ShowxNum(Display_HandleTypeDef *DispX, uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t size, uint8_t mode, uint16_t Color);          // 憿舐內 ?詨?
void LCD_ShowString(Display_HandleTypeDef *DispX, uint16_t x, uint16_t y, uint16_t width, uint16_t height, uint16_t Color, uint8_t size, uint8_t *p);    // 憿舐內銝??蝚虫葡,12/16摮?
void LCD_ShowStringX(Display_HandleTypeDef *DispX, uint16_t x, uint16_t y, uint16_t width, uint16_t height, uint16_t Color, uint16_t BackColor, uint8_t size, __I uint8_t *p);

void LCD_ButtonUp(Display_HandleTypeDef *DispX, uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color);
void LCD_ButtonDown(Display_HandleTypeDef *DispX, uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color);

void LCD_ColorBar_1(Display_HandleTypeDef *DispX);
void LCD_ColorBar_2(Display_HandleTypeDef *DispX);

//9320/9325 LCD撖??? 
#define R0             0x00
#define R1             0x01
#define R2             0x02
#define R3             0x03
#define R4             0x04
#define R5             0x05
#define R6             0x06
#define R7             0x07
#define R8             0x08
#define R9             0x09
#define R10            0x0A
#define R12            0x0C
#define R13            0x0D
#define R14            0x0E
#define R15            0x0F
#define R16            0x10
#define R17            0x11
#define R18            0x12
#define R19            0x13
#define R20            0x14
#define R21            0x15
#define R22            0x16
#define R23            0x17
#define R24            0x18
#define R25            0x19
#define R26            0x1A
#define R27            0x1B
#define R28            0x1C
#define R29            0x1D
#define R30            0x1E
#define R31            0x1F
#define R32            0x20
#define R33            0x21
#define R34            0x22
#define R36            0x24
#define R37            0x25
#define R40            0x28
#define R41            0x29
#define R43            0x2B
#define R45            0x2D
#define R48            0x30
#define R49            0x31
#define R50            0x32
#define R51            0x33
#define R52            0x34
#define R53            0x35
#define R54            0x36
#define R55            0x37
#define R56            0x38
#define R57            0x39
#define R59            0x3B
#define R60            0x3C
#define R61            0x3D
#define R62            0x3E
#define R63            0x3F
#define R64            0x40
#define R65            0x41
#define R66            0x42
#define R67            0x43
#define R68            0x44
#define R69            0x45
#define R70            0x46
#define R71            0x47
#define R72            0x48
#define R73            0x49
#define R74            0x4A
#define R75            0x4B
#define R76            0x4C
#define R77            0x4D
#define R78            0x4E
#define R79            0x4F
#define R80            0x50
#define R81            0x51
#define R82            0x52
#define R83            0x53
#define R96            0x60
#define R97            0x61
#define R106           0x6A
#define R118           0x76
#define R128           0x80
#define R129           0x81
#define R130           0x82
#define R131           0x83
#define R132           0x84
#define R133           0x85
#define R134           0x86
#define R135           0x87
#define R136           0x88
#define R137           0x89
#define R139           0x8B
#define R140           0x8C
#define R141           0x8D
#define R143           0x8F
#define R144           0x90
#define R145           0x91
#define R146           0x92
#define R147           0x93
#define R148           0x94
#define R149           0x95
#define R150           0x96
#define R151           0x97
#define R152           0x98
#define R153           0x99
#define R154           0x9A
#define R157           0x9D
#define R192           0xC0
#define R193           0xC1
#define R229           0xE5
#endif


