

/**
 ******************************************************************************
 *
 * @file        main.C
 * @brief       BLE protject for MG126.c 
 *
 * @par         Project
 *              MG32
 * @version     V1.03
 * @date        2023/04/20
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2021 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * @note		Test APP "nRF Toolbox"
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
#include "BSP.h"
#include "mg_api.h"

#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
    #pragma clang diagnostic push
    #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
        unsigned char *ble_mac_addr;    /* Add volatile */
    #pragma clang diagnostic pop
#else
    unsigned char *ble_mac_addr;    /* Add volatile */
#endif

//unsigned char pld_adv[] = {2,0x1,0x4, 3,0x19,0xc0,0x03, 3,0x3,0x12,0x18};

void ChipInit(void);
int fputc(int ch, FILE *f);


/**
 *******************************************************************************
 * @brief       fputc
 * @details     Check transmit data buffer empty and Write transmit data.
 * @return
 * @note        
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
int fputc(int ch, FILE *f __attribute__((unused)))
{
    // UART0
    URT_SetTXData(URT0, 1, (uint32_t) ch);
    while(URT_GetITSingleFlagStatus(URT0, URT_IT_TC) == DRV_UnHappened);
    URT_ClearITFlag(URT0, URT_IT_TC);
    return ch;
}


int main(void)
{
    ChipInit();                                                     // Initial CSC modle

    BSP_Init();                                                     // Initial SPI0, URT0, EXIC, IWDT, LED, GPIO and Tick
    /**
    *******************************************************************************
    * @note     BSP_Init configure pins 
    *  SPI0 pin: 
    *  PB0  GPB0 (Software NSS)
    *  PB1  AFS SPI0_MISO
    *  PB2  SPI0_CLK
    *  PB3  SPI0_MOSI
    *
    *  EXIC pin:
    *  PB10 GPB10 (EXIC Interrupt)
    *
    *  UART0 pin:
    *  PB8  URT0_TX
    *  PB9  URT0_RX
    *
    *  LED pin:
    *  PD8  GPD8 (support MG32F02A032)
    *  PE13 GPE13 (support MG32F02A132/A128)
    *******************************************************************************
    */
    
    SetBleIntRunningMode();
    radio_initBle(TXPWR_0DBM, &ble_mac_addr);

    ble_run_interrupt_start(160*2); //320*0.625=200 ms

    while(1)
    {
        IrqMcuGotoSleepAndWakeup();
    }
}


