/**
 ******************************************************************************
 *
 * @file        MG32_DRV.h
 *
 * @brief       This is the C Code Include format example file.
 *
 * @par         Project
 *              MG32
 * @version     V1.24
 * @date        2023/10/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */ 

#ifndef _MG32_DRV_H
#define _MG32_DRV_H
#define _MG32_DRV_H_VER                            2.20           /*!<MG32 Driver ver.*/

#ifdef __cplusplus
extern "C" {
#endif

#include "MG32_ADC_DRV.h"
#include "MG32_APB_DRV.h"
#include "MG32_CFG_DRV.h"
#include "MG32_CMP_DRV.h"
#include "MG32_CSC_DRV.h"
#include "MG32_EXIC_DRV.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_GPL_DRV.h"
#include "MG32_I2C_DRV.h"
#include "MG32_IWDT_DRV.h"
#include "MG32_MEM_DRV.h"
#include "MG32_PW_DRV.h"
#include "MG32_RST_DRV.h"
#include "MG32_SPI_DRV.h"
#include "MG32_SYS_DRV.h"
#include "MG32_TM_DRV.h"
#include "MG32_URT_DRV.h"
#include "MG32_WWDT_DRV.h"
#include "MG32_DMA_DRV.h"
#include "MG32_RTC_DRV.h"

// ------------------------------------------------------------------------
#if defined(ModuleExist_CMP)
#include "MG32_CMP_DRV.h"
#endif
// ------------------------------------------------------------------------
#if defined(ModuleExist_EMB)
#include "MG32_EMB_DRV.h"
#endif
// ------------------------------------------------------------------------
#if defined(ModuleExist_DAC)
#include "MG32_DAC_DRV.h"
#endif
// ------------------------------------------------------------------------
#if defined(ModuleExist_APX)
#include "MG32_APX_DRV.h"
#endif
// ------------------------------------------------------------------------
#if defined(USB_TYPE)
#include "MG32_USB_DRV.h"
#endif
// ------------------------------------------------------------------------
#if defined(ModuleExist_OPA)
#include "MG32_OPA_DRV.h"
#endif
// ------------------------------------------------------------------------
#if defined(ModuleExist_LCD)
#include "MG32_LCD_DRV.h"
#endif
// ------------------------------------------------------------------------
#if defined(ModuleExist_CAN0)
#include "MG32_CAN_DRV.h"
#endif

#ifdef __cplusplus
}
#endif

#endif

