/**
 ******************************************************************************
 *
 * @file        MG32_DAC_Init.H
 *
 * @brief       This file is to configure DAC baudrate setting.
 *              Device : MG32F02A128/U128/A064/U064
 * @par         Project
 *              MG32 
 * @version     V1.02
 * @date        2022/11/16
 * @author      MG32CoGen
 * @copyright   Copyright (c) 2022 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par     Disclaimer 
 *    The Demo software is provided "AS IS"  without any warranty, either 
 *    expressed or implied, including, but not limited to, the implied warranties 
 *    of merchantability and fitness for a particular purpose.  The author will 
 *    not be liable for any special, incidental, consequential or indirect 
 *    damages due to loss of data or any other reason. 
 *    These statements agree with the world wide and local dictated laws about 
 *    authorship and violence against these laws. 
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _MG32_DAC_INIT_H
 
#define _MG32_DAC_INIT_H

#include "MG32_DAC_DRV.h"
#if defined(IRQHandler_Middleware_Level_)       
    #include "MG32_DAC_MID.h"
#endif

// <<< Use Configuration Wizard in Context Menu >>>

//<e0.0> Module - Mode Active
    #define CONF_DAC_MODE                                   0x00000000
//  <h> DAC Config
//      <i> MG32F02A128/U128/A064/U064 builds in one DAC module which embeds one 12-bit current mode DAC (digital-to-analog converter).
//      <i> The digital-to-analog conversion can be performed and start trigger by data register written, events (external pin input or internal events).
//      <i> The DAC can output a full-scale voltage from 0.2 volt to VDD-0.2 volt under the conversion rate up to 1MHz when DAC output buffer is on.
//      <q0.1> DAC output buffer enable 
        #define CONF_DAC_CR0_BUF0_EN                        0x00000000
//      <o0.4> DAC data alignment <0=> Right (Right alignment) <1=> Left (Left alignment)
//          <i> Data alignment for input code left/right justify
        #define CONF_DAC_CR0_ALIGN0_SEL                     0x00000000
//      <o0.6..7> DAC data resolution <0=> 12-bit <1=> 10-bit <2=> 8-bit
//          <i> Configurable code width : 12/10/8-bit
        #define CONF_DAC_CR0_RES0_SEL                       0x00000000
//      <h> DAC start trigger control 
//          <o0.8..10> Trigger source <0=> WDAT : DAC_DAT0 register written
//                                    <1=> PIN : DAC_TRG external trigger pin 
//                                    <2=> CMP0 : CMP0_OUT
//                                    <3=> TM00 : TM00_TRGO
//                                    <4=> TM01 : TM01_TRGO 
//                                    <5=> TM10 : TM10_TRGO 
//                                    <6=> ITR6 : APB_ITR6
//                                    <7=> ITR7 : APB_ITR7
//              <i> DAC start trigger control source select.
        #define CONF_DAC_CR0_START0_SEL                     0x00000000
//          <o0.12..13> start trigger selection
//                                    <0=> Disable    
//                                    <1=> Rising edge
//                                    <2=> Falling edge
//                                    <3=> Dual-edge  
//              <i> DAC-0 start trigger selection. When selects Disable, the edge trigger detection is disabled and no start trigger signal output. 
//              <i> When DAC_START0_SEL = WDAT (DAC_DAT0 register written), this register is no effect.
        #define CONF_DAC_CR0_TRG0_SEL                       0x00000000
//      </h>
//      <o0.0..15> Output code (ratio:x/4096) <0-4095>
//      <i> DAC: Voltage output / input range 0~4095 (for 12-bit mode)  
//      <i> if user select 10 or 8-bit mode, the initial wizard will automatically switch to 10 or 8-bit mode data
        #define CONF_DAC_DAT0                               0x00000000
//  </h>
//</e>

//<e0.0> DAC interrupt all enable (DAC_IEA)
        #define CONF_DAC_INT_IEA                            0x00000000
//    <q0.1> DAC-0 ready to update new data to data register interrupt (RDY0_IE)
        #define CONF_DAC_INT_RDY0_IE                        0x00000000
//    <q0.7> DAC-0 conversion underrun event interrupt (UDR0_IE)
        #define CONF_DAC_INT_UDR0_IE          	            0x00000000
//</e>
// <<< end of Configuration section >>>

    // ----------------------------------------------
    // Combined with DAC_INT register bit function
    #define CONF_DAC_INT    (CONF_DAC_INT_IEA       |\
                             CONF_DAC_INT_RDY0_IE   |\
                             CONF_DAC_INT_UDR0_IE)
    
    // ----------------------------------------------
    // Combined with DAC_ANA register bit function
    #if defined(CONF_DAC_CR0_CMOD0_SEL)
    #define CONF_DAC_CR0    (CONF_DAC_CR0_CMOD0_SEL |\
                             CONF_DAC_CR0_ALIGN0_SEL|\
                             CONF_DAC_CR0_RES0_SEL  |\
                             CONF_DAC_CR0_START0_SEL|\
                             CONF_DAC_CR0_TRG0_SEL)
    #else                        
    #define CONF_DAC_CR0    (CONF_DAC_CR0_BUF0_EN   |\
                             CONF_DAC_CR0_ALIGN0_SEL|\
                             CONF_DAC_CR0_RES0_SEL  |\
                             CONF_DAC_CR0_START0_SEL|\
                             CONF_DAC_CR0_TRG0_SEL)
    #endif                         
                                                  

    
    // ------------------------------------------------------------------------
    // Assemble mADC structure within Middleware level
    // ------------------------------------------------------------------------

    // ------------------------------------------------------------------------
    // DAC Trigger Converion Source Select
    #define mDAC_TriggerConverionSrc_Select         CONF_DAC_CR0_START0_SEL

    // ------------------------------------------------------------------------
    // DAC Trigger Converion Edge Select
    #define mDAC_TriggerConverionEdge_Select        CONF_DAC_CR0_TRG0_SEL

    // ------------------------------------------------------------------------
    // DAC Data Align Select (8/10/12+R or L)
    #if defined(MG32_1ST)
        #if CONF_DAC_CR0_RES0_SEL == (0<<6)
            #if CONF_DAC_CR0_ALIGN0_SEL == (0 << 4)
                #define mDAC_DataAlign_Select           DAC_ALIGN_10B_R
            #else   
                #define mDAC_DataAlign_Select           DAC_ALIGN_10B_L
            #endif  
        #elif CONF_DAC_CR0_RES0_SEL == (1<<6)   
            #if CONF_DAC_CR0_ALIGN0_SEL == (0 << 4) 
                #define mDAC_DataAlign_Select           DAC_ALIGN_8B_R
            #else   
                #define mDAC_DataAlign_Select           DAC_ALIGN_8B_L
            #endif  
        #endif
    #elif defined(MG32_3RD)
        #if CONF_DAC_CR0_RES0_SEL == (0<<6)
            #if CONF_DAC_CR0_ALIGN0_SEL == (0 << 4)
                #define mDAC_DataAlign_Select           DAC_ALIGN_12B_R
            #else   
                #define mDAC_DataAlign_Select           DAC_ALIGN_12B_L
            #endif  
        #elif CONF_DAC_CR0_RES0_SEL == (1<<6)   
            #if CONF_DAC_CR0_ALIGN0_SEL == (0 << 4) 
                #define mDAC_DataAlign_Select           DAC_ALIGN_10B_R
            #else   
                #define mDAC_DataAlign_Select           DAC_ALIGN_10B_L
            #endif  
        #elif CONF_DAC_CR0_RES0_SEL == (2<<6)   
            #if CONF_DAC_CR0_ALIGN0_SEL == (0 << 4) 
                #define mDAC_DataAlign_Select           DAC_ALIGN_8B_R
            #else   
                #define mDAC_DataAlign_Select           DAC_ALIGN_8B_L
            #endif  
        #endif
    #endif

    // ------------------------------------------------------------------------
    // DAC Output Level Select
    #if defined(CONF_DAC_CR0_CMOD0_SEL)
        #define mDAC_OutputLevel_Select             CONF_DAC_CR0_ALIGN0_SEL
    #else       
        #define mDAC_OutputLevel_Select             DAC_OUTPUTCURRENT_MODE1
    #endif

    // ------------------------------------------------------------------------
    // DAC Interrupt Mode Select
    #define DAC_InterruptMode_Select                (CONF_DAC_INT_RDY0_IE | CONF_DAC_INT_UDR0_IE)



/**
 * @name  Function announce
 *      
 */
///@{ 
void DAC_Init(void);

///@}
#endif  // _MG32_DAC_INIT_H

