/**
 *******************************************************************************
 *
 * @file        MG32_TM_Init.c
 *
 * @brief       The TM initial code C file
 *
 * @par         Project
 *              MG32
 * @version     V1.06
 * @date        2023/08/08
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
/* Includes ------------------------------------------------------------------*/
#include "MG32_TM_Init.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
// (Middleware level)
#if defined(IRQHandler_Middleware_Level_)       
    #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
            #if defined(ModuleExist_TM00)
                #if CONF_TM00_MODE != 0
                    TM_HandleTypeDef        mTM00;
                #endif
            #endif
            #if defined(ModuleExist_TM01)
                #if CONF_TM01_MODE != 0
                    TM_HandleTypeDef        mTM01;
                #endif
            #endif
            #if defined(ModuleExist_TM10)
                #if CONF_TM10_MODE != 0
                    TM_HandleTypeDef        mTM10;
                #endif
            #endif
            #if defined(ModuleExist_TM16)
                #if CONF_TM16_MODE != 0
                    TM_HandleTypeDef        mTM16;
                #endif
            #endif
            #if defined(ModuleExist_TM20)
                #if CONF_TM20_MODE != 0
                    TM_HandleTypeDef        mTM20;
                #endif
            #endif
            #if defined(ModuleExist_TM26)
                #if CONF_TM26_MODE != 0
                    TM_HandleTypeDef        mTM26;
                #endif
            #endif
            #if defined(ModuleExist_TM36)
                #if CONF_TM36_MODE != 0
                    TM_HandleTypeDef        mTM36;
                #endif
            #endif
        #pragma clang diagnostic pop
    // ------------------------------------------------------------------------
    #else
        #if defined(ModuleExist_TM00)
            #if CONF_TM00_MODE != 0
                TM_HandleTypeDef        mTM00;
            #endif
        #endif
        #if defined(ModuleExist_TM01)
            #if CONF_TM01_MODE != 0
                TM_HandleTypeDef        mTM01;
            #endif
        #endif
        #if defined(ModuleExist_TM10)
            #if CONF_TM10_MODE != 0
                TM_HandleTypeDef        mTM10;
            #endif
        #endif
        #if defined(ModuleExist_TM16)
            #if CONF_TM16_MODE != 0
                TM_HandleTypeDef        mTM16;
            #endif
        #endif
        #if defined(ModuleExist_TM20)
            #if CONF_TM20_MODE != 0
                TM_HandleTypeDef        mTM20;
            #endif
        #endif
        #if defined(ModuleExist_TM26)
            #if CONF_TM26_MODE != 0
                TM_HandleTypeDef        mTM26;
            #endif
        #endif
        #if defined(ModuleExist_TM36)
            #if CONF_TM36_MODE != 0
                TM_HandleTypeDef        mTM36;
            #endif
        #endif
    #endif
    // ------------------------------------------------------------------------
#endif

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief  	    Initialized TM module.
 * @param[in]   None
 * @return      None
 *******************************************************************************
 */
void TM_Init (void)
{

    /* TM00 initial wizard */
    #if CONF_TM00_MODE != 0
        TM00->INT.W     = (CONF_TM00_INT);
        TM00->CLK.W     = (CONF_TM00_CLK);
        TM00->CKO.W     = (CONF_TM00_CKO);
        TM00->ARR.W     = (CONF_TM00_CNT);
        TM00->PSARR.W   = (CONF_TM00_PSNT);
        TM00->TRG.W     = (CONF_TM00_TRG | TM_TRG_RST_SW_enable_w | TM_TRG_RST2_SW_enable_w);    // reset TM00
        TM00->TRG.W     = (CONF_TM00_TRG);
    
        // --------------------------------------------------------------------
        // Config mTM00 structure within Middleware level
        // --------------------------------------------------------------------
        #if defined(IRQHandler_Middleware_Level_)       
            mTM00.Instance              = TM00;
            mTM00.Init.TM_CounterMode   = mTM00_CounterMode_Select;
            mTM00.Init.TM_Period        = mTM00_Period_Select;
            mTM00.Init.TM_Prescaler     = mTM00_Prescaler_Select;
            mTM00.State                 = MID_TM_STATE_RESET;
            
            // MID_TM_Base_Init(&mTM00);
        #endif

        TM00->CR0.W     = (CONF_TM00_CR0 | TM_CR0_EN_enable_w | TM_CR0_EN2_enable_w);
    #endif
    
    
    
    /* TM01 initial wizard */
    #if CONF_TM01_MODE != 0
        TM01->INT.W     = (CONF_TM01_INT);
        TM01->CLK.W     = (CONF_TM01_CLK);
        TM01->CKO.W     = (CONF_TM01_CKO);
        TM01->ARR.W     = (CONF_TM01_CNT);
        TM01->PSARR.W   = (CONF_TM01_PSNT);
        TM01->TRG.W     = (CONF_TM01_TRG | TM_TRG_RST_SW_enable_w | TM_TRG_RST2_SW_enable_w);    // reset TM01
        TM01->TRG.W     = (CONF_TM01_TRG);
        
        // --------------------------------------------------------------------
        // Config mTM01 structure within Middleware level
        // --------------------------------------------------------------------
        #if defined(IRQHandler_Middleware_Level_)       
            mTM01.Instance              = TM01;
            mTM01.Init.TM_CounterMode   = mTM01_CounterMode_Select;
            mTM01.Init.TM_Period        = mTM01_Period_Select;
            mTM01.Init.TM_Prescaler     = mTM01_Prescaler_Select;
            mTM01.State                 = MID_TM_STATE_RESET;
            
            // MID_TM_Base_Init(&mTM01);
        #endif

        TM01->CR0.W     = (CONF_TM01_CR0 | TM_CR0_EN_enable_w | TM_CR0_EN2_enable_w);
    #endif
    
    /* TM10 initial wizard */
    #if CONF_TM10_MODE != 0
        TM10->INT.W     = (CONF_TM10_INT);
        TM10->CLK.W     = (CONF_TM10_CLK);
        TM10->CKO.W     = (CONF_TM10_CKO);
        TM10->ARR.W     = (CONF_TM10_CNT);
        TM10->PSARR.W   = (CONF_TM10_PSNT);
        TM10->TRG.W     = (CONF_TM10_TRG | TM_TRG_RST_SW_enable_w | TM_TRG_RST2_SW_enable_w);    // reset TM10
        TM10->TRG.W     = (CONF_TM10_TRG);
        
        // --------------------------------------------------------------------
        // Config mTM10 structure within Middleware level
        // --------------------------------------------------------------------
        #if defined(IRQHandler_Middleware_Level_)       
            mTM10.Instance              = TM10;
            mTM10.Init.TM_CounterMode   = mTM10_CounterMode_Select;
            mTM10.Init.TM_Period        = mTM10_Period_Select;
            mTM10.Init.TM_Prescaler     = mTM10_Prescaler_Select;
            mTM10.State                 = MID_TM_STATE_RESET;
            
            // MID_TM_Base_Init(&mTM01);
        #endif

        TM10->CR0.W     = (CONF_TM10_CR0 | TM_CR0_EN_enable_w | TM_CR0_EN2_enable_w);
    #endif
    
    /* TM16 initial wizard */
    #if CONF_TM16_MODE != 0
        TM16->INT.W     = (CONF_TM16_INT);
        TM16->CLK.W     = (CONF_TM16_CLK);
        TM16->CKO.W     = (CONF_TM16_CKO);
        TM16->ARR.W     = (CONF_TM16_CNT);
        TM16->PSARR.W   = (CONF_TM16_PSNT);
        TM16->TRG.W     = (CONF_TM16_TRG | TM_TRG_RST_SW_enable_w | TM_TRG_RST2_SW_enable_w);    // reset TM16
        TM16->TRG.W     = (CONF_TM16_TRG);
        
        // --------------------------------------------------------------------
        // Config mTM16 structure within Middleware level
        // --------------------------------------------------------------------
        #if defined(IRQHandler_Middleware_Level_)       
            mTM16.Instance              = TM16;
            mTM16.Init.TM_CounterMode   = mTM16_CounterMode_Select;
            mTM16.Init.TM_Period        = mTM16_Period_Select;
            mTM16.Init.TM_Prescaler     = mTM16_Prescaler_Select;
            mTM16.State                 = MID_TM_STATE_RESET;
            
            // MID_TM_Base_Init(&mTM01);
        #endif

        TM16->CR0.W     = (CONF_TM16_CR0 | TM_CR0_EN_enable_w | TM_CR0_EN2_enable_w);
    #endif
    
    /* TM20 initial wizard */
    #if defined(CONF_TM20_MODE)
        #if CONF_TM20_MODE != 0
            TM20->INT.W     = (CONF_TM20_INT);
            TM20->CLK.W     = (CONF_TM20_CLK);
            TM20->CKO.W     = (CONF_TM20_CKO);
            TM20->ARR.W     = (CONF_TM20_CNT);
            TM20->PSARR.W   = (CONF_TM20_PSNT);
            TM20->TRG.W     = (CONF_TM20_TRG | TM_TRG_RST_SW_enable_w | TM_TRG_RST2_SW_enable_w);    // reset TM20
            TM20->CR1.W     = (CONF_TM20_CR1);
            TM20->CCMDS.W   = (CONF_TM20_CCMDS);
            TM20->ICCR.W    = (CONF_TM20_ICCR);
            TM20->OSCR.W    = (CONF_TM20_OSCR);              
            TM20->OCCR0.W   = (CONF_TM20_OCCR0);
            TM20->OCCR1.W   = (CONF_TM20_OCCR1);
            TM20->PWM.W     = (0);
            TM20->BS.W      = (CONF_TM20_BS);
            #if (CONF_TM20_CCMDS_CC0_MDS==2) || (CONF_TM20_CCMDS_CC0_MDS==3)
                TM20->CC0A.W = TM20->CC0B.W = (CONF_TM20_CC0A_OC);
            #elif (CONF_TM20_CCMDS_CC0_MDS==4) || (CONF_TM20_CCMDS_CC0_MDS==5)
                TM20->CC0A.W = TM20->CC0B.W = (CONF_TM20_CC0A_PWM);
            #endif
            #if (CONF_TM20_CCMDS_CC1_MDS==(2 << 4)) || (CONF_TM20_CCMDS_CC1_MDS==(3 << 4))
                TM20->CC1A.W = TM20->CC1B.W = (CONF_TM20_CC1A_OC);
            #elif (CONF_TM20_CCMDS_CC1_MDS==(4 << 4)) || (CONF_TM20_CCMDS_CC1_MDS==(5 << 4))
                TM20->CC1A.W = TM20->CC1B.W = (CONF_TM20_CC1A_PWM);
            #endif
            TM20->TRG.W     = (CONF_TM20_TRG);
            
            // --------------------------------------------------------------------
            // Config mTM20 structure within Middleware level
            // --------------------------------------------------------------------
            #if defined(IRQHandler_Middleware_Level_)       
                mTM20.Instance              = TM20;
                mTM20.Init.TM_CounterMode   = mTM20_CounterMode_Select;
                mTM20.Init.TM_Period        = mTM20_Period_Select;
                mTM20.Init.TM_Prescaler     = mTM20_Prescaler_Select;
                mTM20.State                 = MID_TM_STATE_RESET;
                
                // MID_TM_Base_Init(&mTM01);
            #endif

            TM20->CR0.W     = (CONF_TM20_CR0 | TM_CR0_EN_enable_w | TM_CR0_EN2_enable_w);
        #endif
    #endif

    /* TM26 initial wizard */
    #if defined(CONF_TM26_MODE)
        #if CONF_TM26_MODE != 0
            TM26->INT.W     = (CONF_TM26_INT);
            TM26->CLK.W     = (CONF_TM26_CLK);
            TM26->CKO.W     = (CONF_TM26_CKO);
            TM26->ARR.W     = (CONF_TM26_CNT);
            TM26->PSARR.W   = (CONF_TM26_PSNT);
            TM26->TRG.W     = (CONF_TM26_TRG | TM_TRG_RST_SW_enable_w | TM_TRG_RST2_SW_enable_w);    // reset TM26
            TM26->CR1.W     = (CONF_TM26_CR1);
            TM26->CCMDS.W   = (CONF_TM26_CCMDS);
            TM26->ICCR.W    = (CONF_TM26_ICCR);
            TM26->OSCR.W    = (CONF_TM26_OSCR);
            TM26->OCCR0.W   = (CONF_TM26_OCCR0);
            TM26->OCCR1.W   = (CONF_TM26_OCCR1);
            TM26->PWM.W     = (0);
            TM26->BS.W      = (CONF_TM26_BS);
            #if (CONF_TM26_CCMDS_CC0_MDS==2) || (CONF_TM26_CCMDS_CC0_MDS==3)
                TM26->CC0A.W = TM26->CC0B.W = (CONF_TM26_CC0A_OC);
            #elif (CONF_TM26_CCMDS_CC0_MDS==4) || (CONF_TM26_CCMDS_CC0_MDS==5)
                TM26->CC0A.W = TM26->CC0B.W = (CONF_TM26_CC0A_PWM);
            #endif
            #if (CONF_TM26_CCMDS_CC1_MDS==(2 << 4)) || (CONF_TM26_CCMDS_CC1_MDS==(3 << 4))
                TM26->CC1A.W = TM26->CC1B.W = (CONF_TM26_CC1A_OC);
            #elif (CONF_TM26_CCMDS_CC1_MDS==(4 << 4)) || (CONF_TM26_CCMDS_CC1_MDS==(5 << 4))
                TM26->CC1A.W = TM26->CC1B.W = (CONF_TM26_CC1A_PWM);
            #endif
            TM26->TRG.W     = (CONF_TM26_TRG);
            
            // --------------------------------------------------------------------
            // Config mTM26 structure within Middleware level
            // --------------------------------------------------------------------
            #if defined(IRQHandler_Middleware_Level_)       
                mTM26.Instance              = TM26;
                mTM26.Init.TM_CounterMode   = mTM26_CounterMode_Select;
                mTM26.Init.TM_Period        = mTM26_Period_Select;
                mTM26.Init.TM_Prescaler     = mTM26_Prescaler_Select;
                mTM26.State                 = MID_TM_STATE_RESET;
                
                // MID_TM_Base_Init(&mTM01);
            #endif

            TM26->CR0.W     = (CONF_TM26_CR0 | TM_CR0_EN_enable_w | TM_CR0_EN2_enable_w);
        #endif
    #endif

    /* TM36 initial wizard */
    #if CONF_TM36_MODE != 0
        TM36->INT.W     = (CONF_TM36_INT);
        TM36->CLK.W     = (CONF_TM36_CLK);
        TM36->CKO.W     = (CONF_TM36_CKO);
        TM36->ARR.W     = (CONF_TM36_CNT);
        TM36->PSARR.W   = (CONF_TM36_PSNT);
        TM36->TRG.W     = (CONF_TM36_TRG | TM_TRG_RST_SW_enable_w | TM_TRG_RST2_SW_enable_w);    // reset TM36
        TM36->CR1.W     = (CONF_TM36_CR1);
        TM36->CCMDS.W   = (CONF_TM36_CCMDS);
        TM36->ICCR.W    = (CONF_TM36_ICCR);
        TM36->OSCR.W    = (CONF_TM36_OSCR);         
        TM36->OCCR0.W   = (CONF_TM36_OCCR0);
        TM36->OCCR1.W   = (CONF_TM36_OCCR1);
        TM36->PWM.W     = (CONF_TM36_PWM);
        TM36->BS.W      = (CONF_TM36_BS);
        #if (CONF_TM36_CCMDS_CC0_MDS==2) || (CONF_TM36_CCMDS_CC0_MDS==3)
            TM36->CC0A.W = TM36->CC0B.W = (CONF_TM36_CC0A_OC);
        #elif (CONF_TM36_CCMDS_CC0_MDS >= 4) 
            TM36->CC0A.W = TM36->CC0B.W = (CONF_TM36_CC0A_PWM);
        #endif
        #if (CONF_TM36_CCMDS_CC1_MDS==(2 << 4)) || (CONF_TM36_CCMDS_CC1_MDS==(3 << 4))
            TM36->CC1A.W = TM36->CC1B.W = (CONF_TM36_CC1A_OC);
        #elif (CONF_TM36_CCMDS_CC1_MDS >= (4 << 4))
            TM36->CC1A.W = TM36->CC1B.W = (CONF_TM36_CC1A_PWM);
        #endif
        #if (CONF_TM36_CCMDS_CC2_MDS==(2 << 8)) || (CONF_TM36_CCMDS_CC2_MDS==(3 << 8))
            TM36->CC2A.W = TM36->CC2B.W = (CONF_TM36_CC2A_OC);
        #elif (CONF_TM36_CCMDS_CC2_MDS >= (4 << 8)) 
            TM36->CC2A.W = TM36->CC2B.W = (CONF_TM36_CC2A_PWM);
        #endif
        #if (CONF_TM36_CCMDS_CC3_MDS==(2 << 12)) || (CONF_TM36_CCMDS_CC3_MDS==(3 << 12))
            TM36->CC3A.W = TM36->CC3B.W = (CONF_TM36_CC3A_OC);
        #elif (CONF_TM36_CCMDS_CC3_MDS==(4 << 12)) || (CONF_TM36_CCMDS_CC3_MDS==(5 << 12))
            TM36->CC3A.W = TM36->CC3B.W = (CONF_TM36_CC3A_PWM);
        #endif
        TM36->TRG.W     = (CONF_TM36_TRG);
        
        // --------------------------------------------------------------------
        // Config mTM36 structure within Middleware level
        // --------------------------------------------------------------------
        #if defined(IRQHandler_Middleware_Level_)       
            mTM36.Instance              = TM36;
            mTM36.Init.TM_CounterMode   = mTM36_CounterMode_Select;
            mTM36.Init.TM_Period        = mTM36_Period_Select;
            mTM36.Init.TM_Prescaler     = mTM36_Prescaler_Select;
            mTM36.State                 = MID_TM_STATE_RESET;
            
            // MID_TM_Base_Init(&mTM01);
        #endif

        TM36->CR0.W     = (CONF_TM36_CR0 | TM_CR0_EN_enable_w | TM_CR0_EN2_enable_w);
    #endif
}






