/**
  ******************************************************************************
 *
 * @file        Sample_Retarget.c
 *
 * @brief       Function Retarget of Standard Library.
 *
 * @par         Project
 *              MG32
 * @version     V1.12
 * @date        2022/12/16
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2021 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#if defined(__GNUC__) && !defined (__ARMCC_VERSION) 
    //#include <_ansi.h>
    #include <sys/types.h>
    #include <sys/stat.h>
    #include <sys/fcntl.h>
    #include <stdio.h>
    #include <string.h>
    #include <time.h>
    #include <sys/time.h>
    #include <sys/times.h>
    #include <errno.h>
    //#include <reent.h>
    #include <unistd.h>
    #include <sys/wait.h>

		#include <stdarg.h>
    #include "MG32.h"
    #include "MG32_URT.h"
#endif
    #include "MG32.h"
    #include "MG32_URT.h"
    #include "MG32_GPL.h"
    #include "stdio.h"
    #include "stdlib.h"
    #include "stdarg.h"
/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
#if defined(__GNUC__) && !defined (__ARMCC_VERSION) 
    #undef errno
    extern int errno;

    #define MAX_STACK_SIZE 0x2000
    #ifndef FreeRTOS
        register char* stack_ptr __asm("sp");
    #endif
#endif

/* Private define ------------------------------------------------------------*/
#define PRINT_BUF_LEN  12

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
static void URT_OutByte(int c);
static void printchar(int c);
static void prints(const char *string);
static void printi(unsigned int print_variable, unsigned int pos_notation, unsigned char letbase);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
#if defined(__GNUC__) && !defined (__ARMCC_VERSION) 
    extern int fputc(int ch, FILE *f) __attribute__((weak));
    extern int fgetc(FILE *f) __attribute__((weak));
    
#elif defined (__ARMCC_VERSION) 
    int fputc(int ch, FILE *f);
    int fgetc(FILE *f);
#endif

void printf_mg( const char *format,...);

/* External vairables --------------------------------------------------------*/


/*
 *******************************************************************************
 * @brief       writes the character specified by c (converted to an unsigned char) to
 *              the output stream pointed to by stream, at the position indicated by the
 *              asociated file position indicator (if defined), and advances the
 *              indicator appropriately. If the file position indicator is not defined,
 *              the character is appended to the output stream.
 * @param[in]   ch
 * @param[in]   f
 * @return      the character written. If a write error occurs, the error
 *              indicator is set and fputc returns EOF.
 *******************************************************************************
 */
static volatile uint8_t gURT0_First = 0;

int fputc(int ch, FILE *f __attribute__((unused)))
{
    if(gURT0_First == 0)
        gURT0_First = 1;
    else
        while((URT0->STA.W & URT_STA_TXF_mask_w) == 0);
    URT0->TDAT.B[0] = (uint8_t)ch;
    return ch;
}

/**
 *******************************************************************************
 * @brief       obtains the next character (if present) as an unsigned char converted to
 *              an int, from the input stream pointed to by stream, and advances the
 *              associated file position indicator (if defined).
 * @param[in]   f
 * @return      the next character from the input stream pointed to by stream.
 *              If the stream is at end-of-file, the end-of-file indicator is
 *              set and fgetc returns EOF. If a read error occurs, the error
 *              indicator is set and fgetc returns EOF.
 *******************************************************************************
 */
#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
    #pragma clang diagnostic push
    #pragma clang diagnostic ignored "-Wunused-parameter"
        int fgetc(FILE *f)
        {
            int ch;
            while(URT0->STA.MBIT.RXF == 0);
            ch = URT0->RDAT.B[0];
            return ch;
        }
    #pragma clang diagnostic pop
#else
int fgetc(FILE *f)
{
    int ch;
    while(URT0->STA.MBIT.RXF == 0);
    ch = URT0->RDAT.B[0];
    return ch;
}
#endif


#if defined(__GNUC__) && !defined (__ARMCC_VERSION) 
/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
caddr_t _sbrk(int incr) 
{
    extern char end __asm("end");
    static char* heap_end;
    char* prev_heap_end;
#ifdef FreeRTOS
    char *min_stack_ptr;
#endif    

    if (heap_end == 0) 
    {
        heap_end = &end;
    }

    prev_heap_end = heap_end;

#ifdef FreeRTOS
    /* Use the NVIC offset register to locate the main stack pointer. */
    min_stack_ptr = (char*)(*(unsigned int*) * (unsigned int*)0xE000ED08);
    /* Locate the STACK bottom address */
    min_stack_ptr -= MAX_STACK_SIZE;

    if (heap_end + incr > min_stack_ptr)
#else
    if (heap_end + incr > stack_ptr)
#endif
    {
        //		write(1, "Heap and stack collision\n", 25);
        //		abort();
        errno = ENOMEM;
        return (caddr_t) - 1;
    }

    heap_end += incr;

    return (caddr_t) prev_heap_end;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _gettimeofday (struct timeval* tp, struct timezone* tzp) 
{
    /* Return fixed data for the timezone.  */
    if (tzp) 
    {
        tzp->tz_minuteswest = 0;
        tzp->tz_dsttime = 0;
    }

    return 0;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
void initialise_monitor_handles(void) 
{
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _getpid(void) 
{
    return 1;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _kill(int pid, int sig) 
{
    errno = EINVAL;
    return -1;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
void _exit (int status) 
{
    _kill(status, -1);
    while (1) {}
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _write(int file, char* ptr, int len) 
{
    int DataIdx;

    for (DataIdx = 0; DataIdx < len; DataIdx++) 
    {
        fputc( *ptr++ , (FILE *) 0x0001);
    }
    return len;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _close(int file) 
{
    return -1;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _fstat(int file, struct stat* st) 
{
    st->st_mode = S_IFCHR;
    return 0;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _isatty(int file) 
{
    return 1;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _lseek(int file, int ptr, int dir) 
{
    return 0;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _read(int file, char* ptr, int len) 
{
    int DataIdx;

    for (DataIdx = 0; DataIdx < len; DataIdx++) 
    {
        *ptr++ = fgetc((FILE *) 0x0001);
    }

    return len;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _open(char* path, int flags, ...) 
{
    /* Pretend like we always fail */
    return -1;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _wait(int* status) 
{
    errno = ECHILD;
    return -1;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _unlink(char* name) 
{
    errno = ENOENT;
    return -1;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _times(struct tms* buf) 
{
    return -1;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _stat(char* file, struct stat* st) 
{
    st->st_mode = S_IFCHR;
    return 0;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _link(char* old, char* new) 
{
    errno = EMLINK;
    return -1;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _fork(void) 
{
    errno = EAGAIN;
    return -1;
}

/**
 ******************************************************************************
 * Support function for GNU libc. 
 ******************************************************************************
 */
int _execve(char* name, char** argv, char** env) 
{
    errno = ENOMEM;
    return -1;
}
#endif

/**
 *******************************************************************************
 * @brief	    Simple printf.
 * @details     
 * @param[in]  format: format string
 * @return      
 * @exception   No
 * @note      
 *******************************************************************************
 */
void printf_mg( const char *format,...)
{
    va_list  parameter; 
    int      str;

    va_start(parameter,format);
    for (; *format != 0; ++format) 
    {
        if (*format == '%') 
        {
			++format;
            
			if (*format == '\0')             // NULL 
            {                
                break;
            }
			if (*format == '%')              // Output % string.
            {
                goto printf_mg_output;
            }

            str = va_arg(parameter, int);
            
			if( *format == 'd' ) 
            {
                printi((uint32_t)str, 10, 'a');
				continue;
			}
            if( *format == 'x' )
            {
				printi((uint32_t)str, 16, 'a');
				continue;
			}
			if( *format == 'X' )
            {
				printi((uint32_t)str, 16, 'A');
				continue;
			}
		}
		else 
        {
printf_mg_output:
			printchar (*format);
		}
	}
    va_end(parameter);
}

/**
 *******************************************************************************
 * @brief	    URT transfer data. 
 * @details     
 * @param[in]   URT_Data: URT transfer data.E
 * @return      
 * @exception   No
 * @note      
 *******************************************************************************
 */
static void URT_OutByte(int URT_Data)
{
    while((URT0->STA.W & URT_STA_TXF_mask_w) == 0);
    URT0->TDAT.B[0] = (uint8_t)URT_Data;
}
/**
 *******************************************************************************
 * @brief	    printf char data
 * @details     
 * @param[in]   prt_char: print char data.
 * @return      
 * @exception   No
 * @note      
 *******************************************************************************
 */
static void printchar(int prt_char)
{
    static char prev = 0;
    
    /* The ASCII code less than'Space' code only support '\r', '\n', '\t', \b' */
    if (prt_char < ' ' && prt_char != '\r' && prt_char != '\n' && prt_char != '\t' && prt_char != '\b')  
    {
        return;
    }
    if (prt_char == '\n' && prev != '\r') 
    {
       URT_OutByte('\r');
    }
    URT_OutByte(prt_char);
}
/**
 *******************************************************************************
 * @brief	    printf string.
 * @details     
 * @param[in]   prt_string: print string data pointer.
 * @return      
 * @exception   No
 * @note      
 *******************************************************************************
 */
static void prints(const char *prt_string)
{
    for ( ; *prt_string ; ++prt_string) 
    {
        printchar (*prt_string);
    }
}
/**
 *******************************************************************************
 * @brief	    Parameter value change to ASCII code.
 * @details     
 * @param[in]   print_variable : parameter value.
 * @param[in]   b :
 *  @arg\b      10 : decimal
 *  @arg\b      16 : hexdecimal
 * @param[in]   letbase : ASCII code base (for hexdecimal).
 * @return      
 * @exception   No
 * @note      
 *******************************************************************************
 */
static void printi(unsigned int print_variable, unsigned int pos_notation, unsigned char letbase)
{
	char print_buf[PRINT_BUF_LEN];
	register char *pstring;
	register unsigned int printi_tmp;
	register unsigned int u = print_variable;
   
    /*If parameter is '0' direct output.*/
	if (print_variable == 0) 
    {
        print_buf[0] = '0';
        print_buf[1] = '\0';
        
        prints (print_buf);
        return;
	}

	pstring = print_buf + PRINT_BUF_LEN-1;
	*pstring = '\0';

	while(u)
    {
        printi_tmp = u % pos_notation;
        
        if( printi_tmp >= 10 )
        {
            *--pstring = (uint8_t)((letbase + (printi_tmp - 10)));
        }
        else
        {
		    *--pstring = (uint8_t)('0' + printi_tmp);        
        } 

        if(pstring==print_buf)
        {
            break;
        }
        
		u /= pos_notation;
	}
    prints(pstring);
}

