
/**
 ******************************************************************************
 *                                                                            *
 * @file        MG32_IEC60730_RAM_ASM_GCC.S                               *
 *                                                                            *
 * @brief       Check MCU full RAM area before main routine.                  *
 *                                                                            *
 * @par         Project                                                       *
 *              MG32                                                      *
 * @version     V1.00                                                         *
 * @date        2022/11/19 15:00                                              *
 * @note        Copyright (c) 2022 MegaWin Technology Co., Ltd.               *
 *              All rights reserved.                                          *
 ******************************************************************************
 */

  .syntax unified
  .cpu cortex-m0
  .fpu softvfp
  .thumb
      
  .global IEC60730_RAM_Full_ASM

  .section .text.IEC60730_RAM_Full_ASM
  .weak IEC60730_RAM_Full_ASM
  .type IEC60730_RAM_Full_ASM, %function

  // Reference to the FailSafe routine to be executed in case of non-recoverable
  // failure (FailSafePOR)


  // C variables for control flow monitoring
  
  // chip MG32F02A132
  .if MG32F02A132==1
.set RAM_START_ADDR, 0x20000000     //RAM start address  
.set RAM_END_ADDR,   0x20003FFC     //RAM end address - 4 byte
  .endif
      
  // chip MG32F02A072
  .if MG32F02A072==1
.set RAM_START_ADDR, 0x20000000     //RAM start address  
.set RAM_END_ADDR,   0x20001FFC     //RAM end address - 4 byte
  .endif
      
  // chip MA862
  .if MA862==1
.set RAM_START_ADDR, 0x20000000     //RAM start address  
.set RAM_END_ADDR,   0x20001FFC     //RAM end address - 4 byte
  .endif
      
  // chip MG32F02A032
  .if MG32F02A032==1
.set RAM_START_ADDR, 0x20000000     //RAM start address  
.set RAM_END_ADDR,   0x20000FFC     //RAM end address - 4 byte
  .endif
      
  // chip MG32F02A128
  .if MG32F02A128==1
.set RAM_START_ADDR, 0x20000000     //RAM start address  
.set RAM_END_ADDR,   0x20003FFC     //RAM end address - 4 byte
  .endif

  // chip MG32F02U128
  .if MG32F02U128==1
.set RAM_START_ADDR, 0x20000000     //RAM start address  
.set RAM_END_ADDR,   0x20003FFC     //RAM end address - 4 byte
  .endif
      
  // chip MG32F02A064
  .if MG32F02A064==1
.set RAM_START_ADDR, 0x20000000     //RAM start address  
.set RAM_END_ADDR,   0x20001FFC     //RAM end address - 4 byte
  .endif
      
  // chip MG32F02U064
  .if MG32F02U064==1
.set RAM_START_ADDR, 0x20000000     //RAM start address  
.set RAM_END_ADDR,   0x20001FFC     //RAM end address - 4 byte
  .endif
      
  // chip MG32F02V032
  .if MG32F02V032==1
.set RAM_START_ADDR, 0x20000000     //RAM start address  
.set RAM_END_ADDR,   0x20000FFC     //RAM end address - 4 byte
  .endif
      
IEC60730_RAM_Full_ASM:

    // R0 = RAM_START address
    // R1 = RAM_END address
    // R2 = Write / Compare register
    
    // ---------------------------- STEP 1 ----------------------------------- 
    // Write background with addresses increasing 
    LDR R0,=RAM_START_ADDR         
    LDR R1,=RAM_END_ADDR
    LDR R2,=0x00000000
REPEAT_CLEAR_RAM:
    STR R2,[R0]
    ADDS R0,#4    
    CMP R0,R1
    BLS REPEAT_CLEAR_RAM      // R0 <= R1

    // ---------------------------- STEP 2 ----------------------------------- 
    // Verify background and write inverted background with addresses increasing 
    LDR R0,=RAM_START_ADDR         
    LDR R1,=RAM_END_ADDR
    ADDS R1,#4
REPEAT_STEP2_CHECK_RAM:
    LDRB R2,[R0]
    CMP R2,#0
    BEQ STEP2_EQUAL           
    BLAL FailSafePOR          // if not equal then go to FailSafePOR
STEP2_EQUAL:                     
    MVNS R2, R2               // Rerverse R2 reg
    STRB R2,[R0]              // Write 0xFF to RAM
    ADDS R0, #1
    CMP R0,R1
    BNE REPEAT_STEP2_CHECK_RAM  // R0 != R1

    // ---------------------------- STEP 3 ----------------------------------- */
    // Verify inverted background and write background with addresses increasing */
    LDR R0,=RAM_START_ADDR         
    LDR R1,=RAM_END_ADDR
    ADDS R1,#4
REPEAT_STEP3_CHECK_RAM:
    LDRB R2,[R0]
    CMP R2,#0x000000FF
    BEQ STEP3_EQUAL           
    BLAL FailSafePOR          // if not equal then go to FailSafePOR
STEP3_EQUAL:                     
    MVNS R2, R2               // Rerverse R2 reg to (0x00)
    STRB R2,[R0]              // Write 0xFF to RAM
    ADDS R0, #1
    CMP R0,R1
    BNE REPEAT_STEP3_CHECK_RAM  // R0 != R1
    

    // ---------------------------- STEP 4 ----------------------------------- */
    // Verify background and write inverted background with addresses decreasing */
    LDR R0,=RAM_START_ADDR         
    LDR R1,=RAM_END_ADDR
    ADDS R1,#3                // 0x?????FFF
REPEAT_STEP4_CHECK_RAM:
    LDRB R2,[R1]
    CMP R2,#0
    BEQ STEP4_EQUAL           
    BLAL FailSafePOR          // if not equal then go to FailSafePOR
STEP4_EQUAL:
    MVNS R2, R2               // Rerverse R2 reg
    STRB R2,[R1]              // Write 0xFF to RAM
    SUBS R1, #1
    CMP R0,R1
    BLS REPEAT_STEP4_CHECK_RAM  // R0 <= R1

    // ---------------------------- STEP 5 ----------------------------------- */
    // Verify inverted background and write background with addresses decreasing */
    LDR R0,=RAM_START_ADDR        
    LDR R1,=RAM_END_ADDR
    ADDS R1,#3                // 0x?????FFF
REPEAT_STEP5_CHECK_RAM:
    LDRB R2,[R1]
    CMP R2,#0x000000FF
    BEQ STEP5_EQUAL           
    BLAL FailSafePOR          // if not equal then go to FailSafePOR
STEP5_EQUAL:
    MVNS R2, R2               // Rerverse R2 reg to (0x00)
    STRB R2,[R1]              // Write 0xFF to RAM
    SUBS R1, #1
    CMP R0,R1
    BLS REPEAT_STEP5_CHECK_RAM  // R0 <= R1

    //---------------------------- STEP 6 ----------------------------------- */
    // Verify background with addresses increasing */
    LDR R0,=RAM_START_ADDR         
    LDR R1,=RAM_END_ADDR
    ADDS R1,#4
REPEAT_STEP6_CHECK_RAM:
    LDR R2,[R0]
    CMP R2,#0
    BEQ STEP6_EQUAL           
    BLAL FailSafePOR          // if not equal then go to FailSafePOR
STEP6_EQUAL:
    ADDS R0, #4
    CMP R0,R1
    BNE REPEAT_STEP6_CHECK_RAM  // R0 != R1
    
    
    //If next instruction is not executed, R0 will hold a value different from 0
    MOVS R0, #0x0             // RAM TEST SUCCESS
    BX  LR                     // return to the caller

    .end
/******************* (C) COPYRIGHT 2022 Megawin ************ END OF FILE *****/


