/**
 *******************************************************************************
 *
 * @file        MG32_CMP_Init.c
 *
 * @brief       The CMP initial code C file 
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2023/03/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_CMP.h"
#include "MG32_CMP_Init.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
// (Middleware level)
#if defined(IRQHandler_Middleware_Level_)       
    #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
            CMP_HandleTypeDef        mCMP;
        #pragma clang diagnostic pop
    // ------------------------------------------------------------------------
    #else
        CMP_HandleTypeDef        mCMP;
    #endif
    // ------------------------------------------------------------------------
#endif


/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief  	    Initialized Analog Comparator module.
 * @param[in]   None
 * @return      None
 *******************************************************************************
 */
void CMP_ACx_Init(void)
{
    
    #if CONF_CMP_MODE != 0
        /* CMP register initial */
        CMP->INT.W = CONF_CMP_INT;
        CMP->ANA.W = CONF_CMP_ANA;
        
        #if defined(CONF_CMP_CR0_AC0_EN)
            CMP->CR0.W  = CONF_CMP_CR0;
            // --------------------------------------------------------------------
            // Config mCMP structure within Middleware level
            // --------------------------------------------------------------------
            #if defined(IRQHandler_Middleware_Level_)       
                mCMP.Instance                   = CMPAC0;
                mCMP.Init.InvertingInput        = mCMP_AC0_InvertingInput_Select;
                mCMP.Init.NonInvertingInput     = mCMP_AC0_NonInvertingInput_Select;
                mCMP.Init.ComparatorPol         = mCMP_AC0_Polarity_Select;
                mCMP.Init.OutputPol             = mCMP_AC0_OutputPolarity_Select;
                #if defined(MG32_2ND) || defined(MG32_3RD)
                    mCMP.Init.Hysteresis            = mCMP_AC0_Hysteresis_Select;
                #endif
                mCMP.Init.Mode                  = mCMP_AC0_ResponseTime_Select;
                mCMP.Init.TriggerMode           = mCMP_AC0_IT_Select;
                mCMP.Init.OutputSync            = mCMP_AC0_OutputSync_Select;
                mCMP.Init.SyncFilterDIV         = mCMP_AC0_SyncFilterDIV_Select;
                mCMP.IntVref.IntVREF0_Level     = mCMP_VREF_Level_Select;
                mCMP.IntVref.IntVREF1_Level     = mCMP_VREF2_Level_Select;
                
                // MID_CMP_Init(&mADC);
            #endif
        #endif

        #if defined(CONF_CMP_CR1_AC1_EN)
            CMP->CR1.W  = CONF_CMP_CR1;
            // --------------------------------------------------------------------
            // Config mCMP structure within Middleware level
            // --------------------------------------------------------------------
            #if defined(IRQHandler_Middleware_Level_)       
                mCMP.Instance                   = CMPAC1;
                mCMP.Init.InvertingInput        = mCMP_AC1_InvertingInput_Select;
                mCMP.Init.NonInvertingInput     = mCMP_AC1_NonInvertingInput_Select;
                mCMP.Init.ComparatorPol         = mCMP_AC1_Polarity_Select;
                mCMP.Init.OutputPol             = mCMP_AC1_OutputPolarity_Select;
                #if defined(MG32_2ND) || defined(MG32_3RD)
                    mCMP.Init.Hysteresis            = mCMP_AC0_Hysteresis_Select;
                #endif
                mCMP.Init.Mode                  = mCMP_AC1_ResponseTime_Select;
                mCMP.Init.TriggerMode           = mCMP_AC1_IT_Select;
                mCMP.Init.OutputSync            = mCMP_AC1_OutputSync_Select;
                mCMP.Init.SyncFilterDIV         = mCMP_AC1_SyncFilterDIV_Select;
                mCMP.IntVref.IntVREF0_Level     = mCMP_VREF_Level_Select;
                mCMP.IntVref.IntVREF1_Level     = mCMP_VREF2_Level_Select;
                
                // MID_CMP_Init(&mADC);
            #endif
        #endif

        #if defined(CONF_CMP_CR2_AC2_EN)
            CMP->CR2.W  = CONF_CMP_CR2;
            // --------------------------------------------------------------------
            // Config mCMP structure within Middleware level
            // --------------------------------------------------------------------
            #if defined(IRQHandler_Middleware_Level_)       
                mCMP.Instance                   = CMPAC2;
                mCMP.Init.InvertingInput        = mCMP_AC2_InvertingInput_Select;
                mCMP.Init.NonInvertingInput     = mCMP_AC2_NonInvertingInput_Select;
                mCMP.Init.ComparatorPol         = mCMP_AC2_Polarity_Select;
                mCMP.Init.OutputPol             = mCMP_AC2_OutputPolarity_Select;
                #if defined(MG32_2ND) || defined(MG32_3RD)
                    mCMP.Init.Hysteresis            = mCMP_AC0_Hysteresis_Select;
                #endif
                mCMP.Init.Mode                  = mCMP_AC2_ResponseTime_Select;
                mCMP.Init.TriggerMode           = mCMP_AC2_IT_Select;
                mCMP.Init.OutputSync            = mCMP_AC2_OutputSync_Select;
                mCMP.Init.SyncFilterDIV         = mCMP_AC2_SyncFilterDIV_Select;
                mCMP.IntVref.IntVREF0_Level     = mCMP_VREF_Level_Select;
                mCMP.IntVref.IntVREF1_Level     = mCMP_VREF2_Level_Select;
                
                // MID_CMP_Init(&mADC);
            #endif
        #endif

        #if defined(CONF_CMP_CR3_AC3_EN)
            CMP->CR3.W  = CONF_CMP_CR3;
            // --------------------------------------------------------------------
            // Config mCMP structure within Middleware level
            // --------------------------------------------------------------------
            #if defined(IRQHandler_Middleware_Level_)       
                mCMP.Instance                   = CMPAC3;
                mCMP.Init.InvertingInput        = mCMP_AC3_InvertingInput_Select;
                mCMP.Init.NonInvertingInput     = mCMP_AC3_NonInvertingInput_Select;
                mCMP.Init.ComparatorPol         = mCMP_AC3_Polarity_Select;
                mCMP.Init.OutputPol             = mCMP_AC3_OutputPolarity_Select;
                #if defined(MG32_2ND) || defined(MG32_3RD)
                    mCMP.Init.Hysteresis            = mCMP_AC0_Hysteresis_Select;
                #endif
                mCMP.Init.Mode                  = mCMP_AC3_ResponseTime_Select;
                mCMP.Init.TriggerMode           = mCMP_AC3_IT_Select;
                mCMP.Init.OutputSync            = mCMP_AC3_OutputSync_Select;
                mCMP.Init.SyncFilterDIV         = mCMP_AC3_SyncFilterDIV_Select;
                mCMP.IntVref.IntVREF0_Level     = mCMP_VREF_Level_Select;
                mCMP.IntVref.IntVREF1_Level     = mCMP_VREF2_Level_Select;
                
                // MID_CMP_Init(&mADC);
            #endif
        #endif
    #endif

}


