

 /**
 ******************************************************************************
 *
 * @file        MG_GPIO.c
 * @brief       MG GPIO module sample code C file.
 *
 * @par         Project
 *              MG32F02N128
 * @version     V1.00
 * @date        2025/04/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_GPIO_DRV.h"
#include "Sample_GPIO.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	  Buttion IO initial
 * @details
 * @return      
 * @exception   
 * @note           
 *******************************************************************************
 */
void Button_Initial(void)
{
    /*Declare Variable*/
    PIN_InitTypeDef   Button_Pin;
    
    /*Button Pin Initial*/
    Button_Pin.PINX_Mode               = PINX_Mode_Digital_I;
    Button_Pin.PINX_PUResistant        = PINX_PUResistant_Enable;
    Button_Pin.PINX_Speed              = PINX_Speed_High;
    Button_Pin.PINX_Inverse            = PINX_Inverse_Disable;
    Button_Pin.PINX_OUTDrive           = PINX_OUTDrive_Level0;
    Button_Pin.PINX_FilterDivider      = PINX_FilterDivider_Bypass;
    Button_Pin.PINX_Alternate_Function = 0;
    GPIO_PinMode_Config( BUTTON0_PINX ,&Button_Pin);   
    GPIO_PinMode_Config( BUTTON1_PINX ,&Button_Pin);  
}

/**
 *******************************************************************************
 * @brief	  LED IO initial
 * @details
 * @return      
 * @exception   
 * @note           
 *******************************************************************************
 */
void LED_Initial(void)
{
    /*Declare Variable*/
    PIN_InitTypeDef   Button_Pin;
    
    /*LED pin status initial*/
    LED_R = LED_OFF;
    LED_G = LED_OFF;
//    LED_Y = LED_OFF;
    
    /*Button Pin Initial*/
    Button_Pin.PINX_Mode               = PINX_Mode_PushPull_O;
    Button_Pin.PINX_PUResistant        = PINX_PUResistant_Enable;
    Button_Pin.PINX_Speed              = PINX_Speed_High;
    Button_Pin.PINX_Inverse            = PINX_Inverse_Disable;
    Button_Pin.PINX_OUTDrive           = PINX_OUTDrive_Level2;
    Button_Pin.PINX_FilterDivider      = PINX_FilterDivider_Bypass;
    Button_Pin.PINX_Alternate_Function = 0;
    GPIO_PinMode_Config( LED_R_PINX ,&Button_Pin);   
    GPIO_PinMode_Config( LED_G_PINX ,&Button_Pin);    
//    GPIO_PinMode_Config( LED_Y_PINX ,&Button_Pin);         // Mask the pin because the pin is CAN transceiver STB control pin.
}


/**
 *******************************************************************************
 * @brief	  Simple buttion 0  debounce function
 * @details
 * @return      
 * @exception   
 * @note           
 *******************************************************************************
 */
void Button_Button0SimpleDebounce(void)
{
    uint32_t BT_SDB_Tmp;
    
    BT_SDB_Tmp = 0;
    while( BT_SDB_Tmp < 10000)
    {
        if( BUTTON0 == 0)
        {
            BT_SDB_Tmp = 0;
        }
        else
        {
            BT_SDB_Tmp++;
        }            
    }
}

/**
 *******************************************************************************
 * @brief	  Simple buttion 1 debounce function
 * @details
 * @return      
 * @exception   
 * @note           
 *******************************************************************************
 */
void Button_Button1SimpleDebounce(void)
{
    uint32_t BT_SDB_Tmp;
    
    BT_SDB_Tmp = 0;
    while( BT_SDB_Tmp < 10000)
    {
        if( BUTTON1 == 0)
        {
            BT_SDB_Tmp = 0;
        }
        else
        {
            BT_SDB_Tmp++;
        }            
    }
}


