/**
 ******************************************************************************
 *
 * @file        MG32_IEC60730_IWDT_RunTime.c
 *
 * @brief       IEC60730 Class-C : IWDT test in Run Time state.
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2025/07/18
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par     Disclaimer
 *    The Demo software is provided "AS IS"  without any warranty, either
 *    expressed or implied, including, but not limited to, the implied warranties
 *    of merchantability and fitness for a particular purpose.  The author will
 *    not be liable for any special, incidental, consequential or indirect
 *    damages due to loss of data or any other reason.
 *    These statements agree with the world wide and local dictated laws about
 *    authorship and violence against these laws.
 ******************************************************************************
 ******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_IEC60730_Common.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
// SysTick Define
#define TICK_CR     0xE000E010              // System Tick Configure Register Address Define
#define MG32_SYSTICK_EN_w     0x00000001                // System Tick Function Enable
#define MG32_SYSTICk_CLKSEL_w   0x00000004              // System Tick Clock Source Select
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static uint32_t IWDT_REG[5];
/* Private function prototypes -----------------------------------------------*/
IEC60730_Ret IEC60730_IWDT_RunTime(void);
void IEC60730_IWDT_RunTime_Init(void);
//void TM00_5mS_Delay(uint8_t dly);
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief       
 * @details  
 * @param[in]    
 * @return      
 * @exception      
 * @note        
 *******************************************************************************
 */
/*
void TM00_5mS_Delay(uint8_t dly)
{
    // Timer 00 Iniitalize
    TM00->CLK.MBIT.CKI_SEL = 0x02;
    TM00->CLK.MBIT.CKS_SEL = 0x00;
    TM00->CLK.MBIT.CKS2_SEL = 0x00;
    TM00->CNT.MBIT.CNT = dly-1;
    TM00->PSCNT.MBIT.PSCNT = 0x9D;
    TM00->ARR.MBIT.ARR = dly-1;
    TM00->PSARR.MBIT.PSARR = 0x9D;
    // Timer00 output clock enable.
    //TM00->CKO.MBIT.CKO_SEL = 1;
    //TM00->CKO.MBIT.CKO_EN = 1;
    TM00->CR0.B[0] |= 0x03;
    
    while((TM00->STA.B[0]&TM_STA_TOF_happened_b0)!=TM_STA_TOF_happened_b0);
    TM00->STA.B[0] != TM_STA_TOF_happened_b0;
}
*/

/**
 *******************************************************************************
 * @brief       
 * @details  
 * @param[in]    
 * @return      
 * @exception      
 * @note        
 *******************************************************************************
 */
IEC60730_Ret IEC60730_IWDT_RunTime(void)
{
    uint32_t Tick_Dly;
    
    IEC60730_IWDT_RunTime_Init();
    
    // IWDT Counter Test
    if((IWDT->STA.B[0]&IWDT_STA_TF_happened_b0) != IWDT_STA_TF_happened_b0)             // Check IWDT Overfloat Flag
    {
        if(IWDT->CNT.B[0]!=0x00)                    // IWDT Count Value Check.
        {
            IWDT->KEY.H[0] = 0x2014;                // Clear IWDT Count.
        }
    }
    else
    {
        return IEC60730_TEST_FAILURE;
    }
    
    //TM00_5mS_Delay(1);                        // Wait 5mS to check IWDT count.
    
    // Get System Tick Number
    Tick_Dly = GetTick();
    while(GetTick()-Tick_Dly<=5);
    
    // Double check IWDT count round two.
    if((IWDT->STA.B[0]&IWDT_STA_TF_happened_b0) != IWDT_STA_TF_happened_b0)             // Check IWDT Overfloat Flag
    {
        if(IWDT->CNT.B[0]!=0x00)                    // IWDT Count Value Check.
        {
            IWDT->KEY.H[0] = 0x2014;                // Clear IWDT Count.
        }
    }
    else
    {
        return IEC60730_TEST_FAILURE;
    }
    // Get System Tick Number
    Tick_Dly = GetTick();
    while(GetTick()-Tick_Dly<=10);              // Wait 10mS (Wait IWDT trigger event.
    
    // Double check IWDT count round two.
    if((IWDT->STA.B[0]&IWDT_STA_TF_happened_b0) == IWDT_STA_TF_happened_b0)             // Check IWDT Overfloat Flag
    {
        if(IWDT->CNT.B[0]!=0x00)                    // IWDT Count Value Check.
        {
            IWDT->KEY.H[0] = 0x2014;                // Clear IWDT Count.
        }
        
        IWDT->STA.B[0] |= IWDT_STA_TF_happened_b0;              // Clear IWDT Overfloat Flag.
        
        // Write back user set to IWDT register.
        IWDT->STA.B[0] = (uint8_t)IWDT_REG[0];
        IWDT->INT.B[0] = (uint8_t)IWDT_REG[1];
        IWDT->CLK.B[0] = (uint8_t)IWDT_REG[2];
        IWDT->CR0.H[0] = (uint16_t)IWDT_REG[3];
        IWDT->CNT.B[0] = (uint8_t)IWDT_REG[4];
    }
    
    return IEC60730_TEST_SUCCESS;
}

/**
 *******************************************************************************
 * @brief       
 * @details  
 * @param[in]    
 * @return      
 * @exception      
 * @note        
 *******************************************************************************
 */
void IEC60730_IWDT_RunTime_Init(void)
{
    // Unprotect IWDT
    IWDT->KEY.H[0] = 0xA217;
    
    // Get IWDT Register Value
    IWDT_REG[0] = (uint32_t)IWDT->STA.B[0];
    IWDT_REG[1] = (uint32_t)IWDT->INT.B[0];
    IWDT_REG[2] = (uint32_t)IWDT->CLK.B[0];
    IWDT_REG[3] = (uint32_t)IWDT->CR0.H[0];
    IWDT_REG[4] = (uint32_t)IWDT->CNT.B[0];
    
    // IEC60730 Run Time Test Initial
    IWDT->STA.B[0] = (IWDT_STA_EW1F_happened_b0|IWDT_STA_EW0F_happened_b0|IWDT_STA_TF_happened_b0);                                     // Clear IWDT Static.
    IWDT->CLK.B[0] = IWDT_CLK_CK_DIV_div1_b0;                                                                                           // IWDT Clock Set.
    IWDT->INT.B[0] = (IWDT_INT_TIE_disable_b0|IWDT_INT_EW0_IE_disable_b0|IWDT_INT_EW1_IE_disable_b0);                                   // Disable All IWDT Interrupt Configure.
    IWDT->CR0.H[0] = (IWDT_CR0_EW1_WPEN_enable_h0|IWDT_CR0_EW0_WPEN_enable_h0|IWDT_CR0_TF_WPEN_enable_h0|IWDT_CR0_EN_enable_h0);        // IWDT IEC60730 Run Time Test Configure.
    
    IWDT->KEY.H[0] = 0x0000;
    
    return;
}





