/**
 *******************************************************************************
 *
 * @file        MG32_IEC60730_IWDT.c
 *
 * @brief       This file provides firmware functions to manage the following 
 *              functionalities of the CFG peripheral:
 *
 * @par         Project
 *              MG32
 * @version     V1.11
 * @date        2025/07/30
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer 
 * The Demo software is provided "AS IS" without any warranty, either 
 * expressed or implied, including, but not limited to, the implied warranties 
 * of merchantability and fitness for a particular purpose. The author will 
 * not be liable for any special, incidental, consequential or indirect 
 * damages due to loss of data or any other reason. 
 * These statements agree with the world wide and local dictated laws about 
 * authorship and violence against these laws. 
 *******************************************************************************
 *******************************************************************************
 */  
#include "MG32_IEC60730_Common.h"


/**
 *******************************************************************************
 * @brief       
 * @details  
 * @param[in]    
 * @return      
 * @exception      
 * @note        
 *******************************************************************************
 */
IEC60730_Ret IEC60730_IWDT_Test (void)
{
    IEC60730_Ret Return_State;
    uint8_t  POR_Recovery;
    
    
    // Refrech IWDT counter
    IWDT_RefreshCounter();
	IWDT_ClearFlag(IWDT_EW1F|IWDT_EW0F|IWDT_TF);
    POR_Recovery = 0;
    
    // When IWDT unlock
    if(IWDT->KEY.H[1] == 0)
    {
        // When power on not trigger IWDT module
        if(CSC->APB0.MBIT.IWDT_EN == 0)
        {
            // Enable IWDT module on mode clock source
            UnProtectModuleReg(CSCprotect);
            CSC_PeriphOnModeClock_Config(CSC_ON_IWDT, ENABLE);
            ProtectModuleReg(CSCprotect);
        }
        
        // When IWDT module disable 
        if(IWDT->CR0.MBIT.EN == 0)
        {
            UnProtectModuleReg(IWDTprotect);
            IWDT_Divider_Select(IWDT_DIV_1);
            IWDT_Cmd(ENABLE);
            ProtectModuleReg(IWDTprotect);
            POR_Recovery |= 1;
        }
    }
    
    // Waiting EW1F happened
    while(IWDT_GetSingleFlagStatus(IWDT_EW1F) == DRV_UnHappened);
    
    // When EWIF happened IWDT counter fail
    if(IWDT_GetCounter() > 0x40)
    {
        Return_State = IEC60730_TEST_FAILURE;
    }
    else
    {
        Return_State = IEC60730_TEST_SUCCESS;
    }
    
    // When power on not enable IWDT, recovery IWDT register.
    if(POR_Recovery != 0)
    {
        UnProtectModuleReg(IWDTprotect);
        IWDT_Cmd(DISABLE);
        IWDT_Divider_Select(IWDT_DIV_4096);
        ProtectModuleReg(IWDTprotect);
    }
    
    // Clear IWDT all flag
    IWDT_ClearFlag(IWDT_ALLF);
    // Refrech IWDT counter
    IWDT_RefreshCounter();
    return Return_State;
}


