/**
 ******************************************************************************
 *
 * @file        MG32__ExtraStruct.h
 *
 * @brief       MG32 Extra Structure Definition File
 *
 * @par         Project
 *              MG32
 * @version     V1.04 (Register File Date : 2025_1014)
 * @date        2026/01/05 10:06 (H File Generated Date)
 * @author      ExtraStructGen V1.20
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32__ExtraStruct_H
#define _MG32__ExtraStruct_H
#define _MG32__ExtraStruct_H_VER                    104     /*!< File Version */

#include "MG32.h"

/**
 ******************************************************************************
 *
 * @struct      DMAChannel_Struct
 *              DMAChannel  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] DMA channel operation enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  HOLD          :1;     //[1] DMA channel operation hold enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  LOOP          :1;     //[2] DMA loop mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ADSEL         :1;     //[3] DMA address increased mode select
                                        //0 = Normal : sequential increment 1
                                        //1 = SKIP3 : address increment from 0 to 1,2 then return 0
            __I  uint8_t                :2;     //[5..4] 
            __IO uint8_t  LAST          :1;     //[6] DMA Channel-0 last loop command
                                        //0 = Not
                                        //1 = Yes
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  XMDS          :2;     //[9..8] DMA channel external pin trigger request mode select
                                        //0x0 = Disable : disable external request pin input
                                        //0x1 = Single : single request mode
                                        //0x2 = Block : block request mode
                                        //0x3 = Demand : demand request mode(active high)
            __IO uint8_t  PLS           :2;     //[11..10] DMA channel priority level select.
                                        //0x0 = LV0 : lowest priority
                                        //0x1 = LV1 : normal priority
                                        //0x2 = LV2 : high priority
                                        //0x3 = LV3 : highest priority
            __IO uint8_t  BSIZE         :2;     //[13..12] DMA transfer burst size
                                        //0x0 = One
                                        //0x1 = Two
                                        //0x2 = Reserved
                                        //0x3 = Four
            __I  uint8_t                :1;     //[14] 
            __IO uint8_t  REQ           :1;     //[15] DMA channel data transfer request enable
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :1;     //[16] 
            __IO uint8_t  CIE           :1;     //[17] DMA channel-x transfer complete interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  HIE           :1;     //[18] DMA channel-x transfer half interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EIE           :1;     //[19] DMA channel-x transfer error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :1;     //[24] 
            __IO uint8_t  TC2F          :1;     //[25] DMA channel-x transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  TH2F          :1;     //[26] DMA channel-x transfer half flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  ERR2F         :1;     //[27] DMA channel-x transfer error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }A;                                 /*!< A          ~ Offset[0x20]  DMA channel-x control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SRC           :4;     //[3..0] DMA channel transfer peripheral source select
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  DET           :5;     //[12..8] DMA channel transfer peripheral destination select
            __I  uint8_t                :3;     //[15..13] 
            __IO uint8_t  SINC          :1;     //[16] DMA source memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DINC          :1;     //[17] DMA destination memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SSYNC         :1;     //[18] DMA source process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DSYNC         :1;     //[19] DMA destination process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  XPIN          :1;     //[24] DMA channel external trigger pin select.
                                        //0x0 = TRG0 : DMA_TRG0 pin
                                        //0x1 = TRG1 : DMA_TRG1 pin
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }B;                                 /*!< B          ~ Offset[0x24]  DMA channel-x control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t NUM           :16;    //[15..0] DMA transfer data count initial number
            __I  uint8_t                :8;     //[23..16] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }NUM;                               /*!< NUM        ~ Offset[0x28]  DMA channel-x control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t CNT           :16;    //[15..0] DMA transfer data count current value
            __I  uint8_t                :8;     //[23..16] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CNT;                               /*!< CNT        ~ Offset[0x2C]  DMA channel-x control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t SSA           :32;    //[31..0] DMA source or memory transfer start address.
        }MBIT;
    }SSA;                               /*!< SSA        ~ Offset[0x30]  DMA channel-x source start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t SCA           :32;    //[31..0] DMA source or memory transfer current address
        }MBIT;
    }SCA;                               /*!< SCA        ~ Offset[0x34]  DMA channel-x source current address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t DSA           :32;    //[31..0] DMA destination or peripheral transfer start address.
        }MBIT;
    }DSA;                               /*!< DSA        ~ Offset[0x38]  DMA channel-x destination start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t DCA           :32;    //[31..0] DMA destination or peripheral transfer current address
        }MBIT;
    }DCA;                               /*!< DCA        ~ Offset[0x3C]  DMA channel-x destination current address register */

} DMAChannel_Struct;

/**
 ******************************************************************************
 *
 * @name        DMAChannel  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define DMAChannel0_Base                ((uint32_t)0x4BF00020)              /*!< Direct Memory Access Channel Control */
#define DMAChannel1_Base                ((uint32_t)0x4BF00040)              /*!< Direct Memory Access Channel Control */
#define DMAChannel2_Base                ((uint32_t)0x4BF00060)              /*!< Direct Memory Access Channel Control */
#define DMAChannel3_Base                ((uint32_t)0x4BF00080)              /*!< Direct Memory Access Channel Control */
#define DMAChannel4_Base                ((uint32_t)0x4BF000A0)              /*!< Direct Memory Access Channel Control */
#define DMAChannel0                     ((DMAChannel_Struct*) DMAChannel0_Base)
#define DMAChannel1                     ((DMAChannel_Struct*) DMAChannel1_Base)
#define DMAChannel2                     ((DMAChannel_Struct*) DMAChannel2_Base)
#define DMAChannel3                     ((DMAChannel_Struct*) DMAChannel3_Base)
#define DMAChannel4                     ((DMAChannel_Struct*) DMAChannel4_Base)
///@}
/**
 ******************************************************************************
 *
 * @struct      OPA_OP_Struct
 *              OPA_OP  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] OPA OPn power-on enable bit. When disables, it will force the OPA output low.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BY1           :1;     //[1] OPn bypass gain stage-1 enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BY2           :1;     //[2] OPn bypass gain stage-2 enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RES           :1;     //[3] OPn compare response time select.
                                        //0x0 = High : High speed
                                        //0x1 = Low : Low speed
            __IO uint8_t  HYS           :1;     //[4] OPn input hysteresis window select.
                                        //0x0 = No : no hysteresis
                                        //0x1 = LVL1 : with hysteresis about 10mv
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  MDS           :1;     //[6] Comparator CMP0 power-on enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  PMUX          :2;     //[9..8] OPn Analog input positive channel selection.
                                        //0x0 = VBUF
                                        //0x1 = OPn_I0
                                        //0x2 = PGA_P0
                                        //0x3 = Reserved
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  NMUX          :2;     //[13..12] OPn Analog input negative channel selection.
                                        //0x0 = VBUF
                                        //0x1 = OPn_I1
                                        //0x2 = OPn_P0
                                        //0x3 = Reserved
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  INV           :1;     //[16] OPn comparaor mode digital output signal polarity select.
                                        //0 = Positive
                                        //1 = Negative
            __I  uint8_t                :1;     //[17] 
            __IO uint8_t  FSEL          :2;     //[19..18] OPn comparaor mode digital output signal select with synchronized filter
                                        //0x0 = Bypass
                                        //0x1 = OPA_CK : filter with OPA_CLK 
                                        //0x2 = TM00_TRGO : filter with TM00_TRGO
                                        //0x3 = TM01_TRGO : filter with TM01_TRGO
            __IO uint8_t  FDIV          :2;     //[21..20] OPn comparaor mode digital output synchronized filter divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  OFFT          :6;     //[29..24] OPn input offset adjust bits
            __I  uint8_t                :2;     //[31..30] 
        }MBIT;
    }CR;                                /*!< CR         ~ Offset[0x10]  OPA OPA-n control register */

} OPA_OP_Struct;

/**
 ******************************************************************************
 *
 * @name        OPA_OP  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define OPA_OP0_Base                    ((uint32_t)0x5A080010)              /*!< Opearational Amplifier Controller */
#define OPA_OP0                         ((OPA_OP_Struct*) OPA_OP0_Base)
///@}
/**
 ******************************************************************************
 *
 * @struct      CMPAC_Struct
 *              CMPAC  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] Analog comparator CMPn power-on enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :1;     //[2] 
            __IO uint8_t  RES           :1;     //[3] CMPn compare response time select.
                                        //0x0 = 200ns 
                                        //0x1 = 10us (5~10us)
            __IO uint8_t  HYS           :1;     //[4] CMPn input hysteresis window select.
                                        //0x0 = No : no hysteresis
                                        //0x1 = LVL1 : with hysteresis about 5mv
            __I  uint8_t                :3;     //[7..5] 
            __IO uint8_t  PMUX          :3;     //[10..8] CMPn Analog input positive channel selection.
                                        //0x0 =  IVREF
                                        //0x1 = CMPn_I0
                                        //0x2 = CMPn_I1
                                        //0x3 = CMP_C0
                                        //0x4 = CMP_C1
                                        //0x5 = DAC_P0
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  NMUX          :3;     //[14..12] CMPn Analog input negative channel selection.
                                        //0x0 =  IVREF
                                        //0x1 = CMPn_I0
                                        //0x2 = CMPn_I1
                                        //0x3 = CMP_C0
                                        //0x4 = CMP_C1
                                        //0x5 = DAC_P0
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  INV           :1;     //[16] CMPn analog comparator output signal polarity select.
                                        //0 = Positive
                                        //1 = Negative
            __IO uint8_t  PINV          :1;     //[17] CMPn output to pins' signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  FSEL          :2;     //[19..18] CMPn analog comparator output signal select with synchronized filter
                                        //0x0 = Bypass
                                        //0x1 = CMP_CK : filter with CMP_CLK 
                                        //0x2 = TM00_TRGO : filter with TM00_TRGO
                                        //0x3 = TM01_TRGO : filter with TM01_TRGO
            __IO uint8_t  FDIV          :2;     //[21..20] CMPn analog comparator output synchronized filter divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :7;     //[30..24] 
            __IO uint8_t  IVROE         :1;     //[31] IVREF output to CMPn_I0 pin enable bit for positive channel MUX .
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }CR;                                /*!< CR         ~ Offset[0x10]  CMP Analog comparator-n control register */

} CMPAC_Struct;

/**
 ******************************************************************************
 *
 * @name        CMPAC  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define CMPAC0_Base                     ((uint32_t)0x5C000010)              /*!< Analog Comparator Control */
#define CMPAC1_Base                     ((uint32_t)0x5C000014)              /*!< Analog Comparator Control */
#define CMPAC0                          ((CMPAC_Struct*) CMPAC0_Base)
#define CMPAC1                          ((CMPAC_Struct*) CMPAC1_Base)
///@}
/**
 ******************************************************************************
 *
 * @struct      OBM_Struct
 *              OBM  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  MDS           :2;     //[1..0] OBMx break operation mode select
                                        //0x0 = AND : AND signal of all break channels' output
                                        //0x1 = CLR : STA bit is cleared by falling edge of OR signal
                                        //0x2 = SET : STA bit is set by falling edge of OR signal
                                        //0x3 = TOGGLE : STA bit is toggle by falling edge of OR signal
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  STA           :1;     //[4] OBMx break switching signal initial state
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  LCK           :1;     //[5] OBMx break switching signal initial state write control
                                        //0 = Locked
                                        //1 = Un-Locked
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  BKN0          :1;     //[8] OBMx break source-0 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  BKN1          :1;     //[9] OBMx break source-1 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  BKN2          :1;     //[10] OBMx break source-2 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :5;     //[15..11] 
            __IO uint8_t  BKS0          :4;     //[19..16] OBMx break signal source channel-0 select.
                                        //0x0 = BK0 : Output 1
                                        //0x1 = BK1
                                        //0x2 = BK2
                                        //0x3 = BK3
                                        //0x4 = BK4
                                        //0x5 = BK5
                                        //0x6 = BK6
                                        //0x7 = BK7
                                        //0x8 = BK8
                                        //0x9 = BK9
                                        //0xA = BK10
                                        //0xB = BK11
                                        //0xC = BK12
                                        //0xD = BK13
                                        //0xE = BK14
                                        //0xF = BK15
            __IO uint8_t  BKS1          :4;     //[23..20] OBMx break signal source channel-1 select.
                                        //0x0 = BK0 : Output 1
                                        //0x1 = BK1
                                        //0x2 = BK2
                                        //0x3 = BK3
                                        //0x4 = BK4
                                        //0x5 = BK5
                                        //0x6 = BK6
                                        //0x7 = BK7
                                        //0x8 = BK8
                                        //0x9 = BK9
                                        //0xA = BK10
                                        //0xB = BK11
                                        //0xC = BK12
                                        //0xD = BK13
                                        //0xE = BK14
                                        //0xF = BK15
            __IO uint8_t  BKS2          :4;     //[27..24] OBMx break signal source channel-2 select.
                                        //0x0 = BK0 : Output 1
                                        //0x1 = BK1
                                        //0x2 = BK2
                                        //0x3 = BK3
                                        //0x4 = BK4
                                        //0x5 = BK5
                                        //0x6 = BK6
                                        //0x7 = BK7
                                        //0x8 = BK8
                                        //0x9 = BK9
                                        //0xA = BK10
                                        //0xB = BK11
                                        //0xC = BK12
                                        //0xD = BK13
                                        //0xE = BK14
                                        //0xF = BK15
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }OBMx0;                             /*!< OBMx0      ~ Offset[0x20]  APB OBMx control register-0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  INV0          :1;     //[0] OBMx source channel-0 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  INV1          :1;     //[1] OBMx source channel-1 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  POL           :1;     //[2] OBMx output signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  FCKS          :2;     //[5..4] OBMx output deglitch filter clock source select
                                        //0x0 = Disable
                                        //0x1 = APB : CLK_APB
                                        //0x2 = APB_DIV8 : CLK_APB divide by 8
                                        //0x3 = TM00_TRGO
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  MUX0          :4;     //[19..16] OBMx output source channel-0 signal select.
                                        //0x0 = SR0 : Output 0
                                        //0x1 = SR1
                                        //0x2 = SR2
                                        //0x3 = SR3
                                        //0x4 = SR4
                                        //0x5 = SR5
                                        //0x6 = SR6
                                        //0x7 = SR7
                                        //0x8 = SR8
                                        //0x9 = SR9
                                        //0xA = SR10
                                        //0xB = SR11
                                        //0xC = SR12
                                        //0xD = SR13
                                        //0xE = SR14
                                        //0xF = SR15
            __IO uint8_t  MUX1          :4;     //[23..20] OBMx output source channel-1 signal select.
                                        //0x0 = SR0 : Output 0
                                        //0x1 = SR1
                                        //0x2 = SR2
                                        //0x3 = SR3
                                        //0x4 = SR4
                                        //0x5 = SR5
                                        //0x6 = SR6
                                        //0x7 = SR7
                                        //0x8 = SR8
                                        //0x9 = SR9
                                        //0xA = SR10
                                        //0xB = SR11
                                        //0xC = SR12
                                        //0xD = SR13
                                        //0xE = SR14
                                        //0xF = SR15
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }OBMx1;                             /*!< OBMx1      ~ Offset[0x24]  APB OBMx control register-1 */

} OBM_Struct;

/**
 ******************************************************************************
 *
 * @name        OBM  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define OBM0_Base                       ((uint32_t)0x5F000020)              /*!< APB OBM Control */
#define OBM1_Base                       ((uint32_t)0x5F000028)              /*!< APB OBM Control */
#define OBM0                            ((OBM_Struct*) OBM0_Base)
#define OBM1                            ((OBM_Struct*) OBM1_Base)
///@}
/**
 ******************************************************************************
 *
 * @struct      CCL_Struct
 *              CCL  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] CCL enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  TEN           :1;     //[1] CCL truth table enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  FTSEL         :2;     //[5..4] CCL filter select.
                                        //0x0 = Disable
                                        //0x1 = SYNC : Synchronizer enabled
                                        //0x2 = FILTER : Filter enabled
                                        //0x3 = Reserved
            __IO uint8_t  EDSEL         :2;     //[7..6] CCL edge detector mode select.
                                        //0x0 = Disable
                                        //0x1 = Rising
                                        //0x2 = Falling
                                        //0x3 = Dual-edge
            __IO uint8_t  SQSEL         :3;     //[10..8] CCL sequential logic mode select.
                                        //0x0 = Disable
                                        //0x1 = DFF : D flip flop
                                        //0x2 = JK : JK flip flop
                                        //0x3 = DLH : D latch
                                        //0x4 = RS : RS latch
            __IO uint8_t  INV           :1;     //[11] CCL output inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  DIV           :2;     //[13..12] CCL internal clock input divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  TRUTH         :8;     //[23..16] CCL lookup truth table output value difinitions for mapping input states.
            __IO uint8_t  SQIN          :2;     //[25..24] CCL sequential logic input CCL_S0 select.
                                        //0x0 = 0
                                        //0x1 = 1
                                        //0x2 = CCL_S1
                                        //0x3 = Reserved
            __I  uint8_t                :4;     //[29..26] 
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CCLx0;                             /*!< CCLx0      ~ Offset[0x20]  APX CCLx control register-0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  MUX0          :4;     //[3..0] CCL IN0 input Mux select.
                                        //0x0 = Disable : Mask input
                                        //0x1 = IN01 : Feedback from CCLn_SEQ signal
                                        //0x2 = IN02 : Link from CCLn_AO signal
                                        //0x3 = IN03 : PB11
                                        //0x4 = IN04 : PA8
                                        //0x5 = IN05 : PB0
                                        //0x6 = IN06 : PB8
                                        //0x7 = IN07 : PE0
                                        //0x8 = IN08 : CMP0_OUT
                                        //0x9 = IN09 : URT0_TX
                                        //0xA = IN0A : SPI0_MOSI (output)
                                        //0xB = IN0B : TM36_OC00
                                        //0xC = IN0C : TM26_OC00
                                        //0xD = IN0D : SDT_I0
                                        //0xE = IN0E : OBM_P0
                                        //0xF = IN0F : Reserved
            __IO uint8_t  MUX1          :4;     //[7..4] CCL IN1 input Mux select.
                                        //0x0 = Disable : Mask input
                                        //0x1 = IN01 : Feedback from CCLn_SEQ signal
                                        //0x2 = IN02 : Link from CCLn_AO signal
                                        //0x3 = IN03 : PB3
                                        //0x4 = IN04 : PA9
                                        //0x5 = IN05 : PB1
                                        //0x6 = IN06 : PB9
                                        //0x7 = IN07 : PE1
                                        //0x8 = IN08 : CMP1_OUT
                                        //0x9 = IN09 : URT1_TX
                                        //0xA = IN0A : SPI0_MISO (output)
                                        //0xB = IN0B : TM36_OC10
                                        //0xC = IN0C : TM26_OC10
                                        //0xD = IN0D : SDT_I1
                                        //0xE = IN0E : OBM_I0
                                        //0xF = IN0F : Reserved
            __IO uint8_t  MUX2          :4;     //[11..8] CCL IN2 input Mux select.
                                        //0x0 = Disable : Mask input
                                        //0x1 = IN01 : Feedback from CCLn_SEQ signal
                                        //0x2 = IN02 : Link from CCLn_AO signal
                                        //0x3 = IN03 : PC1
                                        //0x4 = IN04 : PA10
                                        //0x5 = IN05 : PB2
                                        //0x6 = IN06 : PB10
                                        //0x7 = IN07 : PE2
                                        //0x8 = IN08 : ADC0_OUT
                                        //0x9 = IN09 : URT4_TX
                                        //0xA = IN0A : SPI0_CLK
                                        //0xB = IN0B : TM36_OC2
                                        //0xC = IN0C : TM20_OC00
                                        //0xD = IN0D : SDT_P0
                                        //0xE = IN0E : OBM_I1
                                        //0xF = IN0F : Reserved
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CCLx1;                             /*!< CCLx1      ~ Offset[0x24]  APX CCLx control register-1 */

} CCL_Struct;

/**
 ******************************************************************************
 *
 * @name        CCL  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define CCL0_Base                       ((uint32_t)0x5F010020)              /*!< APX CCL Control */
#define CCL1_Base                       ((uint32_t)0x5F010028)              /*!< APX CCL Control */
#define CCL0                            ((CCL_Struct*) CCL0_Base)
#define CCL1                            ((CCL_Struct*) CCL1_Base)
///@}

/**
 ******************************************************************************
 *
 * @struct      EXIC_PX_Struct
 *              EXIC_PX  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PIN0_PF        :1;     /*!< [0] EXIC pin input interrupt pending flag x for external input interrupt pin of PX*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN1_PF        :1;     /*!< [1] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN2_PF        :1;     /*!< [2] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN3_PF        :1;     /*!< [3] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN4_PF        :1;     /*!< [4] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN5_PF        :1;     /*!< [5] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN6_PF        :1;     /*!< [6] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN7_PF        :1;     /*!< [7] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN8_PF        :1;     /*!< [8] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN9_PF        :1;     /*!< [9] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN10_PF       :1;     /*!< [10] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN11_PF       :1;     /*!< [11] Refer to EXIC_PX0_PF. */ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN12_PF       :1;     /*!< [12] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN13_PF       :1;     /*!< [13] Refer to EXIC_PX0_PF.*/ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN14_PF       :1;     /*!< [14] Refer to EXIC_PX0_PF. */ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __IO uint8_t  PIN15_PF       :1;     /*!< [15] Refer to EXIC_PX0_PF. */ 
                                                 /*!< 0 = Normal : No event occurred */ 
                                                 /*!< 1 = Happened : Event happened */ 
            __I  uint16_t               :16;     /*!< [31..16] */ 
        }MBIT;
    }PF;                                        /*!< PX_PF      ~ Offset[0x20]  EXIC PX input interrupt pending flag register */                           

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PIN0_TRGS      :2;     /*!<[1..0] External interrupt pin edge/level trigger event select */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN1_TRGS      :2;     /*!<[3..2] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN2_TRGS      :2;     /*!<[5..4] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN3_TRGS      :2;     /*!<[7..6] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN4_TRGS      :2;     /*!<[9..8] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN5_TRGS      :2;     /*!<[11..10] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN6_TRGS      :2;     /*!<[13..12] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN7_TRGS      :2;     /*!<[15..14] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN8_TRGS      :2;     /*!<[17..16] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN9_TRGS      :2;     /*!<[19..18] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN10_TRGS     :2;     /*!<[21..20] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN11_TRGS     :2;     /*!<[23..22] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN12_TRGS     :2;     /*!<[25..24] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN13_TRGS     :2;     /*!<[27..26] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN14_TRGS     :2;     /*!<[29..28] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
            __IO uint8_t  PIN15_TRGS     :2;     /*!<[31..30] Refer to EXIC_PX0_TRGS. */ 
                                                 /*!<0x0 = No : No updated flag */ 
                                                 /*!<0x1 = Level */ 
                                                 /*!<0x2 = Edge */ 
                                                 /*!<0x3 = Dual-edge */ 
        }MBIT;
    }TRGS;                                       /*!< PX_TRGS    ~ Offset[0x24]  EXIC PX Pad input trigger select register */        

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PIN0_OM        :1;    /*!<[0] External interrupt pin of PX OR mask bit x */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN1_OM        :1;    /*!<[1] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN2_OM        :1;    /*!<[2] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN3_OM        :1;    /*!<[3] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN4_OM        :1;    /*!<[4] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN5_OM        :1;    /*!<[5] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN6_OM        :1;    /*!<[6] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN7_OM        :1;    /*!<[7] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN8_OM        :1;    /*!<[8] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN9_OM        :1;    /*!<[9] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN10_OM       :1;    /*!<[10] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN11_OM       :1;    /*!<[11] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN12_OM       :1;    /*!<[12] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN13_OM       :1;    /*!<[13] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN14_OM       :1;    /*!<[14] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN15_OM       :1;    /*!<[15] Refer to EXIC_PX0_OM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN0_AM        :1;    /*!<[16] External interrupt pin of PX AND mask bit x */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable  */
            __IO uint8_t  PIN1_AM        :1;    /*!<[17] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN2_AM        :1;    /*!<[18] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN3_AM        :1;    /*!<[19] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN4_AM        :1;    /*!<[20] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN5_AM        :1;    /*!<[21] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN6_AM        :1;    /*!<[22] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN7_AM        :1;    /*!<[23] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN8_AM        :1;    /*!<[24] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN9_AM        :1;    /*!<[25] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN10_AM       :1;    /*!<[26] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN11_AM       :1;    /*!<[27] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN12_AM       :1;    /*!<[28] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN13_AM       :1;    /*!<[29] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN14_AM       :1;    /*!<[30] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable */
            __IO uint8_t  PIN15_AM       :1;    /*!<[31] Refer to EXIC_PX0_AM. */
                                                /*!<0 = Disable (Mask) */
                                                /*!<1 = Enable    */
                                        
        }MBIT;                                  
    }MSK;                                       /*!< PX_MSK     ~ Offset[0x28]  EXIC PX AOI Mask register */
}EXIC_PX_Struct;

/**
 ******************************************************************************
 *
 * @name        EXIC_PX  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define EXIC_PA_Base    ((uint32_t)(0x50000000+0x20))   /*!< EXIC PA Register Control Definitions base address*/
#define EXIC_PB_Base    ((uint32_t)(0x50000000+0x30))   /*!< EXIC PB Register Control Definitions base address*/
#define EXIC_PC_Base    ((uint32_t)(0x50000000+0x40))   /*!< EXIC PC Register Control Definitions bass address*/
#define EXIC_PD_Base    ((uint32_t)(0x50000000+0x50))   /*!< EXIC PD Register Control Definitions bass address*/
#define EXIC_PE_Base    ((uint32_t)(0x50000000+0x80))   /*!< EXIC PE Register Control Definitions bass address*/

#define EXIC_PA         ((EXIC_PX_Struct*) EXIC_PA_Base)    /*!< EXIC PA Register Control Definitions */
#define EXIC_PB         ((EXIC_PX_Struct*) EXIC_PB_Base)    /*!< EXIC PB Register Control Definitions */
#define EXIC_PC         ((EXIC_PX_Struct*) EXIC_PC_Base)    /*!< EXIC PC Register Control Definitions */
#define EXIC_PD         ((EXIC_PX_Struct*) EXIC_PD_Base)    /*!< EXIC PD Register Control Definitions */
#define EXIC_PE         ((EXIC_PX_Struct*) EXIC_PE_Base)    /*!< EXIC PE Register Control Definitions */
///@}


#endif  // _MG32__ExtraStruct_H

/*----------------------------------------------------------------------------*/
/*                      End of file MG32__ExtraStruct.h                       */
/*----------------------------------------------------------------------------*/
