


/**
 ******************************************************************************
 *
 * @file        BSP_8_VariableResistor.h
 * @brief       This is Variable Resistor H file.
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2022/05/124
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
#ifndef _BSP_8_VARIABLERESISTOR_H

#define _BSP_8_VARIABLERESISTOR_H


#include "MG32_GPIO_DRV.h"
#include "MG32_ADC_DRV.h"
#include "MG32_GPL_DRV.h"

/**
 * @name define
 *   		
 */ 
///@{
#define VR_CHANGEFLAG_VR1                0x01         /*!<ChangeFlag VR1 mask.*/
#define VR_CHANGEFLAG_VR2                0x02         /*!<ChangeFlag VR2 mask.*/
                                         
#define VR1_DATA                         0
#define VR2_DATA                         1
                             
/**
 *******************************************************************************
 * @brief       
 * @param[in]   "__HANDLE__" : 
 * @return		
 *******************************************************************************
 */                             
#define BSP_VR_GETADCData(__HANDLE__)    VR_CTR.VR_ADCData[(__HANDLE__)]

/**
 *******************************************************************************
 * @brief       
 * @param[in]   "__HANDLE__" : 
 * @return		
 *******************************************************************************
 */
#define BSP_VR_GETPERCENTAGE(__HANDLE__) VR_CTR.VR_Status[(__HANDLE__)]

///@}


/**
 * @name typedef
 *   		
 */ 
///@{

/*! @struct VRCTR_TypeDef
    @brief  VR control struct
*/ 
typedef struct __attribute__((packed))
{
    uint8_t  ChangeFlag;
    uint8_t  VR_Status[2];
    uint16_t VR_ADCData[2];
    uint8_t  ADCCalibration_Complete;
}VRCTR_TypeDef;


///@}


/**
 * @name variables
 *   		
 */ 
///@{
extern VRCTR_TypeDef VR_CTR;
///@}

/**
 * @name function
 *   		
 */ 
///@{
void BSP_VR_Init(void);
void BSP_VR_main(void);
///@}
 
 
 
 
#endif
