
/**
 ******************************************************************************
 *
 * @file        MG32_CSC_Init.h
 *
 * @brief       This file is used to configure CSC setting.
 *              Device : MG32F02U128
 *
 * @par         Project
 *              MG32
 * @version     V0.63
 * @date        2021/11/02 15:11 (H File Generated Date)
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 */
 #include "MG32.h"
 
 
typedef enum{
    GPIO_AIN = 0,
    GPIO_OD  = 1,
    GPIO_PP  = 2,
    GPIO_DIN = 3,
    GPIO_QB  = 4,
    GPIO_MSK = 7,
}BSP_Button_IOModeTypeDef;

typedef enum{
    PortA = 0,
    PortB = 1,
    PortC = 2,
    PortD = 3,
    PortE = 4,
}BSP_Button_PortTypeDef;
 
typedef enum{
    PIN0    = 1,                  // Bit 0
    PIN1    = 2,                  // Bit 1
    PIN2    = 4,                  // Bit 2
    PIN3    = 8,                  // Bit 3
    PIN4    = 16,                 // Bit 4
    PIN5    = 32,                 // Bit 5
    PIN6    = 64,                 // Bit 6
    PIN7    = 128,                // Bit 7
    PIN8    = 256,                // Bit 8
    PIN9    = 512,                // Bit 9
    PIN10   = 1024,               // Bit 10
    PIN11   = 2048,               // Bit 11
    PIN12   = 4096,               // Bit 12
    PIN13   = 8192,               // Bit 13
    PIN14   = 16384,              // Bit 14
    PIN15   = 32768,              // Bit 15
    PINALL  = 65535,              // ALL PIN
}BSP_Button_PinTypeDef;
 

/**
 * @name    Function announce
 *   
 */
///@{  
uint16_t BSP_Button_Init(uint8_t GPIOx, uint16_t BSP_SET_PIN);
uint16_t BSP_Button_GetState(uint8_t GPIOx, uint16_t BSP_SET_PIN);
uint8_t BSP_Button_SetGPIO(uint8_t GPIOx, uint8_t PIN_NUM, uint8_t IO_Mode);
uint8_t BSP_Button_Uninit(uint8_t GPIOx, uint8_t PIN_NUM);
uint16_t BSP_Button_GetCount(void);
///@}  


