/**
 ******************************************************************************
 *
 * @file        BSP_BLE.h
 * @brief       BLE_MG126 BSP h Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2022/01/06
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2021 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 

#ifndef _BSP_BLE_H
#define _BSP_BLE_H

#include "MG32_DRV.h"
#include "MG32_SPI_MID.h"

typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef uint64_t u64;

/* Private typedef -----------------------------------------------------------*/
/*******************************************************************************
                 *****DataBase****

01 - 06  GAP (Primary service) 0x1800
  03:04  name
07 - 0f  Device Info (Primary service) 0x180a
  0a:0b  firmware version
  0e:0f  software version
10 - 19  LED service (Primary service) 6E400001-B5A3-F393-E0A9-E50E24DCCA9E
  11:12  6E400003-B5A3-F393-E0A9-E50E24DCCA9E(0x04)  RxNotify
  13     cfg
  14:15  6E400002-B5A3-F393-E0A9-E50E24DCCA9E(0x0C)  Tx
  16     cfg
  17:18  6E400004-B5A3-F393-E0A9-E50E24DCCA9E(0x0A)  BaudRate
  19     0x2901  info
*******************************************************************************/
typedef struct ble_character16
{
    u16 type16;             //type2
    u16 handle_rec;         //handle
    u8  characterInfo[5];   //property1 - handle2 - uuid2
    u8  uuid128_idx;        //0xff means uuid16,other is idx of uuid128
}BLE_CHAR;

typedef struct ble_UUID128
{
    u8  uuid128[16];//uuid128 string: little endian
}BLE_UUID128;

extern volatile u16 cur_notifyhandle;
extern volatile u8 BLE_RXF;
extern volatile BLE_CHAR AttCharList[];
extern BLE_UUID128 AttUuid128List[];

/*! @name 
*/
/* @{ */
// TH188A_MGF02A072_132 LQFP-80_V20
// TH218A_MG32F02A128 LQFP-80_EV_V10
#if (defined(MG32_1ST) || defined(MG32_3RD))
#define LED1_CSC_ON_Port        CSC_ON_PortE        // 
#define LED1_PINSET             PINE(13)            //
#define LED1_PIN                PE13                //
#endif

// TH197B_MG32F02A032 LQFP48_EV_V11
#if defined(MG32_2ND) || defined(MG32_4TH)
#define LED1_CSC_ON_Port        CSC_ON_PortC        //
#define LED1_PINSET             PINC(0)             //
#define LED1_PIN                PC0                 //
#endif

// BLE used EXIC pin define
#define EXIC_CFG_PIN            PINB(10)            //
#define EXIC_TRGS_PINX          EXIC_TRGS_PIN10     //
#define EXIC_PX_PINX            EXIC_PX_PIN10       //
#define EXIC_PX_AND_MASK_PINX   EXIC_PX_PIN10       //
#define EXIC_PX_OR_MASK_PINX    EXIC_PX_PIN10       //
#define EXIC_PIN                PB10                //

// LED
#define LED_OFF                 1                   //
#define LED_ON                  0                   //

// SPI 
#define BLE_MODULE              SPI_SPI0            // BLE_MODULE used SPI0
#define SPI_NSS                 PB0                 // SPI_NSS(SPI) for all
//#define BLE_MODULE              SPI_URT1            // BLE_MODULE used URT1
//#define SPI_NSS                 PD6                 // SPI_NSS(UART1) for MG32F02A132/A072
//#define SPI_NSS                 PC13                // SPI_NSS(UART1) for MG32F02A032/V032
//#define SPI_NSS                 PC7                 // SPI_NSS(UART1) for MG32F02A128/A064/U128/U064
/* @} */


void BSP_Init (void);
void LED_Flash (void);
void IrqMcuGotoSleepAndWakeup (void);
DRV_Return SPIx_Init (MID_SPI_Struct* BLE_MD, uint32_t ProcessClockRate, uint32_t BLEClockRate);
void BSP_BLE_WriteTxBuffer (u8* Index, u8 len);
void BSP_BLE_ClearBleTxBuffer (void);
u8 BSP_BLE_ReadRxBuffer (u8* DestIndex);
void BSP_BLE_ClearBleRxBuffer (void);

#define BSP_BLE_IrqMcuGotoSleepAndWakeup        IrqMcuGotoSleepAndWakeup

#endif



