

/**
 ******************************************************************************
 *
 * @file        
 * @brief        
 *
 * @par         Project
 *              MG32F02N128
 * @version     V1.00
 * @date        2024/08/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _LCD_DRAMA_H
#define _LCD_DRAMA_H


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "BSP_LCD.h"
#include "Calendar.h"

/* Menu ----------------------------------------------------------------------*/
/* Define --------------------------------------------------------------------*/
#define LCD_DRAMA_BREAK           0
#define LCD_DRAMA_CALENDAR        1
#define LCD_DRAMA_TEMP            2
#define LCD_DRAMA_RH              3
#define LCD_DRAMA_ATM_KPa         4
#define LCD_DRAMA_ATM_MPa         5
#define LCD_DRAMA_VOLT_V          6
#define LCD_DRAMA_VOLT_mV         7
#define LCD_DRAMA_DC_A            8
#define LCD_DRAMA_DC_mA           9
#define LCD_DRAMA_SPLASH_SCREEN   48


#define LED_DRAMA_OFF             0
#define LED_DRAMA_FLASHING        1
#define LED_DRAMA_VAR             2

#define ARGB_DRAMA_NA             0
#define ARGB_DRAMA_OFF            1
#define ARGB_DRAMA_CALENDAR       2
#define ARGB_DRAMA_SPLASH_SCREEN  3

#define DRAMA_UPDATE_NO           0
#define DRAMA_UPDATE              1




/* Typedef -------------------------------------------------------------------*/
/* Macro ---------------------------------------------------------------------*/
/* variables -----------------------------------------------------------------*/
/* Functions -----------------------------------------------------------------*/
void Drama_Init(void);

uint8_t Drama_LCD_Handler(void);
uint8_t Drama_LCD_Update( uint8_t Drama_LCD_Mode);
void Drama_LCD_SplashScreen_HalfCallback(void);
void Drama_LCD_SplashScreen_CpltCallback(void);

void Drama_LEDMode_Config(uint8_t Drama_LED_Mode);
void Drama_LED_Handler(void);


void Drama_ARGBMode_Config( uint8_t Drama_ARGB_Mode);
void Drama_ARGB_Handler(void);

#endif







