

/**
 ******************************************************************************
 *
 * @file        mg_test_api.h
 * @brief       BLE_MG126 mg_test_api h Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.03
 * @date        2020/08/03
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _MG_TESTAPI_H_
#define _MG_TESTAPI_H_




///////////////////////////test APIs/////////////////////////////////

//Parameters: freq - input, 0~80, center frequency(2400+freq)MHz, txpwr - input, 0x20~0x4A, txpower
//return: None. in testing, add while(1); after calling this function
void test_SRRCCarrier(unsigned char  freq, unsigned char txpwr);

//Parameters: freq - input, 0~80, center frequency(2400+freq)MHz, txpwr - input, 0x20~0x4A, txpower
//return: None. in testing, add while(1); after calling this function
void test_PRBS9(unsigned char freq, unsigned char txpwr);

//Parameters: freq - input, 0~80, center frequency(2400+freq)MHz
//return: None. in testing, add while(1); after calling this function
void test_RX(unsigned char freq);


//Parameters: freq - input, 0~80, center frequency(2400+freq)MHz, txpwr - input, 0x20~0x4A, txpower
//return: None. in testing, add while(1); after calling this function
void test_carrier(unsigned char freq, unsigned char txpwr);

unsigned char* GetTestLibVer(void);

///////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////app implemented/porting functions//////////////////////////////
//unsigned int GetSysTickCount(void);


#endif
