
/**
 ******************************************************************************
 *
 * @file        main.c
 * @brief       This is main C file.
 
 * @par         Project
 *              MG32
 * @version     V1.03
 * @date        2023/05/10
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
/* Includes ------------------------------------------------------------------*/ 
#include "MG32.h"
#include "MG32_ChipInit.h"
#include "__BSP_Wizard.h"
#include "TH222x_Global.h"

// ----------------------------------------------------------------------------
#if BSP_2_ARGB == 1
    #include "BSP_2_ARGB_WS2812.h"
#endif  
// ----------------------------------------------------------------------------
#if BSP_3_RGB == 1  
    #include "BSP_3_RGB.h"
#endif
// ----------------------------------------------------------------------------
#if BSP_7_STEP_MOTOR == 1 
    #include "BSP_7_StepMotor.h" 
#endif
// ----------------------------------------------------------------------------
#if BSP_8_VAR == 1
    #include "BSP_8_VariableResistor.h"
#endif
// ----------------------------------------------------------------------------
#if BSP_9_ROTARY_ENCODER == 1
    #include "BSP_9_RotaryEncoder.h"
#endif
// ----------------------------------------------------------------------------
#if BSP_10_BUZZER == 1
    #include "BSP_10_Buzzer.h"
#endif
// ----------------------------------------------------------------------------
#if BSP_11_RC_SERVO_MOTOR == 1
    #include "BSP_11_RCServoMotor.h"
#endif
// ----------------------------------------------------------------------------
// The BLE library does not support GCC.
#if BSP_12_BLE == 1
    #if BSP_12_BLE_MODULE == BSP_12_BLE_MODULE_HC06
        #include "BSP_12_BLE_HC06.h"
    #endif
    #if BSP_12_BLE_MODULE == BSP_12_BLE_MODULE_HC42
        #include "BSP_12_BLE_HC42.h"
    #endif
#endif
// ----------------------------------------------------------------------------
#if BSP_13_SPIFLASH == 1
    #include "BSP_13_SPIFlash.h"
#endif
// ----------------------------------------------------------------------------
#if BSP_14_EEPROM == 1
    #include "BSP_14_EEPROM.h"
#endif
// ----------------------------------------------------------------------------
#if BSP_15_4X4_KEYBOARD == 1
    #include "BSP_15_4x4Keyboard.h"
#endif
// ----------------------------------------------------------------------------
#if BSP_17_2COLOR_DOTMATRIX_LED == 1
    #include "BSP_17_2ColorDotMatrixLED.h"
#endif
// ----------------------------------------------------------------------------
#if BSP_18_7SEGMENT_DISPLAY == 1
    #include "BSP_18_7Segment.h" 
#endif
// ----------------------------------------------------------------------------
#if BSP_19_LCD == 1
    #include "BSP_19_LCD.h"
#endif

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

void ChipInit(void);                // chip initial 

// ----------------------------------------------------------------------------
#if (BSP_13_SPIFLASH == 1) || (BSP_14_EEPROM==1)
static void TH222x_TestStorageItem(void);
#endif

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief       TH222x main routine	   
 * @return      None
 * @note        No
 *******************************************************************************
 */
int main(void)
{

    // ------------------------------------------------------------------------
    // chip initial (User can enable CSC, GPIO, TM, ADC, EXIC ... wizard)
    // ------------------------------------------------------------------------
    ChipInit();
    
    // ------------------------------------------------------------------------
    // Test Storage.
    // ------------------------------------------------------------------------
    //      1. Test Flash 
    //      2. Test EEPROM
    // ------------------------------------------------------------------------
    #if (BSP_13_SPIFLASH == 1) || (BSP_14_EEPROM==1)
        TH222x_TestStorageItem();
    #endif
  
    // ------------------------------------------------------------------------
    // Initial TH223x+TH222x module.
    // ------------------------------------------------------------------------
    //      1. Disable IWDT.
    //      2. Initial SW3/SW4 pin with EXIC interrupt.
    //      3. Initial LEDs pin I/O mode.
    //      4. Initial SysTick.
    //      5. Initial BSP test module.
    //      6. Delay a time.
    // ------------------------------------------------------------------------
    TH222x_Init();
    
    // ------------------------------------------------------------------------
    // The Project Software Parameter Default Initial.
    // ------------------------------------------------------------------------
    TH222x_Parameter_DeInit();
    
    // ------------------------------------------------------------------------
    while(1)
    {
        // --------------------------------------------------------------------
        // 1. Check SW3, SW4 button state. (+Buzzer control, +StepMotor Control)
        // 2. Control R/G/B LED ON/OFF.
        // --------------------------------------------------------------------
        TH222x_main();
        
        // --------------------------------------------------------------------
        // Control ARGB LED (WS2812) through by URT0 module
        // --------------------------------------------------------------------
        #if BSP_2_ARGB == 1
            TH222x_ARGB();          
        #endif        
        // --------------------------------------------------------------------
        // TM36 output PWM to control RGB LEDs.
        // --------------------------------------------------------------------
        #if BSP_3_RGB == 1    
            TH222x_RGB();
        #endif        
        // --------------------------------------------------------------------
        // Normal GPIO control step motor with timer tick.
        // --------------------------------------------------------------------
        #if BSP_7_STEP_MOTOR == 1
            TH222x_StepMotor();        
        #endif
        // --------------------------------------------------------------------
        // ADC sample variable resistor 
        // --------------------------------------------------------------------
        #if BSP_8_VAR == 1
            TH222x_VariableResistor();     
        #endif
        // --------------------------------------------------------------------
        // Demonstartion QEI(TM26) functionality on rotary encoder.
        // --------------------------------------------------------------------
        #if BSP_9_ROTARY_ENCODER == 1
            TH222x_RotaryEncoder();        
        #endif
        // --------------------------------------------------------------------
        // GPIO control buzzer.
        // --------------------------------------------------------------------
        #if BSP_10_BUZZER == 1
            TH222x_Buzzer();        
        #endif
        // --------------------------------------------------------------------
        // Control the rotary angle of the RC servo motor.
        // --------------------------------------------------------------------
        #if BSP_11_RC_SERVO_MOTOR == 1
            TH222x_RCServoMotor();        
        #endif
        // --------------------------------------------------------------------
        // The BLE library does not support GCC.
        // --------------------------------------------------------------------
        #if BSP_12_BLE == 1
            TH222x_BLE();
        #endif

        // --------------------------------------------------------------------
        // Get and analyze 4x4 Keyboard state.
        // --------------------------------------------------------------------
        #if BSP_15_4X4_KEYBOARD == 1
            TH222x_4x4Keyboard();
        #endif
        // --------------------------------------------------------------------
        // Demonstarts an 8x8 dot matrix LED with 2 colors.
        // --------------------------------------------------------------------
        #if BSP_17_2COLOR_DOTMATRIX_LED == 1
            TH222x_2ColorDotMatrix();
        #endif
        // --------------------------------------------------------------------
        // Show information on 4x7-SEG display.
        // --------------------------------------------------------------------
        #if BSP_18_7SEGMENT_DISPLAY == 1
            TH222x_7Segment();          
        #endif
    }
}

/**
 *******************************************************************************
 * @brief       Only test SPI Flash or I2C EEPROM. 
 * @details     When BSP_13_SPIFLASH=1 or BSP_14_EEPROM=1, then test Flash or EEPROM.
 * @return      None
 * @note        No
 *******************************************************************************
 */
#if (BSP_13_SPIFLASH == 1) || (BSP_14_EEPROM==1)
static void TH222x_TestStorageItem(void)
{
    // ------------------------------------------------------------------------
    // Test SPI Flash (TH222x_SPIFlash).
    //      1. Disable IWDT.
    //      2. Initial SPI module.
    //      3. Check Flash ID. (ID=0x1728C2)
    //      4. Erase Flash + Read it to check. 
    //      5. Program Flash + Read it to check. 
    // ------------------------------------------------------------------------
    #if BSP_13_SPIFLASH == 1
        if(TH222x_SPIFlash() == TH222x_SUCCESS)
        {
            TH222x_CTR.TestFlashResult  = TH222x_SUCCESS;
        }
        else
        {
            TH222x_CTR.TestFlashResult  = TH222x_FAILURE;
        }   
        
        // Release Flash SPI0 Pin becasue BLE also use SPI0.  
        GPIO_PinFunction_Select(PIND(1),0);            
        GPIO_PinFunction_Select(PIND(2),0);
        GPIO_PinFunction_Select(PIND(3),0);
        GPIO_PinFunction_Select(PIND(7),0);
        GPIO_PinFunction_Select(PIND(8),0);
    #endif
        
    // ------------------------------------------------------------------------
    // Test EEPROM (TH222x_EEPROM)
    //      1. Disable IWDT.
    //      2. Write data to EEPROM.
    //      3. Read it from EEPROM.
    //      4. Check data.
    // ------------------------------------------------------------------------
    #if BSP_14_EEPROM == 1
        if(TH222x_EEPROM() == TH222x_SUCCESS)
        {
            TH222x_CTR.TestEEPROMResult  = TH222x_SUCCESS;
        }
        else
        {
            TH222x_CTR.TestEEPROMResult  = TH222x_FAILURE;
        }         
    #endif
}
#endif


