/**
 *******************************************************************************
 *
 * @file        MG32_IWDT_Init.c
 *
 * @brief       The IWDT initial code C file
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2023/05/30
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_IWDT_Init.h"
#include "MG32_SYS.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
#if defined(IRQHandler_Middleware_Level_)       
    #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
            IWDT_HandleTypeDef        mIWDT;
        #pragma clang diagnostic pop
    // ------------------------------------------------------------------------
    #else
        IWDT_HandleTypeDef        mIWDT;
    #endif
    // ------------------------------------------------------------------------
#endif
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       initialized IWDT module.
 * @details  
 * @param[in]   MG32_IWDT_Init:
 * 	@arg\b      Use keil wizard define table index..
 * @return      
 * @note
 * @par         Example
 * @code
                IWDT_Init();
 * @endcode
 *******************************************************************************
 */
void IWDT_Init(void)
{
#if CONF_IWDT_EN==1
    IWDT->KEY.MBIT.KEY = 0xA217;
    
    // Clear IWDT Statuse Register.
    IWDT->STA.W = (IWDT_STA_EW1F_mask_w|IWDT_STA_EW0F_mask_w|IWDT_STA_TF_mask_w);
    // IWDT Module Enable/Disable Configure.
    IWDT->CR0.MBIT.EN = 0;                  // IWDT module disable first, for easily configure IWDT module.
    IWDT->CR0.MBIT.EN |= CONF_IWDT_EN;
    // IWDT Module Wake Up Enable Configure.
    IWDT->CR0.W &= ~(IWDT_CR0_EW1_WPEN_mask_w|IWDT_CR0_EW0_WPEN_mask_w|IWDT_CR0_TF_WPEN_mask_w);
    IWDT->CR0.W |= CONF_IWDT_CR0;
    // IWDT Divider Register Configure.
    IWDT->CLK.W &= ~IWDT_CLK_CK_DIV_mask_w;
    IWDT->CLK.W |= CONF_IWDT_CLK;
    // IWDT Interrupt Enable Colnfigure.
    if((CONF_IWDT_INT&0x0E) != 0)
    {
        SYS->INT.MBIT.IEA = SYS_INT_IEA_enable_b0;
    }
    IWDT->INT.W &= ~(IWDT_INT_EW1_IE_mask_w|IWDT_INT_EW0_IE_mask_w|IWDT_INT_TIE_mask_w);
    IWDT->INT.W |= CONF_IWDT_INT;
    
    #if defined(IRQHandler_Middleware_Level_)
    // IWDT Middleware Define.
    mIWDT.Instance = IWDT;
    mIWDT.Init.Interrupt = CONF_IWDT_INT;
    mIWDT.Init.Prescaler = CONF_IWDT_CK_DIV;
    mIWDT.Init.IWDT_WPEN      = CONF_IWDT_WPEN;
//    MID_IWDT_Init(&mIWDT);
    #endif
    
    IWDT->KEY.MBIT.KEY = 0x217A;
#endif
}


