
/**
 ******************************************************************************
 *
 * @file        MG32_ChipInit.H
 *
 * @brief       By the file select you want to function initial.
 *   
 * @par         Project
 *              MG32
 * @version     V1.17
 * @date        2024/09/13
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */

#ifndef _MG32_ChipInit_H
 
#define _MG32_ChipInit_H

/* Includes ------------------------------------------------------------------*/
#include "RTE_Components.h"     // From Keil "Manage Run-Time Enviroment' setting
//
#ifdef MG32_ConfigerWizard_PW   // "Manage Run-Time Enviroment" enable PW wizard
    #include "MG32_PW_Init.h"   // include "MG32_PW_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_RST  // "Manage Run-Time Enviroment" enable RST wizard
    #include "MG32_RST_Init.h"  // include "MG32_RST_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_GPIO // "Manage Run-Time Enviroment" enable GPIO wizard
    #include MG32_GPIO_FILENAME // include "MG32_GPIO_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_CSC  // "Manage Run-Time Enviroment" enable CSC wizard
    #include "MG32_CSC_Init.h"  // include "MG32_CSC_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_EXIC // "Manage Run-Time Enviroment" enable EXIC wizard
    #include MG32_EXIC_FILENAME // include "MG32_EXIC_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_GPL  // "Manage Run-Time Enviroment" enable GPL wizard
    #include "MG32_GPL_Init.h"  // include "MG32_GPL_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_MEM  // "Manage Run-Time Enviroment" enable MEM wizard
    #include "MG32_MEM_Init.h"  // include "MG32_MEM_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_EMB  // "Manage Run-Time Enviroment" enable EMB wizard
    #include "MG32_EMB_Init.h"  // include "MG32_EMB_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_URT  // "Manage Run-Time Enviroment" enable URT wizard
    #include "MG32_URT_Init.h"  // include "MG32_URT_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_TM   // "Manage Run-Time Enviroment" enable TM wizard
    #include "MG32_TM_Init.h"   // include "MG32_TM_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_ADC  // "Manage Run-Time Enviroment" enable ADC wizard
    #include "MG32_ADC_Init.h"  // include "MG32_ADC_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_DAC  // "Manage Run-Time Enviroment" enable DAC wizard
    #include "MG32_DAC_Init.h"  // include "MG32_DAC_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_CMP  // "Manage Run-Time Enviroment" enable CMP wizard
    #include "MG32_CMP_Init.h"  // include "MG32_CMP_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_APB  // "Manage Run-Time Enviroment" enable APB wizard
    #include "MG32_APB_Init.h"  // include "MG32_APB_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_APX_CCL    // "Manage Run-Time Enviroment" enable APX CCL wizard
    #include "MG32_CCL_Init.h"  // include "MG32_CCL_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_RTC  // "Manage Run-Time Enviroment" enable RTC wizard
    #include "MG32_RTC_Init.h"  // include "MG32_RTC_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_SPI	// "Manage Run-Time Enviroment" enable SPI wizard
    #include "MG32_SPI_Init.h"  // include "MG32_SPI_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_I2C	// "Manage Run-Time Enviroment" enable I2C wizard
    #include "MG32_I2C_Init.h"  // include "MG32_I2C_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_WWDT	// "Manage Run-Time Enviroment" enable WWDT wizard
    #include "MG32_WWDT_Init.h" // include "MG32_WWDT_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_IWDT	// "Manage Run-Time Enviroment" enable WWDT wizard
    #include "MG32_IWDT_Init.h" // include "MG32_IWDT_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_CAN 	// "Manage Run-Time Enviroment" enable CAN wizard
    #include "MG32_CAN_Init.h"  // include "MG32_CAN_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_OPA 	// "Manage Run-Time Enviroment" enable OPA wizard
    #include "MG32_OPA_Init.h"  // include "MG32_OPA_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_LCD 	// "Manage Run-Time Enviroment" enable LCD wizard
    #include "MG32_LCD_Init.h"  // include "MG32_LCD_Init.h" file
#endif

#include "MG32_SYS.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/**
 * @name    Function announce
 * @brief   Chip Initial routine	
 */ 
///@{
void ChipInit(void);
///@}

/* External vairables --------------------------------------------------------*/


#endif
