/**
  ******************************************************************************
 *
 * @file        Sample_MID_CMP_SetupExample.c
 *
 * @brief       Comparator setup example code.
 *
 * @par         Project
 *              MG32
 * @version     V1.11
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_CMP_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static CMP_HandleTypeDef mCMP0, mCMP1;

/* Private function prototypes -----------------------------------------------*/
void COMP_IRQHandler(void);
void Sample_MID_CMP_SetupExample(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
void COMP_IRQHandler(void)
{
//    MID_CMP_IRQHandler(&mCMP0);
    MID_CMP_IRQHandler(&mCMP1);
}


/**
 *******************************************************************************
 * @brief	    Comparator setup example code.
 * @details     1.Initial parameters for CMPAC0/1.
 *    \n        2.Config CMPAC0/1.
 *    \n        3.Start CMPAC0/1.
 * @return      None
 *******************************************************************************
 */
void Sample_MID_CMP_SetupExample(void)
{  
    

    // make sure :
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12M
    //  Select CK_PLLI Divider = CK_HS/2
    //  Select CK_PLL Multiplication factor = CK_PLLIx16
    //  Select CK_PLLO Divider = CK_PLL/4
    //Select CK_MAIN Source = CK_PLLO
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->CMP = Enable
    //Configure Peripheral On Mode Clock->Port A = Enable
    //Configure Peripheral On Mode Clock->Port B = Enable
	
    //==Set GPIO init 
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOA->PA9,PA10
    //GPIO port initial is 0xFFFF
    //PA8 mode is AIO
    //PA8 function GPA8
    
    //==Set GPIO init 
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOB->PB0
    //GPIO port initial is 0xFFFF
    //PB0 mode is AIO
    //PB0 function GPB0
    
    // ------------------------------------------------------------------------
    // 1.Initial parameters of CMPAC0
    // ------------------------------------------------------------------------
    mCMP0.Instance                   = CMPAC0;
    mCMP0.Init.InvertingInput        = CMP_INVERTINGINPUT_IVREF;     // Inverting from Internal VREF0
    mCMP0.Init.NonInvertingInput     = CMP_NONINVERTINGINPUT_IO0;    // Non-Inverting PIN Input
    mCMP0.Init.ComparatorPol         = CMP_POSITIVE_POLARITY;        // CMP Possitive polarity
    mCMP0.Init.OutputPol             = CMP_OUTPUTPOL_NONINVERTED;    // CMP non-invert output
//    mCMP0.Init.Hysteresis            = CMP_HYSTERESIS_LOW;           // Hysteresis window config
    mCMP0.Init.Mode                  = CMP_MODE_HIGHSPEED;           // High speed for CMP
    mCMP0.Init.TriggerMode           = CMP_TRIGGERMODE_IT_RISING;    // Rising edge of CMP_OUT
    mCMP0.Init.OutputSync            = CMP_SYNCHRONIZE_BYPASS;       // CMP_OUT without filter function
    mCMP0.Init.SyncFilterDIV         = CMP_SYNCHRONIZE_DIV1;         // no used when select BYPASS option
    
    mCMP0.IntVref.IntVREF0_Level     = 32;                           // Internal VREF0 selection
    
    // ------------------------------------------------------------------------
    // 2.Config CMPAC0
    // ------------------------------------------------------------------------
    MID_CMP_Init(&mCMP0);

    // ------------------------------------------------------------------------
    // 3.Start CMPAC0
    // ------------------------------------------------------------------------
    MID_CMP_Start(&mCMP0);
 



    // ------------------------------------------------------------------------
    // initial parameters of CMPAC1
    // ------------------------------------------------------------------------
    mCMP1.Instance                   = CMPAC1;
    mCMP1.Init.InvertingInput        = CMP_INVERTINGINPUT_IO1;       // Inverting PIN Input from PIN
    mCMP1.Init.NonInvertingInput     = CMP_NONINVERTINGINPUT_COMMONIO0;// Non-Inverting PIN Input from PB0
    mCMP1.Init.ComparatorPol         = CMP_POSITIVE_POLARITY;        // CMP Possitive polarity
    mCMP1.Init.OutputPol             = CMP_OUTPUTPOL_NONINVERTED;    // CMP non-invert output
//    mCMP1.Init.Hysteresis            = CMP_HYSTERESIS_LOW;           // Hysteresis window config
    mCMP1.Init.Mode                  = CMP_MODE_HIGHSPEED;           // High speed for CMP
    mCMP1.Init.TriggerMode           = CMP_TRIGGERMODE_IT_RISING;    // Rising edge of CMP_OUT
    mCMP1.Init.OutputSync            = CMP_SYNCHRONIZE_BYPASS;       // CMP_OUT without filter function
    mCMP1.Init.SyncFilterDIV         = CMP_SYNCHRONIZE_DIV1;         // no used when select BYPASS option

    // ------------------------------------------------------------------------
    // config CMPAC1
    // ------------------------------------------------------------------------
    MID_CMP_Init(&mCMP1);

    // ------------------------------------------------------------------------
    // start CMPAC1 with interrupt service
    // ------------------------------------------------------------------------
    NVIC_EnableIRQ(COMP_IRQn);
    
    MID_CMP_Start_IT(&mCMP1);

}




