
/**
 ******************************************************************************
 *
 * @file        TH222x_RGB.c
 * @brief       This is TH222x_RGB C file.
 
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/06/22
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
/* Includes ------------------------------------------------------------------*/ 
#include "TH222x_Global.h"
#include "BSP_3_RGB.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define TH222x_RGB_COLOR     4

#define TH222x_RGB_R         0
#define TH222x_RGB_G         1
#define TH222x_RGB_B         2


/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_RGB_UpdateFlag;

static uint8_t   TH222x_RGB_DramaAct;
static uint8_t   TH222x_RGB_DramaActMax;
static uint16_t  TH222x_RGB_DramaTime;
static uint16_t  TH222x_RGB_DramaTimeMax;


static uint8_t TH222x_RGBDefault_TABLE[TH222x_RGB_COLOR][3] = {
                                                                 { 20 ,   0 ,   0},    // 1st Color : [R : G : B ] 
                                                                 {  0 ,  20 ,   0},    // 2nd Color : [R : G : B ] 
                                                                 {  0 ,   0 ,  80},    // 3rd Color : [R : G : B ]  
                                                                 { 20 ,  20 ,  80},    // 4th Color : [R : G : B ] 
                                                              };

/* Private function prototypes -----------------------------------------------*/                                                                   
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/
 
 
/**
 *******************************************************************************
 * @brief	   
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_RGBParameter_DeInit(void)
{
    TH222x_RGB_UpdateFlag = 0;
    
    TH222x_RGB_DramaTime    = 0;
    TH222x_RGB_DramaTimeMax = 400;
    TH222x_RGB_DramaAct     = 0;
    TH222x_RGB_DramaActMax  = (TH222x_RGB_COLOR-1);
    
    BSP_RGB_RefreshData(0,0,0);
}    
/**
 *******************************************************************************
 * @brief	   
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_RGB(void)
{
    if(TH222x_RGB_UpdateFlag==0)
    {
        return;
    }
    TH222x_RGB_UpdateFlag = 0;
    
    
    
    if( TH222x_RGB_DramaTime < TH222x_RGB_DramaTimeMax)
    {
        TH222x_RGB_DramaTime = TH222x_RGB_DramaTime + 1;
        
        return;
    }
    
    TH222x_RGB_DramaTime = 0;
    
    
    BSP_RGB_RefreshData( TH222x_RGBDefault_TABLE[ TH222x_RGB_DramaAct][TH222x_RGB_R],
                         TH222x_RGBDefault_TABLE[ TH222x_RGB_DramaAct][TH222x_RGB_G],
                         TH222x_RGBDefault_TABLE[ TH222x_RGB_DramaAct][TH222x_RGB_B]);
    
    TH222x_RGB_DramaAct = TH222x_RGB_DramaAct + 1;
    
    if( TH222x_RGB_DramaAct > TH222x_RGB_DramaActMax)
    {
        TH222x_RGB_DramaAct = 0;
    }
    
    
} 







