
/**
 ******************************************************************************
 *
 * @file        MG32__IRQHandler.H
 *
 * @brief       This file contains all the functions prototypes for the IRQHandler
 *              firmware library.
 *
 * @par         Project
 *              MG32
 * @version     V1.06
 * @date        2025/07/11
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer 
 *      The Demo software is provided "AS IS"  without any warranty, either 
 *      expressed or implied, including, but not limited to, the implied warranties 
 *      of merchantability and fitness for a particular purpose.  The author will 
 *      not be liable for any special, incidental, consequential or indirect 
 *      damages due to loss of data or any other reason. 
 *      These statements agree with the world wide and local dictated laws about 
 *      authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */ 

#ifndef __MG32_IRQHANDLER_H
#define __MG32_IRQHANDLER_H
#define __MG32_IRQHANDLER_H_VER 100                     /*!< File Version */


#ifdef __cplusplus
 extern "C" {
#endif

/* Wizard menu ---------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void NMI_Handler(void);
void SVC_Handler(void);
void PendSV_Handler(void);
void SysTick_Handler(void);
#if defined(ModuleExist_WWDT)
void WWDT_IRQHandler(void);
#endif
#if defined(ModuleExist_SYS)
void SYS_IRQHandler(void);
#endif
#if defined(ModuleExist_EXIC)
void EXINT0_IRQHandler(void);
void EXINT1_IRQHandler(void);
void EXINT2_IRQHandler(void);
void EXINT3_IRQHandler(void);
#endif
#if defined(ModuleExist_CMP)
void COMP_IRQHandler(void);
#endif
#if defined(ModuleExist_DMA)
void DMA_IRQHandler(void);
#endif
#if defined(ModuleExist_ADC0)
void ADC_IRQHandler(void);
#endif
#if defined(ModuleExist_DAC)
void DAC_IRQHandler(void);
#endif
#if defined(ModuleExist_TM00) || defined(ModuleExist_TM01)
void TM0x_IRQHandler(void);
#endif
#if defined(ModuleExist_TM10)
void TM10_IRQHandler(void);
#endif
#if defined(ModuleExist_TM16)
void TM1x_IRQHandler(void);
#endif
#if defined(ModuleExist_TM20)
void TM20_IRQHandler(void);
#endif
#if defined(ModuleExist_TM26)
void TM2x_IRQHandler(void);
#endif
#if defined(ModuleExist_TM36)
void TM3x_IRQHandler(void);
#endif
#if defined(ModuleExist_URT0)
void URT0_IRQHandler(void);
#endif
#if defined(ModuleExist_URT1) || defined(ModuleExist_URT2) || defined(ModuleExist_URT3)
void URT123_IRQHandler(void);
#endif
#if defined(ModuleExist_URT4) || defined(ModuleExist_URT5) || defined(ModuleExist_URT6) || defined(ModuleExist_URT7)
void URT4x_IRQHandler(void);
#endif
#if defined(ModuleExist_SPI0)
void SPI0_IRQHandler(void);
#endif
#if defined(ModuleExist_I2C0)
void I2C0_IRQHandler(void);
#endif
#if defined(ModuleExist_I2C1)
void I2Cx_IRQHandler(void);
#endif
#if defined(ModuleExist_USB)
void USB_IRQHandler(void);
#endif
#if defined(ModuleExist_APX)
void APX_IRQHandler(void);
#endif
#if defined(ModuleExist_LCD)
void LCD_IRQHandler(void);
#endif
#if defined(ModuleExist_CAN0)
void CAN0_IRQHandler(void);
#endif


/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
extern void HardFault_IRQ(void);
#if defined(ModuleExist_WWDT)
extern void WWDT_IRQ(void);
#endif
#if defined(ModuleExist_IWDT)
extern void IWDT_IRQ(void);
#endif
#if defined(ModuleExist_PW)
extern void PW_IRQ(void);
#endif
#if defined(ModuleExist_RTC)
extern void RTC_IRQ(void);
#endif
#if defined(ModuleExist_CSC)
extern void CSC_IRQ(void);
#endif
#if defined(ModuleExist_APB)
extern void APB_IRQ(void);
#endif
#if defined(ModuleExist_MEM)
extern void MEM_IRQ(void);
#endif
#if defined(ModuleExist_EMB)
extern void EMB_IRQ(void);
#endif
#if defined(ModuleExist_EXIC)
extern void EXINT0_IRQ(void);
extern void EXINT1_IRQ(void);
extern void EXINT2_IRQ(void);
extern void EXINT3_IRQ(void);
extern void EXINT4_IRQ(void);
#endif
#if defined(ModuleExist_CMP)
extern void CMP_IRQ(void);
#endif
#if defined(ModuleExist_DMA)
extern void DMA_IRQ(void);
#endif
#if defined(ModuleExist_ADC0)
extern void ADC_IRQ(void);
#endif
#if defined(ModuleExist_DAC)
extern void DAC_IRQ(void);
#endif
#if defined(ModuleExist_TM00)
extern void TM00_IRQ(void);
#endif
#if defined(ModuleExist_TM01)
extern void TM01_IRQ(void);
#endif
#if defined(ModuleExist_TM10)
extern void TM10_IRQ(void);
#endif
#if defined(ModuleExist_TM16)
extern void TM16_IRQ(void);
#endif
#if defined(ModuleExist_TM20)
extern void TM20_IRQ(void);
#endif
#if defined(ModuleExist_TM26)
extern void TM26_IRQ(void);
#endif
#if defined(ModuleExist_TM36)
extern void TM36_IRQ(void);
#endif
#if defined(ModuleExist_URT0)
extern void URT0_IRQ(void);
#endif
#if defined(ModuleExist_URT1)
extern void URT1_IRQ(void);
#endif
#if defined(ModuleExist_URT2)
extern void URT2_IRQ(void);
#endif
#if defined(ModuleExist_URT3)
extern void URT3_IRQ(void);
#endif
#if defined(ModuleExist_URT4)
extern void URT4_IRQ(void);
#endif
#if defined(ModuleExist_URT5)
extern void URT5_IRQ(void);
#endif
#if defined(ModuleExist_URT6)
extern void URT6_IRQ(void);
#endif
#if defined(ModuleExist_URT7)
extern void URT7_IRQ(void);
#endif
#if defined(ModuleExist_SPI0)
extern void SPI0_IRQ(void);
#endif
#if defined(ModuleExist_I2C0)
extern void I2C0_IRQ(void);
#endif
#if defined(ModuleExist_I2C1)
extern void I2C1_IRQ(void);
#endif
#if defined(ModuleExist_RTC)
extern void RTC_IRQ(void);
#endif
#if defined(ModuleExist_WWDT)
extern void WWDT_IRQ(void);
#endif
#if defined(ModuleExist_APX)
extern void APX_IRQ(void);
#endif
#if defined(ModuleExist_USB)
extern void USB_IRQ(void);
#endif
#if defined(ModuleExist_LCD)
extern void LCD_IRQ(void);
#endif
#if defined(ModuleExist_CAN0)
extern void CAN0_IRQ(void);
#endif
#ifdef __cplusplus
}
#endif

#endif

