/**
 *******************************************************************************
 *
 * @file        MG32_WWDT_Init.c
 *
 * @brief       The WWDT initial code C file
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2023/05/30
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_WWDT_Init.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

#if defined(IRQHandler_Middleware_Level_)       
    #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
            WWDT_HandleTypeDef        mWWDT;
        #pragma clang diagnostic pop
    // ------------------------------------------------------------------------
    #else
        WWDT_HandleTypeDef        mWWDT;
    #endif
    // ------------------------------------------------------------------------
#endif
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       initialized WWDT module.
 * @details  
 * @param[in]   MG32_WWDT_Init:
 * 	@arg\b      Use keil wizard define table index..
 * @return      
 * @note
 * @par         Example
 * @code
                WWDT_Init();
 * @endcode
 *******************************************************************************
 */
void WWDT_Init(void)
{
#if CONF_WWDT_EN==1
    WWDT->KEY.MBIT.KEY = 0xA217;
    
    // Clear WWDT Statuse Register.
    WWDT->STA.W = (WWDT_STA_WRNF_mask_w|WWDT_STA_WINF_mask_w|WWDT_STA_TF_mask_w);
    
    // WWDT Module Wake Up Enable Configure.
    WWDT->CR0.W &= ~(WWDT_CR0_RSTW_EN_mask_w|WWDT_CR0_RSTF_EN_mask_w|WWDT_CR0_EN_mask_w);
    WWDT->CR0.W |= CONF_WWDT_CR0;
    // WWDT Divider Register Configure.
    WWDT->CLK.W &= ~(WWDT_CLK_CK_PDIV_mask_w| WWDT_CLK_CK_DIV_mask_w| WWDT_CLK_CK_SEL_mask_w);
    WWDT->CLK.W |= CONF_WWDT_CLK;

    WWDT->INT.W &= ~(WWDT_INT_WRN_IE_mask_w|WWDT_INT_WIN_IE_mask_w|WWDT_INT_TIE_mask_w);
    WWDT->INT.W |= CONF_WWDT_INT;
    
    // WWDT Reload Value Set.
    WWDT->RLR.W = CONF_WWDT_RLR;
    
    // WWDT Window Event Value Set.
    WWDT->WIN.W = CONF_WWDT_WIN;
    
    // WWDT Warning Event Value Set.
    WWDT->WRN.W = CONF_WWDT_WRN;
    
    // Force Reload Counter Value.
    WWDT->KEY.W = 0x00002014;
    
    // WWDT Module Enable/Disable Configure.
    WWDT->CR0.MBIT.EN = 0;                  // WWDT module disable first, for easily configure WWDT module.
    WWDT->CR0.MBIT.EN |= CONF_WWDT_EN;
    
    #if defined(IRQHandler_Middleware_Level_)
    // WWDT Middleware Define.
    mWWDT.Instance = WWDT;
    mWWDT.Init.WWDT_RLR = CONF_WWDT_RLR;
    mWWDT.Init.WWDT_WIN = CONF_WWDT_WIN;
    mWWDT.Init.WWDT_WRN = CONF_WWDT_WRN;
    mWWDT.Init.WWDT_INT_SEL = CONF_WWDT_INT;
//    MID_WWDT_Init(&mWWDT);
    #endif
    
    WWDT->KEY.MBIT.KEY = 0x217A;
#endif
}


