/**
 ******************************************************************************
 *
 * @file        MG32_IEC60730_Interrupt.c
 *
 * @brief       This is the C code format driver head file.
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2018/12/17
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */ 

 
#include "MG32_IEC60730_Common.h"


#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
    #pragma clang diagnostic push
    #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
        uint8_t  IEC60730_IntFreqCnt;
        uint8_t  IEC60730_IntFreqTRG;
        uint8_t  IEC60730_IntFreqResult;
    #pragma clang diagnostic pop
#else
    uint8_t  IEC60730_IntFreqCnt;
    uint8_t  IEC60730_IntFreqTRG;
    uint8_t  IEC60730_IntFreqResult;
#endif


void MG32_TestInterruptCount_Set(void);
void MG32_TestInterruptResult_Get(void);
void MG32_TestInterrupt_Init(void);
void TM0x_IRQHandler(void);
void TM10_IRQHandler(void);

/**
 *******************************************************************************
 * @brief       
 * @details  
 * @param[in]    
 * @return      
 * @exception   No   
 * @note        The function in TM00_IRQ
 *******************************************************************************
 */
void MG32_TestInterruptCount_Set(void)
{
    if(IEC60730_IntFreqTRG==Int_Freq_Get)
    {
        IEC60730_IntFreqCnt = IEC60730_IntFreqCnt + 1;
    }
    
}
/**
 *******************************************************************************
 * @brief       
 * @details  
 * @param[in]    
 * @return      
 * @exception     
 * @note        The function in TM10_IRQ
 *******************************************************************************
 */
void MG32_TestInterruptResult_Get(void)
{
    if(IEC60730_IntFreqTRG==Int_Freq_Start)
    {
        IEC60730_IntFreqCnt = 0;                                                       
        IEC60730_IntFreqTRG = Int_Freq_Get; 
    }
    else if(IEC60730_IntFreqTRG==Int_Freq_Get)
    {
        if(IEC60730_IntFreqCnt<Int_freq_upper && IEC60730_IntFreqCnt >Int_freq_lower)
        {
            IEC60730_IntFreqResult = IEC60370_IntFreq_Success;   
        }
        IEC60730_IntFreqTRG = Int_Freq_End;
        
        TM_Timer_Cmd(TM00, DISABLE);
        TM_Timer_Cmd(TM10, DISABLE);
        
        TM_IT_Config(TM00, TMx_TIE_IE, DISABLE);
        TM_IT_Config(TM10, TMx_TIE_IE, DISABLE);
        
        UnProtectModuleReg(CSCprotect);
        CSC_PeriphOnModeClock_Config(CSC_ON_TM00, DISABLE);
        CSC_PeriphOnModeClock_Config(CSC_ON_TM10, DISABLE);
        ProtectModuleReg(CSCprotect);
        
        NVIC_DisableIRQ(TM0x_IRQn); 
        NVIC_DisableIRQ(TM10_IRQn);
    }
    
}

/**
 *******************************************************************************
 * @brief       
 * @details  
 * @param[in]    
 * @return      
 * @exception   No   
 * @note        
 *******************************************************************************
 */
void MG32_TestInterrupt_Init(void)
{
    TM_TimeBaseInitTypeDef TM_TimeBase_InitStruct;
    
    //
    IEC60730_IntFreqTRG    = Int_Freq_Start;                   // Interrupt test start.
    IEC60730_IntFreqResult = IEC60370_IntFreq_Fail;            // Inital Interrupt test result (Inital result is fail.

    UnProtectModuleReg(CSCprotect);
    CSC_PeriphOnModeClock_Config(CSC_ON_TM00, ENABLE);
    CSC_PeriphOnModeClock_Config(CSC_ON_TM10, ENABLE);
    ProtectModuleReg(CSCprotect);
    
    //
    TM_TimeBaseStruct_Init(&TM_TimeBase_InitStruct);
    
    TM_TimeBase_InitStruct.TM_Period    = 20 - 1; 
    TM_TimeBase_InitStruct.TM_Prescaler = 20 - 1;
    TM_TimeBase_InitStruct.TM_CounterMode = Cascade;
    
    TM_TimeBase_Init(TM00, &TM_TimeBase_InitStruct);
    
    TM_TimeBase_InitStruct.TM_Period    = 400 - 1; 
    TM_TimeBase_InitStruct.TM_Prescaler = 100 - 1;
    
    TM_TimeBase_Init(TM10, &TM_TimeBase_InitStruct);
    
    
    TM_ClearFlag(TM00, TMx_TOF);
    TM_ClearFlag(TM10, TMx_TOF);
    
    TM_IT_Config(TM00, TMx_TIE_IE, ENABLE);
    TM_IT_Config(TM10, TMx_TIE_IE, ENABLE);
    
    TM_ITEA_Cmd(TM00,ENABLE);
    TM_ITEA_Cmd(TM10,ENABLE);
    
    NVIC_EnableIRQ(TM0x_IRQn); 
    NVIC_EnableIRQ(TM10_IRQn);
    
    TM_Timer_Cmd(TM00, ENABLE);
    TM_Timer_Cmd(TM10, ENABLE);
}

/**
 *******************************************************************************
 * @brief       
 * @details  
 * @param[in]    
 * @return      
 * @exception   No   
 * @note        
 *******************************************************************************
 */
void TM0x_IRQHandler(void)
{
    MG32_TestInterruptCount_Set();   
    TM_ClearFlag(TM00, TMx_TOF);
}

/**
 *******************************************************************************
 * @brief       
 * @details  
 * @param[in]    
 * @return      
 * @exception   No   
 * @note        
 *******************************************************************************
 */
void TM10_IRQHandler(void)
{
    MG32_TestInterruptResult_Get();   
    TM_ClearFlag(TM10, TMx_TOF);
}









