/**
 ******************************************************************************
 *
 * @file        MG32_ADC.h
 *
 * @brief       MG32 ADC Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:39 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_ADC_H
#define _MG32_ADC_H
#define _MG32_ADC_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_ADC_H_VER)
    #error "_MG32_ADC_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      ADC_Struct
 *              ADC  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  SOCF          :1;     //[0] ADC conversion status
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  ESMPF         :1;     //[2] ADC sampling end flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  E1CNVF        :1;     //[3] ADC one-time conversion end flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[4] 
            __IO uint8_t  ESCNVF        :1;     //[5] ADC channel scan conversion end flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  OVRF          :1;     //[7] ADC conversion overrun event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  WDLF          :1;     //[8] ADC voltage window detect outside low event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  WDIF          :1;     //[9] ADC voltage window detect inside event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  WDHF          :1;     //[10] ADC voltage window detect outside high event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[11] 
            __I  uint8_t                :1;     //[12] 
            __IO uint8_t  SUMOF         :1;     //[13] ADC data sum-0,1,2 accumulation overflow or underflow flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  SUMCF         :1;     //[14] ADC data sum-0,1,2  accumulation complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  SUMOVRF       :1;     //[15] ADC data sum-0,1,2  register overrun flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :8;     //[23..16] 
            __IO uint8_t  POF           :1;     //[24] ADC PGA offset calibration status bit.
            __IO uint8_t  PHS           :1;     //[25] 
            __I  uint8_t  CONVF         :1;     //[26] 
            __I  uint8_t                :1;     //[27] 
            __I  uint8_t  CNV_CH        :4;     //[31..28] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  ADC status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] ADC interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  ESMP_IE       :1;     //[2] ADC sampling end interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  E1CNV_IE      :1;     //[3] ADC one-time conversion end interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[4] 
            __IO uint8_t  ESCNV_IE      :1;     //[5] ADC channel scan conversion end interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  OVR_IE        :1;     //[7] ADC conversion overrun event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WDL_IE        :1;     //[8] ADC voltage window detect outside low event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WDI_IE        :1;     //[9] ADC voltage window detect inside event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WDH_IE        :1;     //[10] ADC voltage window detect outside high event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[12..11] 
            __IO uint8_t  SUMO_IE       :1;     //[13] ADC data sum-0,1,2  accumulation overflow or underflow interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SUMC_IE       :1;     //[14] ADC data sum-0,1,2  accumulation complete interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SUMOVR_IE     :1;     //[15] ADC data sum-0,1,2  overrun event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  ADC interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  CK_DIV        :2;     //[5..4] ADC internal clock CK_ADC_INT input divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV16 : divided by 16
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  CK_SEL2       :2;     //[9..8] ADC internal sampling clock CK_ADC_INT source select.
                                        //0x0 = CK_ADC
                                        //0x1 = CK_PLL
                                        //0x2 = TM00_TRGO (only accept TM00_TRGO_UEV, TM00_TRGO_UEV2)
                                        //0x3 = TM01_TRGO (only accept TM01_TRGO_UEV, TM01_TRGO_UEV2)
            __IO uint8_t  CK_DIV2       :2;     //[11..10] ADC input clock CK_PLL divider.
                                        //0x0 = DIV2 : divided by 2
                                        //0x1 = DIV4 : divided by 4
                                        //0x2 = DIV5 : divided by 5
                                        //0x3 = DIV6 : divided by 6
            __IO uint8_t  CK_DLY        :2;     //[13..12] ADC sampling clock phase delay select.
                                        //0x0 = No : No delay
                                        //0x1 = DLY : One step delay 
                                        //0x2 = INV : Clock invert
                                        //0x3 = IDLY : Clock invert with one step delay
            __I  uint8_t                :2;     //[15..14] 
            __I  uint8_t                :8;     //[23..16] 
            __IO uint8_t  CK_SDIV       :2;     //[25..24] ADC power-on start up counter clock divider
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV4 : divided by 4
                                        //0x2 = DIV16 : divided by 16
                                        //0x3 = DIV32 : divided by 32
            __I  uint8_t                :2;     //[27..26] 
            __IO uint8_t  SCNT          :4;     //[31..28] ADC power-on start up counter
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  ADC clock source register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t WIND_LT       :12;    //[11..0] ADC Voltage window detect lower threshold
            __I  uint8_t                :4;     //[15..12] 
            __IO uint16_t WIND_HT       :12;    //[27..16] ADC voltage window detect higher threshold
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }WINDTH;                            /*!< WINDTH     ~ Offset[0x0C]  ADC window detect threshold register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] ADC power-on enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  AUTOFF_EN     :1;     //[1] Auto-off mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WAIT_EN       :1;     //[2] Wait conversion mode enable for low CPU frequency .
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[3] 
            __I  uint8_t                :1;     //[4] 
            __IO uint8_t  DTEST_EN      :1;     //[5] 
            __IO uint8_t  RES_SEL       :2;     //[7..6] ADC data resolution select. register.
                                        //0x0 = 12-bit
                                        //0x1 = 10-bit
                                        //0x2 = 8-bit
                                        //0x3 = Reserved
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __IO uint8_t  CH_CHG        :1;     //[11] ADC scan/loop mode channel MUX change source control.
                                        //0 = CONV : change channel at ADC conversion end
                                        //1 = SMP : change channel at ADC sampling end
            __I  uint8_t                :2;     //[13..12] 
            __IO uint8_t  LIM_MDS       :2;     //[15..14] ADC output code spike limit function select
                                        //0x0 = No operation
                                        //0x1 = Skip
                                        //0x2 = Clamp
                                        //0x3 = Reserved
            __IO uint8_t  SMP_SEL       :8;     //[23..16] ADC sampling time select from 0T clock to 255T clocks. Value 0 indicates 0T clock.
            __I  uint8_t                :5;     //[28..24] 
            __IO uint8_t  DMA_MDS       :1;     //[29] E1CNVF flag asserted mode select for direct memory access
                                        //0 = Disable
                                        //1 = Keep
            __IO uint8_t  DMA_DSIZE     :1;     //[30] ADC data size for direct memory access
                                        //0 = 32Bit
                                        //1 = 16Bit
            __IO uint8_t  DMA_EN        :1;     //[31] Direct memory access enable
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  ADC control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  WIND_EN       :1;     //[0] ADC Voltage window detect enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WIND_MDS      :1;     //[1] ADC Voltage window detect and output code spike limit function channel mode select.
                                        //0 = Single (Single channel)
                                        //1 = All (All scan channels)
            __I  uint8_t                :1;     //[2] 
            __IO uint8_t  ALIGN_SEL     :1;     //[3] ADC data alignment select.
                                        //0 = Right (Right alignment)
                                        //1 = Left (Left alignment)
            __IO uint8_t  OUT_SEL       :3;     //[6..4] ADC_OUT output signal select.
                                        //0x0 = WDL (window detect state for outside low)
                                        //0x1 = WDI (window detect state for inside)
                                        //0x2 = WDH (window detect state for outside high)
                                        //0x3 = RDY (ADC_RDY internal data ready signal) 
                                        //0x4 = INTS0 (Internal signal 0)
                                        //0x5 = INTS1 (Internal signal 1)
                                        //0x6 = INTS2 (Internal signal 2)
                                        //0x7 = INTS3 (Internal signal 3)
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  OVR_MDS       :1;     //[8] ADC data buffer overrun mode select.
                                        //0 = Overwritten (Overwritten by new data)
                                        //1 = Keep (Preserved old date)
            __IO uint8_t  SOVR_MDS      :1;     //[9] ADC data sum overrun mode select.
                                        //0 = Overwritten (Overwritten by new data)
                                        //1 = Keep (Preserved old date)
            __IO uint8_t  SUM_MDS       :1;     //[10] ADC data accumulation sum channel mode select
                                        //0 = Single (Single channel)
                                        //1 = All (All selected scan channels)
            __I  uint8_t                :5;     //[15..11] 
            __IO uint8_t  SUM_NUM       :7;     //[22..16] ADC data sum accumulation data number
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  DOS_VAL       :5;     //[28..24] ADC adjusted 2s complement value of digital offset adjuster.
            __I  uint8_t                :3;     //[31..29] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  ADC control register 1 */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x18]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CH_MSK0       :1;     //[0] ADC channel-0 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK1       :1;     //[1] ADC channel-1 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK2       :1;     //[2] ADC channel-2 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK3       :1;     //[3] ADC channel-3 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK4       :1;     //[4] ADC channel-4 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK5       :1;     //[5] ADC channel-5 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK6       :1;     //[6] ADC channel-6 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK7       :1;     //[7] ADC channel-7 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK8       :1;     //[8] ADC channel-8 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK9       :1;     //[9] ADC channel-9 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK10      :1;     //[10] ADC channel-10 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK11      :1;     //[11] ADC channel-11 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK12      :1;     //[12] ADC channel-12 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK13      :1;     //[13] ADC channel-13 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK14      :1;     //[14] ADC channel-14 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH_MSK15      :1;     //[15] ADC channel-15 selection mask for sequence channel scan
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SUM0_MUX      :4;     //[19..16] Analog input channel selection for ADC data sum-0 function.
            __IO uint8_t  SUM1_MUX      :4;     //[23..20] ADC input channel selection for ADC data sum-1 function.
            __IO uint8_t  SUM2_MUX      :4;     //[27..24] ADC input channel selection for ADC data sum-2 function.
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }MSK;                               /*!< MSK        ~ Offset[0x1C]  ADC channel mask register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  START         :1;     //[0] ADC start conversion command. (set by software and clear by hardware)
            __IO uint8_t  HOLD          :1;     //[1] ADC hold conversion command.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[3..2] 
            __I  uint8_t                :2;     //[5..4] 
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  CH_MUX        :4;     //[11..8] ADC input channel Mux selection
            __IO uint8_t  CH_SEL        :1;     //[12] ADC input channel Mux external or internal channel selection
                                        //0 = EXT : external channels
                                        //1 = INT : internal channels
            __I  uint8_t                :3;     //[15..13] 
            __IO uint8_t  START_SEL     :3;     //[18..16] ADC start control source select.
                                        //0x0 = SW : ADC_START register setting
                                        //0x1 = TM00 : TM00_TRGO
                                        //0x2 = PIN : ADC_TRG : ADC external trigger pin
                                        //0x3 = CMP0 : CMP0_OUT
                                        //0x4 = CMP1 : CMP1_OUT
                                        //0x5 = TM01 : TM01_TRGO
                                        //0x6 = TM20 : TM20_TRGO
                                        //0x7 = TM36 : TM36_TRGO
            __IO uint8_t  TRG_CONT      :1;     //[19] ADC start trigger continuous control enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TRG_SEL       :2;     //[21..20] ADC start trigger selection
                                        //0x0 = Disable
                                        //0x1 = Rising edge
                                        //0x2 = Falling edge
                                        //0x3 = Dual-edge
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  CONV_MDS      :2;     //[25..24] ADC conversion mode select.
                                        //0x0 = One :One shot (1-time) conversion
                                        //0x1 = Scan :Single sequence channel-scan conversion
                                        //0x2 = Loop :Continuous loop channel-scan conversion
                                        //0x3 = Reserved
            __I  uint8_t                :1;     //[26] 
            __I  uint8_t                :5;     //[31..27] 
        }MBIT;
    }START;                             /*!< START      ~ Offset[0x20]  ADC start conversion register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  IVR_EN        :1;     //[1] ADC internal reference source IVR24 power on enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  PGA_EN        :1;     //[2] ADC input buffer and PGA enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TS_EN         :1;     //[3] ADC temperature sensor enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IVREF_SEL     :1;     //[4] ADC internal reference top voltage select
                                        //0x0 = VREF : external reference pin VREF+ (ADC_VREF)
                                        //0x1 = IVR24 : internal reference voltage 2.4 volt
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  VBGOUT_EN     :1;     //[6] 
            __IO uint8_t  PGAOUT_EN     :1;     //[7] 
            __IO uint8_t  BIAS          :2;     //[9..8] 
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  BUF_BIAS      :1;     //[12] ADC input buffer bias current control.
            __I  uint8_t                :1;     //[13] 
            __IO uint8_t  CONV_TIME     :1;     //[14] ADC minimum conversion time select.
                                        //0 = 24ADCK : 24 ADC sampling clock
                                        //1 = 30ADCK : 30 ADC sampling clock
            __IO uint8_t  TS_AUTO       :1;     //[15] ADC internal reference IVR24 auto select
                                        //0 = Auto
                                        //1 = Normal
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }ANA;                               /*!< ANA        ~ Offset[0x24]  ADC analog control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :1;     //[2] 
            __IO uint8_t  CAL_POFFT     :1;     //[3] ADC PGA offset calibration function enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[7..4] 
            __I  uint8_t                :6;     //[13..8] 
            __I  uint8_t                :2;     //[15..14] 
            __I  uint8_t                :6;     //[21..16] 
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :6;     //[29..24] 
            __I  uint8_t                :2;     //[31..30] 
        }MBIT;
    }CAL;                               /*!< CAL        ~ Offset[0x28]  ADC calibration control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  GAIN_PGA      :6;     //[5..0] ADC input PGA gain adjust bits
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :2;     //[9..8] 
            __I  uint8_t                :6;     //[15..10] 
            __IO uint8_t  OFFT_PGA      :6;     //[21..16] ADC input PGA offset adjust bits.
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  OFFT_ADC      :5;     //[28..24] ADC offset adjust bits
            __I  uint8_t                :3;     //[31..29] 
        }MBIT;
    }GAIN;                              /*!< GAIN       ~ Offset[0x2C]  ADC gain control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t SUM0_DAT      :16;    //[15..0] ADC data accumulator sum-0 result.
            __I  uint8_t                :4;     //[19..16] 
            __IO uint8_t  SUM0_UF       :1;     //[20] ADC data sum-0 accumulation underflow indication status bit
            __IO uint8_t  SUM0_OF       :1;     //[21] ADC data sum-0 accumulation overflow indication status bit
            __IO uint8_t  SUM0_CF       :1;     //[22] ADC data sum-0 accumulation complete indication status bit
            __IO uint8_t  SUM0_OVRF     :1;     //[23] ADC data sum register-0 overwrite/overrun indication status bit
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }SUM0;                              /*!< SUM0       ~ Offset[0x30]  ADC accumulator sum result register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t SUM1_DAT      :16;    //[15..0] ADC data accumulator sum-1 result
            __I  uint8_t                :4;     //[19..16] 
            __IO uint8_t  SUM1_UF       :1;     //[20] ADC data sum-1 accumulation underflow indication status bit
            __IO uint8_t  SUM1_OF       :1;     //[21] ADC data sum-1 accumulation overflow indication status bit
            __IO uint8_t  SUM1_CF       :1;     //[22] ADC data sum-1 accumulation complete indication status bit
            __IO uint8_t  SUM1_OVRF     :1;     //[23] ADC data sum register-1 overwrite/overrun indication status bit
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }SUM1;                              /*!< SUM1       ~ Offset[0x34]  ADC accumulator sum result register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t SUM2_DAT      :16;    //[15..0] ADC data accumulator sum-2 result
            __I  uint8_t                :4;     //[19..16] 
            __IO uint8_t  SUM2_UF       :1;     //[20] ADC data sum-2 accumulation underflow indication status bit
            __IO uint8_t  SUM2_OF       :1;     //[21] ADC data sum-2 accumulation overflow indication status bit
            __IO uint8_t  SUM2_CF       :1;     //[22] ADC data sum-2 accumulation complete indication status bit
            __IO uint8_t  SUM2_OVRF     :1;     //[23] ADC data sum register-1 overwrite/overrun indication status bit
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }SUM2;                              /*!< SUM2       ~ Offset[0x38]  ADC accumulator sum result register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t TCAL0         :12;    //[11..0] Temperature Sensor calibration ADC value 0.
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t TCAL1         :12;    //[27..16] Temperature Sensor calibration ADC value 1.
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }TCAL;                              /*!< TCAL       ~ Offset[0x3C]  ADC Temperature Sensor calibration register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t DAT0          :16;    //[15..0] ADC conversion data-0
            __IO uint8_t  DAT0_WDLF     :1;     //[16] ADC voltage window detect outside low event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  DAT0_WDIF     :1;     //[17] ADC voltage window detect inside event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  DAT0_WDHF     :1;     //[18] ADC voltage window detect outside high event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :3;     //[21..19] 
            __IO uint8_t  DAT0_CF       :1;     //[22] ADC conversion data-0 complete in 1-time and data ready status bit
            __IO uint8_t  DAT0_OVRF     :1;     //[23] ADC conversion data register-0 overwrite/overrun indication status bit
            __I  uint8_t                :4;     //[27..24] 
            __I  uint8_t  DAT0_CH       :4;     //[31..28] ADC data conversion channel number
        }MBIT;
    }DAT0;                              /*!< DAT0       ~ Offset[0x40]  ADC conversion data register 0 */

} ADC_Struct;

/**
 ******************************************************************************
 *
 * @name        ADC  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define ADC0_Base                       ((uint32_t)0x5B000000)              /*!< Analog-to-Digital Converter Control Module-0 */
#define ADC0                            ((ADC_Struct*) ADC0_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        ADC  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        ADC_STA  [register's definitions]
 *              Offset[0x00]  ADC status register
 ******************************************************************************
 */
///@{
#define ADC_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_STA */
#define ADC_STA_CNV_CH_mask_w                       ((uint32_t)0xF0000000)  /*!< Bit Mask of 32bit */
#define ADC_STA_CNV_CH_mask_h1                      ((uint16_t)0xF000)      /*!< Bit Mask of 16bit */
#define ADC_STA_CNV_CH_mask_b3                      ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define ADC_STA_CNV_CH_shift_w                      (28)                    /*!< Bit Shift of 32bit */
#define ADC_STA_CNV_CH_shift_h1                     (12)                    /*!< Bit Shift of 16bit */
#define ADC_STA_CNV_CH_shift_b3                     (4)                     /*!< Bit Shift of 8bit */

#define ADC_STA_CONVF_mask_w                        ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define ADC_STA_CONVF_mask_h1                       ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define ADC_STA_CONVF_mask_b3                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_STA_CONVF_shift_w                       (26)                    /*!< Bit Shift of 32bit */
#define ADC_STA_CONVF_shift_h1                      (10)                    /*!< Bit Shift of 16bit */
#define ADC_STA_CONVF_shift_b3                      (2)                     /*!< Bit Shift of 8bit */

#define ADC_STA_PHS_mask_w                          ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define ADC_STA_PHS_mask_h1                         ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define ADC_STA_PHS_mask_b3                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_STA_PHS_shift_w                         (25)                    /*!< Bit Shift of 32bit */
#define ADC_STA_PHS_shift_h1                        (9)                     /*!< Bit Shift of 16bit */
#define ADC_STA_PHS_shift_b3                        (1)                     /*!< Bit Shift of 8bit */

#define ADC_STA_POF_mask_w                          ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define ADC_STA_POF_mask_h1                         ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define ADC_STA_POF_mask_b3                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_STA_POF_shift_w                         (24)                    /*!< Bit Shift of 32bit */
#define ADC_STA_POF_shift_h1                        (8)                     /*!< Bit Shift of 16bit */
#define ADC_STA_POF_shift_b3                        (0)                     /*!< Bit Shift of 8bit */

#define ADC_STA_SUMOVRF_mask_w                      ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define ADC_STA_SUMOVRF_mask_h0                     ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define ADC_STA_SUMOVRF_mask_b1                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_STA_SUMOVRF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_STA_SUMOVRF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_STA_SUMOVRF_normal_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_STA_SUMOVRF_happened_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_STA_SUMOVRF_happened_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_STA_SUMOVRF_happened_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_STA_SUMCF_mask_w                        ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define ADC_STA_SUMCF_mask_h0                       ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define ADC_STA_SUMCF_mask_b1                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_STA_SUMCF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_STA_SUMCF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_STA_SUMCF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_STA_SUMCF_happened_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_STA_SUMCF_happened_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_STA_SUMCF_happened_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_STA_SUMOF_mask_w                        ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define ADC_STA_SUMOF_mask_h0                       ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define ADC_STA_SUMOF_mask_b1                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_STA_SUMOF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_STA_SUMOF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_STA_SUMOF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_STA_SUMOF_happened_w                    ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_STA_SUMOF_happened_h0                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_STA_SUMOF_happened_b1                   ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_STA_WDHF_mask_w                         ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define ADC_STA_WDHF_mask_h0                        ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define ADC_STA_WDHF_mask_b1                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_STA_WDHF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_STA_WDHF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_STA_WDHF_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_STA_WDHF_happened_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_STA_WDHF_happened_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_STA_WDHF_happened_b1                    ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_STA_WDIF_mask_w                         ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define ADC_STA_WDIF_mask_h0                        ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define ADC_STA_WDIF_mask_b1                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_STA_WDIF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_STA_WDIF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_STA_WDIF_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_STA_WDIF_happened_w                     ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_STA_WDIF_happened_h0                    ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_STA_WDIF_happened_b1                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_STA_WDLF_mask_w                         ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define ADC_STA_WDLF_mask_h0                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define ADC_STA_WDLF_mask_b1                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_STA_WDLF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_STA_WDLF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_STA_WDLF_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_STA_WDLF_happened_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_STA_WDLF_happened_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_STA_WDLF_happened_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_STA_OVRF_mask_w                         ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define ADC_STA_OVRF_mask_h0                        ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define ADC_STA_OVRF_mask_b0                        ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_STA_OVRF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_STA_OVRF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_STA_OVRF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_STA_OVRF_happened_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_STA_OVRF_happened_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_STA_OVRF_happened_b0                    ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_STA_ESCNVF_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define ADC_STA_ESCNVF_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define ADC_STA_ESCNVF_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_STA_ESCNVF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_STA_ESCNVF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_STA_ESCNVF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_STA_ESCNVF_happened_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_STA_ESCNVF_happened_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_STA_ESCNVF_happened_b0                  ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_STA_E1CNVF_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define ADC_STA_E1CNVF_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define ADC_STA_E1CNVF_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define ADC_STA_E1CNVF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_STA_E1CNVF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_STA_E1CNVF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_STA_E1CNVF_happened_w                   ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_STA_E1CNVF_happened_h0                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_STA_E1CNVF_happened_b0                  ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_STA_ESMPF_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define ADC_STA_ESMPF_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define ADC_STA_ESMPF_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_STA_ESMPF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_STA_ESMPF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_STA_ESMPF_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_STA_ESMPF_happened_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_STA_ESMPF_happened_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_STA_ESMPF_happened_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_STA_SOCF_mask_w                         ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define ADC_STA_SOCF_mask_h0                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define ADC_STA_SOCF_mask_b0                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_STA_SOCF_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define ADC_STA_SOCF_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define ADC_STA_SOCF_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_INT  [register's definitions]
 *              Offset[0x04]  ADC interrupt enable register
 ******************************************************************************
 */
///@{
#define ADC_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_INT */
#define ADC_INT_SUMOVR_IE_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define ADC_INT_SUMOVR_IE_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define ADC_INT_SUMOVR_IE_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_INT_SUMOVR_IE_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_SUMOVR_IE_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_SUMOVR_IE_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_SUMOVR_IE_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_SUMOVR_IE_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_SUMOVR_IE_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_INT_SUMC_IE_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define ADC_INT_SUMC_IE_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define ADC_INT_SUMC_IE_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_INT_SUMC_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_SUMC_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_SUMC_IE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_SUMC_IE_enable_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_SUMC_IE_enable_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_SUMC_IE_enable_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_INT_SUMO_IE_mask_w                      ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define ADC_INT_SUMO_IE_mask_h0                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define ADC_INT_SUMO_IE_mask_b1                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_INT_SUMO_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_SUMO_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_SUMO_IE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_SUMO_IE_enable_w                    ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_SUMO_IE_enable_h0                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_SUMO_IE_enable_b1                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_INT_WDH_IE_mask_w                       ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define ADC_INT_WDH_IE_mask_h0                      ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define ADC_INT_WDH_IE_mask_b1                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_INT_WDH_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_WDH_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_WDH_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_WDH_IE_enable_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_WDH_IE_enable_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_WDH_IE_enable_b1                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_INT_WDI_IE_mask_w                       ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define ADC_INT_WDI_IE_mask_h0                      ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define ADC_INT_WDI_IE_mask_b1                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_INT_WDI_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_WDI_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_WDI_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_WDI_IE_enable_w                     ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_WDI_IE_enable_h0                    ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_WDI_IE_enable_b1                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_INT_WDL_IE_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define ADC_INT_WDL_IE_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define ADC_INT_WDL_IE_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_INT_WDL_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_WDL_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_WDL_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_WDL_IE_enable_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_WDL_IE_enable_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_WDL_IE_enable_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_INT_OVR_IE_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define ADC_INT_OVR_IE_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define ADC_INT_OVR_IE_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_INT_OVR_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_OVR_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_OVR_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_OVR_IE_enable_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_OVR_IE_enable_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_OVR_IE_enable_b0                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_INT_ESCNV_IE_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define ADC_INT_ESCNV_IE_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define ADC_INT_ESCNV_IE_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_INT_ESCNV_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_ESCNV_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_ESCNV_IE_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_ESCNV_IE_enable_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_ESCNV_IE_enable_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_ESCNV_IE_enable_b0                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_INT_E1CNV_IE_mask_w                     ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define ADC_INT_E1CNV_IE_mask_h0                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define ADC_INT_E1CNV_IE_mask_b0                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define ADC_INT_E1CNV_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_E1CNV_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_E1CNV_IE_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_E1CNV_IE_enable_w                   ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_E1CNV_IE_enable_h0                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_E1CNV_IE_enable_b0                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_INT_ESMP_IE_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define ADC_INT_ESMP_IE_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define ADC_INT_ESMP_IE_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_INT_ESMP_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_ESMP_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_ESMP_IE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_ESMP_IE_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_ESMP_IE_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_ESMP_IE_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define ADC_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define ADC_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_CLK  [register's definitions]
 *              Offset[0x08]  ADC clock source register
 ******************************************************************************
 */
///@{
#define ADC_CLK_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_CLK */
#define ADC_CLK_SCNT_mask_w                         ((uint32_t)0xF0000000)  /*!< Bit Mask of 32bit */
#define ADC_CLK_SCNT_mask_h1                        ((uint16_t)0xF000)      /*!< Bit Mask of 16bit */
#define ADC_CLK_SCNT_mask_b3                        ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */

#define ADC_CLK_CK_SDIV_mask_w                      ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define ADC_CLK_CK_SDIV_mask_h1                     ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define ADC_CLK_CK_SDIV_mask_b3                     ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define ADC_CLK_CK_SDIV_div1_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define ADC_CLK_CK_SDIV_div1_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define ADC_CLK_CK_SDIV_div1_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define ADC_CLK_CK_SDIV_div4_w                      ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):DIV4 of 32bit */
#define ADC_CLK_CK_SDIV_div4_h1                     ((uint16_t)0x0100)      /*!< Bit Value =(0x1):DIV4 of 16bit */
#define ADC_CLK_CK_SDIV_div4_b3                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):DIV4 of 8bit */
#define ADC_CLK_CK_SDIV_div16_w                     ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):DIV16 of 32bit */
#define ADC_CLK_CK_SDIV_div16_h1                    ((uint16_t)0x0200)      /*!< Bit Value =(0x2):DIV16 of 16bit */
#define ADC_CLK_CK_SDIV_div16_b3                    ((uint8_t )0x02)        /*!< Bit Value =(0x2):DIV16 of 8bit */
#define ADC_CLK_CK_SDIV_div32_w                     ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):DIV32 of 32bit */
#define ADC_CLK_CK_SDIV_div32_h1                    ((uint16_t)0x0300)      /*!< Bit Value =(0x3):DIV32 of 16bit */
#define ADC_CLK_CK_SDIV_div32_b3                    ((uint8_t )0x03)        /*!< Bit Value =(0x3):DIV32 of 8bit */

#define ADC_CLK_CK_DLY_mask_w                       ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define ADC_CLK_CK_DLY_mask_h0                      ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define ADC_CLK_CK_DLY_mask_b1                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define ADC_CLK_CK_DLY_no_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define ADC_CLK_CK_DLY_no_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define ADC_CLK_CK_DLY_no_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define ADC_CLK_CK_DLY_dly_w                        ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):DLY of 32bit */
#define ADC_CLK_CK_DLY_dly_h0                       ((uint16_t)0x1000)      /*!< Bit Value =(0x1):DLY of 16bit */
#define ADC_CLK_CK_DLY_dly_b1                       ((uint8_t )0x10)        /*!< Bit Value =(0x1):DLY of 8bit */
#define ADC_CLK_CK_DLY_inv_w                        ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):INV of 32bit */
#define ADC_CLK_CK_DLY_inv_h0                       ((uint16_t)0x2000)      /*!< Bit Value =(0x2):INV of 16bit */
#define ADC_CLK_CK_DLY_inv_b1                       ((uint8_t )0x20)        /*!< Bit Value =(0x2):INV of 8bit */
#define ADC_CLK_CK_DLY_idly_w                       ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):IDLY of 32bit */
#define ADC_CLK_CK_DLY_idly_h0                      ((uint16_t)0x3000)      /*!< Bit Value =(0x3):IDLY of 16bit */
#define ADC_CLK_CK_DLY_idly_b1                      ((uint8_t )0x30)        /*!< Bit Value =(0x3):IDLY of 8bit */

#define ADC_CLK_CK_DIV2_mask_w                      ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define ADC_CLK_CK_DIV2_mask_h0                     ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define ADC_CLK_CK_DIV2_mask_b1                     ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define ADC_CLK_CK_DIV2_div2_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV2 of 32bit */
#define ADC_CLK_CK_DIV2_div2_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV2 of 16bit */
#define ADC_CLK_CK_DIV2_div2_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV2 of 8bit */
#define ADC_CLK_CK_DIV2_div4_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):DIV4 of 32bit */
#define ADC_CLK_CK_DIV2_div4_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(0x1):DIV4 of 16bit */
#define ADC_CLK_CK_DIV2_div4_b1                     ((uint8_t )0x04)        /*!< Bit Value =(0x1):DIV4 of 8bit */
#define ADC_CLK_CK_DIV2_div5_w                      ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):DIV5 of 32bit */
#define ADC_CLK_CK_DIV2_div5_h0                     ((uint16_t)0x0800)      /*!< Bit Value =(0x2):DIV5 of 16bit */
#define ADC_CLK_CK_DIV2_div5_b1                     ((uint8_t )0x08)        /*!< Bit Value =(0x2):DIV5 of 8bit */
#define ADC_CLK_CK_DIV2_div6_w                      ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):DIV6 of 32bit */
#define ADC_CLK_CK_DIV2_div6_h0                     ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):DIV6 of 16bit */
#define ADC_CLK_CK_DIV2_div6_b1                     ((uint8_t )0x0C)        /*!< Bit Value =(0x3):DIV6 of 8bit */

#define ADC_CLK_CK_SEL2_mask_w                      ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define ADC_CLK_CK_SEL2_mask_h0                     ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define ADC_CLK_CK_SEL2_mask_b1                     ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define ADC_CLK_CK_SEL2_ck_adc_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_ADC of 32bit */
#define ADC_CLK_CK_SEL2_ck_adc_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_ADC of 16bit */
#define ADC_CLK_CK_SEL2_ck_adc_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_ADC of 8bit */
#define ADC_CLK_CK_SEL2_ck_pll_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):CK_PLL of 32bit */
#define ADC_CLK_CK_SEL2_ck_pll_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CK_PLL of 16bit */
#define ADC_CLK_CK_SEL2_ck_pll_b1                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK_PLL of 8bit */
#define ADC_CLK_CK_SEL2_tm00_trgo_w                 ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):TM00_TRGO of 32bit */
#define ADC_CLK_CK_SEL2_tm00_trgo_h0                ((uint16_t)0x0200)      /*!< Bit Value =(0x2):TM00_TRGO of 16bit */
#define ADC_CLK_CK_SEL2_tm00_trgo_b1                ((uint8_t )0x02)        /*!< Bit Value =(0x2):TM00_TRGO of 8bit */
#define ADC_CLK_CK_SEL2_tm01_trgo_w                 ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):TM01_TRGO of 32bit */
#define ADC_CLK_CK_SEL2_tm01_trgo_h0                ((uint16_t)0x0300)      /*!< Bit Value =(0x3):TM01_TRGO of 16bit */
#define ADC_CLK_CK_SEL2_tm01_trgo_b1                ((uint8_t )0x03)        /*!< Bit Value =(0x3):TM01_TRGO of 8bit */

#define ADC_CLK_CK_DIV_mask_w                       ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define ADC_CLK_CK_DIV_mask_h0                      ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define ADC_CLK_CK_DIV_mask_b0                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define ADC_CLK_CK_DIV_div1_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define ADC_CLK_CK_DIV_div1_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define ADC_CLK_CK_DIV_div1_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define ADC_CLK_CK_DIV_div2_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define ADC_CLK_CK_DIV_div2_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define ADC_CLK_CK_DIV_div2_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define ADC_CLK_CK_DIV_div4_w                       ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define ADC_CLK_CK_DIV_div4_h0                      ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define ADC_CLK_CK_DIV_div4_b0                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define ADC_CLK_CK_DIV_div16_w                      ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):DIV16 of 32bit */
#define ADC_CLK_CK_DIV_div16_h0                     ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV16 of 16bit */
#define ADC_CLK_CK_DIV_div16_b0                     ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV16 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_WINDTH  [register's definitions]
 *              Offset[0x0C]  ADC window detect threshold register
 ******************************************************************************
 */
///@{
#define ADC_WINDTH_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_WINDTH */
#define ADC_WINDTH_WIND_HT_mask_w                   ((uint32_t)0x0FFF0000)  /*!< Bit Mask of 32bit */
#define ADC_WINDTH_WIND_HT_mask_h1                  ((uint16_t)0x0FFF)      /*!< Bit Mask of 16bit */
#define ADC_WINDTH_WIND_HT_shift_w                  (16)                    /*!< Bit Shift of 32bit */
#define ADC_WINDTH_WIND_HT_shift_h1                 (0)                     /*!< Bit Shift of 16bit */
#define ADC_WINDTH_WIND_HT_shift_b2                 (0)                     /*!< Bit Shift of 8bit */

#define ADC_WINDTH_WIND_LT_mask_w                   ((uint32_t)0x00000FFF)  /*!< Bit Mask of 32bit */
#define ADC_WINDTH_WIND_LT_mask_h0                  ((uint16_t)0x0FFF)      /*!< Bit Mask of 16bit */
#define ADC_WINDTH_WIND_LT_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define ADC_WINDTH_WIND_LT_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define ADC_WINDTH_WIND_LT_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_CR0  [register's definitions]
 *              Offset[0x10]  ADC control register 0
 ******************************************************************************
 */
///@{
#define ADC_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_CR0 */
#define ADC_CR0_DMA_EN_mask_w                       ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define ADC_CR0_DMA_EN_mask_h1                      ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define ADC_CR0_DMA_EN_mask_b3                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_CR0_DMA_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_CR0_DMA_EN_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_CR0_DMA_EN_disable_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_CR0_DMA_EN_enable_w                     ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_CR0_DMA_EN_enable_h1                    ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_CR0_DMA_EN_enable_b3                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_CR0_DMA_DSIZE_mask_w                    ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define ADC_CR0_DMA_DSIZE_mask_h1                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define ADC_CR0_DMA_DSIZE_mask_b3                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_CR0_DMA_DSIZE_32bit_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):32Bit of 32bit */
#define ADC_CR0_DMA_DSIZE_32bit_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):32Bit of 16bit */
#define ADC_CR0_DMA_DSIZE_32bit_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):32Bit of 8bit */
#define ADC_CR0_DMA_DSIZE_16bit_w                   ((uint32_t)0x40000000)  /*!< Bit Value =(1):16Bit of 32bit */
#define ADC_CR0_DMA_DSIZE_16bit_h1                  ((uint16_t)0x4000)      /*!< Bit Value =(1):16Bit of 16bit */
#define ADC_CR0_DMA_DSIZE_16bit_b3                  ((uint8_t )0x40)        /*!< Bit Value =(1):16Bit of 8bit */

#define ADC_CR0_DMA_MDS_mask_w                      ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define ADC_CR0_DMA_MDS_mask_h1                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define ADC_CR0_DMA_MDS_mask_b3                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_CR0_DMA_MDS_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_CR0_DMA_MDS_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_CR0_DMA_MDS_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_CR0_DMA_MDS_keep_w                      ((uint32_t)0x20000000)  /*!< Bit Value =(1):Keep of 32bit */
#define ADC_CR0_DMA_MDS_keep_h1                     ((uint16_t)0x2000)      /*!< Bit Value =(1):Keep of 16bit */
#define ADC_CR0_DMA_MDS_keep_b3                     ((uint8_t )0x20)        /*!< Bit Value =(1):Keep of 8bit */

#define ADC_CR0_SMP_SEL_mask_w                      ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define ADC_CR0_SMP_SEL_mask_h1                     ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define ADC_CR0_SMP_SEL_mask_b2                     ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define ADC_CR0_SMP_SEL_shift_w                     (16)                    /*!< Bit Shift of 32bit */
#define ADC_CR0_SMP_SEL_shift_h1                    (0)                     /*!< Bit Shift of 16bit */
#define ADC_CR0_SMP_SEL_shift_b2                    (0)                     /*!< Bit Shift of 8bit */

#define ADC_CR0_LIM_MDS_mask_w                      ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define ADC_CR0_LIM_MDS_mask_h0                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define ADC_CR0_LIM_MDS_mask_b1                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define ADC_CR0_LIM_MDS_no_operation_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No operation of 32bit */
#define ADC_CR0_LIM_MDS_no_operation_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No operation of 16bit */
#define ADC_CR0_LIM_MDS_no_operation_b1             ((uint8_t )0x00)        /*!< Bit Value =(0x0):No operation of 8bit */
#define ADC_CR0_LIM_MDS_skip_w                      ((uint32_t)0x00004000)  /*!< Bit Value =(0x1):Skip of 32bit */
#define ADC_CR0_LIM_MDS_skip_h0                     ((uint16_t)0x4000)      /*!< Bit Value =(0x1):Skip of 16bit */
#define ADC_CR0_LIM_MDS_skip_b1                     ((uint8_t )0x40)        /*!< Bit Value =(0x1):Skip of 8bit */
#define ADC_CR0_LIM_MDS_clamp_w                     ((uint32_t)0x00008000)  /*!< Bit Value =(0x2):Clamp of 32bit */
#define ADC_CR0_LIM_MDS_clamp_h0                    ((uint16_t)0x8000)      /*!< Bit Value =(0x2):Clamp of 16bit */
#define ADC_CR0_LIM_MDS_clamp_b1                    ((uint8_t )0x80)        /*!< Bit Value =(0x2):Clamp of 8bit */

#define ADC_CR0_CH_CHG_mask_w                       ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define ADC_CR0_CH_CHG_mask_h0                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define ADC_CR0_CH_CHG_mask_b1                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define ADC_CR0_CH_CHG_conv_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):CONV of 32bit */
#define ADC_CR0_CH_CHG_conv_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):CONV of 16bit */
#define ADC_CR0_CH_CHG_conv_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):CONV of 8bit */
#define ADC_CR0_CH_CHG_smp_w                        ((uint32_t)0x00000800)  /*!< Bit Value =(1):SMP of 32bit */
#define ADC_CR0_CH_CHG_smp_h0                       ((uint16_t)0x0800)      /*!< Bit Value =(1):SMP of 16bit */
#define ADC_CR0_CH_CHG_smp_b1                       ((uint8_t )0x08)        /*!< Bit Value =(1):SMP of 8bit */

#define ADC_CR0_RES_SEL_mask_w                      ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define ADC_CR0_RES_SEL_mask_h0                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define ADC_CR0_RES_SEL_mask_b0                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define ADC_CR0_RES_SEL_12_bit_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):12-bit of 32bit */
#define ADC_CR0_RES_SEL_12_bit_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):12-bit of 16bit */
#define ADC_CR0_RES_SEL_12_bit_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):12-bit of 8bit */
#define ADC_CR0_RES_SEL_10_bit_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):10-bit of 32bit */
#define ADC_CR0_RES_SEL_10_bit_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(0x1):10-bit of 16bit */
#define ADC_CR0_RES_SEL_10_bit_b0                   ((uint8_t )0x40)        /*!< Bit Value =(0x1):10-bit of 8bit */
#define ADC_CR0_RES_SEL_8_bit_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):8-bit of 32bit */
#define ADC_CR0_RES_SEL_8_bit_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(0x2):8-bit of 16bit */
#define ADC_CR0_RES_SEL_8_bit_b0                    ((uint8_t )0x80)        /*!< Bit Value =(0x2):8-bit of 8bit */

#define ADC_CR0_DTEST_EN_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define ADC_CR0_DTEST_EN_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define ADC_CR0_DTEST_EN_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_CR0_DTEST_EN_disable_w                  ((uint32_t)0x00000000)
#define ADC_CR0_DTEST_EN_disable_h0                 ((uint16_t)0x0000)
#define ADC_CR0_DTEST_EN_disable_b0                 ((uint8_t )0x00)
#define ADC_CR0_DTEST_EN_enable_w                   ((uint32_t)0x00000020)
#define ADC_CR0_DTEST_EN_enable_h0                  ((uint16_t)0x0020)
#define ADC_CR0_DTEST_EN_enable_b0                  ((uint8_t )0x20)

#define ADC_CR0_WAIT_EN_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define ADC_CR0_WAIT_EN_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define ADC_CR0_WAIT_EN_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_CR0_WAIT_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_CR0_WAIT_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_CR0_WAIT_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_CR0_WAIT_EN_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_CR0_WAIT_EN_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_CR0_WAIT_EN_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_CR0_AUTOFF_EN_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define ADC_CR0_AUTOFF_EN_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define ADC_CR0_AUTOFF_EN_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_CR0_AUTOFF_EN_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_CR0_AUTOFF_EN_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_CR0_AUTOFF_EN_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_CR0_AUTOFF_EN_enable_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_CR0_AUTOFF_EN_enable_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_CR0_AUTOFF_EN_enable_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define ADC_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define ADC_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_CR1  [register's definitions]
 *              Offset[0x14]  ADC control register 1
 ******************************************************************************
 */
///@{
#define ADC_CR1_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_CR1 */
#define ADC_CR1_DOS_VAL_mask_w                      ((uint32_t)0x1F000000)  /*!< Bit Mask of 32bit */
#define ADC_CR1_DOS_VAL_mask_h1                     ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define ADC_CR1_DOS_VAL_mask_b3                     ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define ADC_CR1_DOS_VAL_shift_w                     (24)                    /*!< Bit Shift of 32bit */
#define ADC_CR1_DOS_VAL_shift_h1                    (8)                     /*!< Bit Shift of 16bit */
#define ADC_CR1_DOS_VAL_shift_b3                    (0)                     /*!< Bit Shift of 8bit */

#define ADC_CR1_SUM_NUM_mask_w                      ((uint32_t)0x007F0000)  /*!< Bit Mask of 32bit */
#define ADC_CR1_SUM_NUM_mask_h1                     ((uint16_t)0x007F)      /*!< Bit Mask of 16bit */
#define ADC_CR1_SUM_NUM_mask_b2                     ((uint8_t )0x7F)        /*!< Bit Mask of 8bit */
#define ADC_CR1_SUM_NUM_shift_w                     (16)                    /*!< Bit Shift of 32bit */
#define ADC_CR1_SUM_NUM_shift_h1                    (0)                     /*!< Bit Shift of 16bit */
#define ADC_CR1_SUM_NUM_shift_b2                    (0)                     /*!< Bit Shift of 8bit */

#define ADC_CR1_SUM_MDS_mask_w                      ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define ADC_CR1_SUM_MDS_mask_h0                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define ADC_CR1_SUM_MDS_mask_b1                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_CR1_SUM_MDS_single_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Single of 32bit */
#define ADC_CR1_SUM_MDS_single_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Single of 16bit */
#define ADC_CR1_SUM_MDS_single_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Single of 8bit */
#define ADC_CR1_SUM_MDS_all_w                       ((uint32_t)0x00000400)  /*!< Bit Value =(1):All of 32bit */
#define ADC_CR1_SUM_MDS_all_h0                      ((uint16_t)0x0400)      /*!< Bit Value =(1):All of 16bit */
#define ADC_CR1_SUM_MDS_all_b1                      ((uint8_t )0x04)        /*!< Bit Value =(1):All of 8bit */

#define ADC_CR1_SOVR_MDS_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define ADC_CR1_SOVR_MDS_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define ADC_CR1_SOVR_MDS_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_CR1_SOVR_MDS_overwritten_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Overwritten of 32bit */
#define ADC_CR1_SOVR_MDS_overwritten_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Overwritten of 16bit */
#define ADC_CR1_SOVR_MDS_overwritten_b1             ((uint8_t )0x00)        /*!< Bit Value =(0):Overwritten of 8bit */
#define ADC_CR1_SOVR_MDS_keep_w                     ((uint32_t)0x00000200)  /*!< Bit Value =(1):Keep of 32bit */
#define ADC_CR1_SOVR_MDS_keep_h0                    ((uint16_t)0x0200)      /*!< Bit Value =(1):Keep of 16bit */
#define ADC_CR1_SOVR_MDS_keep_b1                    ((uint8_t )0x02)        /*!< Bit Value =(1):Keep of 8bit */

#define ADC_CR1_OVR_MDS_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define ADC_CR1_OVR_MDS_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define ADC_CR1_OVR_MDS_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_CR1_OVR_MDS_overwritten_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Overwritten of 32bit */
#define ADC_CR1_OVR_MDS_overwritten_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Overwritten of 16bit */
#define ADC_CR1_OVR_MDS_overwritten_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Overwritten of 8bit */
#define ADC_CR1_OVR_MDS_keep_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(1):Keep of 32bit */
#define ADC_CR1_OVR_MDS_keep_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(1):Keep of 16bit */
#define ADC_CR1_OVR_MDS_keep_b1                     ((uint8_t )0x01)        /*!< Bit Value =(1):Keep of 8bit */

#define ADC_CR1_OUT_SEL_mask_w                      ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define ADC_CR1_OUT_SEL_mask_h0                     ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define ADC_CR1_OUT_SEL_mask_b0                     ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define ADC_CR1_OUT_SEL_wdl_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):WDL of 32bit */
#define ADC_CR1_OUT_SEL_wdl_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):WDL of 16bit */
#define ADC_CR1_OUT_SEL_wdl_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):WDL of 8bit */
#define ADC_CR1_OUT_SEL_wdi_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):WDI of 32bit */
#define ADC_CR1_OUT_SEL_wdi_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):WDI of 16bit */
#define ADC_CR1_OUT_SEL_wdi_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):WDI of 8bit */
#define ADC_CR1_OUT_SEL_wdh_w                       ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):WDH of 32bit */
#define ADC_CR1_OUT_SEL_wdh_h0                      ((uint16_t)0x0020)      /*!< Bit Value =(0x2):WDH of 16bit */
#define ADC_CR1_OUT_SEL_wdh_b0                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):WDH of 8bit */
#define ADC_CR1_OUT_SEL_rdy_w                       ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):RDY of 32bit */
#define ADC_CR1_OUT_SEL_rdy_h0                      ((uint16_t)0x0030)      /*!< Bit Value =(0x3):RDY of 16bit */
#define ADC_CR1_OUT_SEL_rdy_b0                      ((uint8_t )0x30)        /*!< Bit Value =(0x3):RDY of 8bit */
#define ADC_CR1_OUT_SEL_ints0_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):INTS0 of 32bit */
#define ADC_CR1_OUT_SEL_ints0_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(0x4):INTS0 of 16bit */
#define ADC_CR1_OUT_SEL_ints0_b0                    ((uint8_t )0x40)        /*!< Bit Value =(0x4):INTS0 of 8bit */
#define ADC_CR1_OUT_SEL_ints1_w                     ((uint32_t)0x00000050)  /*!< Bit Value =(0x5):INTS1 of 32bit */
#define ADC_CR1_OUT_SEL_ints1_h0                    ((uint16_t)0x0050)      /*!< Bit Value =(0x5):INTS1 of 16bit */
#define ADC_CR1_OUT_SEL_ints1_b0                    ((uint8_t )0x50)        /*!< Bit Value =(0x5):INTS1 of 8bit */
#define ADC_CR1_OUT_SEL_ints2_w                     ((uint32_t)0x00000060)  /*!< Bit Value =(0x6):INTS2 of 32bit */
#define ADC_CR1_OUT_SEL_ints2_h0                    ((uint16_t)0x0060)      /*!< Bit Value =(0x6):INTS2 of 16bit */
#define ADC_CR1_OUT_SEL_ints2_b0                    ((uint8_t )0x60)        /*!< Bit Value =(0x6):INTS2 of 8bit */
#define ADC_CR1_OUT_SEL_ints3_w                     ((uint32_t)0x00000070)  /*!< Bit Value =(0x7):INTS3 of 32bit */
#define ADC_CR1_OUT_SEL_ints3_h0                    ((uint16_t)0x0070)      /*!< Bit Value =(0x7):INTS3 of 16bit */
#define ADC_CR1_OUT_SEL_ints3_b0                    ((uint8_t )0x70)        /*!< Bit Value =(0x7):INTS3 of 8bit */

#define ADC_CR1_ALIGN_SEL_mask_w                    ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define ADC_CR1_ALIGN_SEL_mask_h0                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define ADC_CR1_ALIGN_SEL_mask_b0                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define ADC_CR1_ALIGN_SEL_right_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Right of 32bit */
#define ADC_CR1_ALIGN_SEL_right_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Right of 16bit */
#define ADC_CR1_ALIGN_SEL_right_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Right of 8bit */
#define ADC_CR1_ALIGN_SEL_left_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Left of 32bit */
#define ADC_CR1_ALIGN_SEL_left_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Left of 16bit */
#define ADC_CR1_ALIGN_SEL_left_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Left of 8bit */

#define ADC_CR1_WIND_MDS_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define ADC_CR1_WIND_MDS_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define ADC_CR1_WIND_MDS_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_CR1_WIND_MDS_single_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Single of 32bit */
#define ADC_CR1_WIND_MDS_single_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Single of 16bit */
#define ADC_CR1_WIND_MDS_single_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Single of 8bit */
#define ADC_CR1_WIND_MDS_all_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):All of 32bit */
#define ADC_CR1_WIND_MDS_all_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):All of 16bit */
#define ADC_CR1_WIND_MDS_all_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):All of 8bit */

#define ADC_CR1_WIND_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define ADC_CR1_WIND_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define ADC_CR1_WIND_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_CR1_WIND_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_CR1_WIND_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_CR1_WIND_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_CR1_WIND_EN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_CR1_WIND_EN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_CR1_WIND_EN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_MSK  [register's definitions]
 *              Offset[0x1C]  ADC channel mask register
 ******************************************************************************
 */
///@{
#define ADC_MSK_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_MSK */
#define ADC_MSK_SUM2_MUX_mask_w                     ((uint32_t)0x0F000000)  /*!< Bit Mask of 32bit */
#define ADC_MSK_SUM2_MUX_mask_h1                    ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define ADC_MSK_SUM2_MUX_mask_b3                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define ADC_MSK_SUM2_MUX_shift_w                    (24)                    /*!< Bit Shift of 32bit */
#define ADC_MSK_SUM2_MUX_shift_h1                   (8)                     /*!< Bit Shift of 16bit */
#define ADC_MSK_SUM2_MUX_shift_b3                   (0)                     /*!< Bit Shift of 8bit */

#define ADC_MSK_SUM1_MUX_mask_w                     ((uint32_t)0x00F00000)  /*!< Bit Mask of 32bit */
#define ADC_MSK_SUM1_MUX_mask_h1                    ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define ADC_MSK_SUM1_MUX_mask_b2                    ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define ADC_MSK_SUM1_MUX_shift_w                    (20)                    /*!< Bit Shift of 32bit */
#define ADC_MSK_SUM1_MUX_shift_h1                   (4)                     /*!< Bit Shift of 16bit */
#define ADC_MSK_SUM1_MUX_shift_b2                   (4)                     /*!< Bit Shift of 8bit */

#define ADC_MSK_SUM0_MUX_mask_w                     ((uint32_t)0x000F0000)  /*!< Bit Mask of 32bit */
#define ADC_MSK_SUM0_MUX_mask_h1                    ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define ADC_MSK_SUM0_MUX_mask_b2                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define ADC_MSK_SUM0_MUX_shift_w                    (16)                    /*!< Bit Shift of 32bit */
#define ADC_MSK_SUM0_MUX_shift_h1                   (0)                     /*!< Bit Shift of 16bit */
#define ADC_MSK_SUM0_MUX_shift_b2                   (0)                     /*!< Bit Shift of 8bit */

#define ADC_MSK_CH_MSK15_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK15_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK15_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK15_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK15_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK15_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK15_enable_w                   ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK15_enable_h0                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK15_enable_b1                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK14_mask_w                     ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK14_mask_h0                    ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK14_mask_b1                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK14_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK14_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK14_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK14_enable_w                   ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK14_enable_h0                  ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK14_enable_b1                  ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK13_mask_w                     ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK13_mask_h0                    ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK13_mask_b1                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK13_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK13_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK13_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK13_enable_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK13_enable_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK13_enable_b1                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK12_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK12_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK12_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK12_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK12_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK12_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK12_enable_w                   ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK12_enable_h0                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK12_enable_b1                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK11_mask_w                     ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK11_mask_h0                    ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK11_mask_b1                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK11_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK11_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK11_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK11_enable_w                   ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK11_enable_h0                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK11_enable_b1                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK10_mask_w                     ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK10_mask_h0                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK10_mask_b1                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK10_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK10_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK10_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK10_enable_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK10_enable_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK10_enable_b1                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK9_mask_w                      ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK9_mask_h0                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK9_mask_b1                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK9_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK9_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK9_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK9_enable_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK9_enable_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK9_enable_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK8_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK8_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK8_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK8_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK8_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK8_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK8_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK8_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK8_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK7_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK7_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK7_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK7_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK7_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK7_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK7_enable_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK7_enable_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK7_enable_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK6_mask_w                      ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK6_mask_h0                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK6_mask_b0                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK6_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK6_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK6_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK6_enable_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK6_enable_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK6_enable_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK5_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK5_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK5_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK5_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK5_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK5_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK5_enable_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK5_enable_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK5_enable_b0                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK4_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK4_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK4_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK4_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK4_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK4_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK4_enable_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK4_enable_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK4_enable_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK3_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK3_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK3_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK3_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK3_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK3_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK3_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK3_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK3_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK2_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK2_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK2_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK2_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK2_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK2_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK2_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK2_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK2_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK1_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK1_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK1_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK1_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK1_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK1_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK1_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK1_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK1_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_MSK_CH_MSK0_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define ADC_MSK_CH_MSK0_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define ADC_MSK_CH_MSK0_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_MSK_CH_MSK0_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_MSK_CH_MSK0_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_MSK_CH_MSK0_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_MSK_CH_MSK0_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_MSK_CH_MSK0_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_MSK_CH_MSK0_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_START  [register's definitions]
 *              Offset[0x20]  ADC start conversion register
 ******************************************************************************
 */
///@{
#define ADC_START_default                           ((uint32_t)0x00001000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_START */
#define ADC_START_CONV_MDS_mask_w                   ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define ADC_START_CONV_MDS_mask_h1                  ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define ADC_START_CONV_MDS_mask_b3                  ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define ADC_START_CONV_MDS_one_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):One of 32bit */
#define ADC_START_CONV_MDS_one_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):One of 16bit */
#define ADC_START_CONV_MDS_one_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):One of 8bit */
#define ADC_START_CONV_MDS_scan_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):Scan of 32bit */
#define ADC_START_CONV_MDS_scan_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Scan of 16bit */
#define ADC_START_CONV_MDS_scan_b3                  ((uint8_t )0x01)        /*!< Bit Value =(0x1):Scan of 8bit */
#define ADC_START_CONV_MDS_loop_w                   ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):Loop of 32bit */
#define ADC_START_CONV_MDS_loop_h1                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Loop of 16bit */
#define ADC_START_CONV_MDS_loop_b3                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):Loop of 8bit */

#define ADC_START_TRG_SEL_mask_w                    ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define ADC_START_TRG_SEL_mask_h1                   ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define ADC_START_TRG_SEL_mask_b2                   ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define ADC_START_TRG_SEL_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define ADC_START_TRG_SEL_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define ADC_START_TRG_SEL_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define ADC_START_TRG_SEL_rising_edge_w             ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):Rising edge of 32bit */
#define ADC_START_TRG_SEL_rising_edge_h1            ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Rising edge of 16bit */
#define ADC_START_TRG_SEL_rising_edge_b2            ((uint8_t )0x10)        /*!< Bit Value =(0x1):Rising edge of 8bit */
#define ADC_START_TRG_SEL_falling_edge_w            ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):Falling edge of 32bit */
#define ADC_START_TRG_SEL_falling_edge_h1           ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Falling edge of 16bit */
#define ADC_START_TRG_SEL_falling_edge_b2           ((uint8_t )0x20)        /*!< Bit Value =(0x2):Falling edge of 8bit */
#define ADC_START_TRG_SEL_dual_edge_w               ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define ADC_START_TRG_SEL_dual_edge_h1              ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define ADC_START_TRG_SEL_dual_edge_b2              ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define ADC_START_TRG_CONT_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define ADC_START_TRG_CONT_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define ADC_START_TRG_CONT_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define ADC_START_TRG_CONT_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_START_TRG_CONT_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_START_TRG_CONT_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_START_TRG_CONT_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_START_TRG_CONT_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_START_TRG_CONT_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_START_START_SEL_mask_w                  ((uint32_t)0x00070000)  /*!< Bit Mask of 32bit */
#define ADC_START_START_SEL_mask_h1                 ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define ADC_START_START_SEL_mask_b2                 ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define ADC_START_START_SEL_sw_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):SW of 32bit */
#define ADC_START_START_SEL_sw_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):SW of 16bit */
#define ADC_START_START_SEL_sw_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):SW of 8bit */
#define ADC_START_START_SEL_tm00_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):TM00 of 32bit */
#define ADC_START_START_SEL_tm00_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(0x1):TM00 of 16bit */
#define ADC_START_START_SEL_tm00_b2                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):TM00 of 8bit */
#define ADC_START_START_SEL_pin_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):PIN of 32bit */
#define ADC_START_START_SEL_pin_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(0x2):PIN of 16bit */
#define ADC_START_START_SEL_pin_b2                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):PIN of 8bit */
#define ADC_START_START_SEL_cmp0_w                  ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):CMP0 of 32bit */
#define ADC_START_START_SEL_cmp0_h1                 ((uint16_t)0x0003)      /*!< Bit Value =(0x3):CMP0 of 16bit */
#define ADC_START_START_SEL_cmp0_b2                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):CMP0 of 8bit */
#define ADC_START_START_SEL_cmp1_w                  ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):CMP1 of 32bit */
#define ADC_START_START_SEL_cmp1_h1                 ((uint16_t)0x0004)      /*!< Bit Value =(0x4):CMP1 of 16bit */
#define ADC_START_START_SEL_cmp1_b2                 ((uint8_t )0x04)        /*!< Bit Value =(0x4):CMP1 of 8bit */
#define ADC_START_START_SEL_tm01_w                  ((uint32_t)0x00050000)  /*!< Bit Value =(0x5):TM01 of 32bit */
#define ADC_START_START_SEL_tm01_h1                 ((uint16_t)0x0005)      /*!< Bit Value =(0x5):TM01 of 16bit */
#define ADC_START_START_SEL_tm01_b2                 ((uint8_t )0x05)        /*!< Bit Value =(0x5):TM01 of 8bit */
#define ADC_START_START_SEL_tm20_w                  ((uint32_t)0x00060000)  /*!< Bit Value =(0x6):TM20 of 32bit */
#define ADC_START_START_SEL_tm20_h1                 ((uint16_t)0x0006)      /*!< Bit Value =(0x6):TM20 of 16bit */
#define ADC_START_START_SEL_tm20_b2                 ((uint8_t )0x06)        /*!< Bit Value =(0x6):TM20 of 8bit */
#define ADC_START_START_SEL_tm36_w                  ((uint32_t)0x00070000)  /*!< Bit Value =(0x7):TM36 of 32bit */
#define ADC_START_START_SEL_tm36_h1                 ((uint16_t)0x0007)      /*!< Bit Value =(0x7):TM36 of 16bit */
#define ADC_START_START_SEL_tm36_b2                 ((uint8_t )0x07)        /*!< Bit Value =(0x7):TM36 of 8bit */

#define ADC_START_CH_SEL_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define ADC_START_CH_SEL_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define ADC_START_CH_SEL_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define ADC_START_CH_SEL_ext_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):EXT of 32bit */
#define ADC_START_CH_SEL_ext_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):EXT of 16bit */
#define ADC_START_CH_SEL_ext_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):EXT of 8bit */
#define ADC_START_CH_SEL_int_w                      ((uint32_t)0x00001000)  /*!< Bit Value =(1):INT of 32bit */
#define ADC_START_CH_SEL_int_h0                     ((uint16_t)0x1000)      /*!< Bit Value =(1):INT of 16bit */
#define ADC_START_CH_SEL_int_b1                     ((uint8_t )0x10)        /*!< Bit Value =(1):INT of 8bit */

#define ADC_START_CH_MUX_mask_w                     ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define ADC_START_CH_MUX_mask_h0                    ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define ADC_START_CH_MUX_mask_b1                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */

#define ADC_START_HOLD_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define ADC_START_HOLD_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define ADC_START_HOLD_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_START_HOLD_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_START_HOLD_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_START_HOLD_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_START_HOLD_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_START_HOLD_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_START_HOLD_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_START_START_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define ADC_START_START_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define ADC_START_START_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_START_START_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define ADC_START_START_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define ADC_START_START_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_ANA  [register's definitions]
 *              Offset[0x24]  ADC analog control register
 ******************************************************************************
 */
///@{
#define ADC_ANA_default                             ((uint32_t)0x00000200)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_ANA */
#define ADC_ANA_TS_AUTO_mask_w                      ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define ADC_ANA_TS_AUTO_mask_h0                     ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define ADC_ANA_TS_AUTO_mask_b1                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_ANA_TS_AUTO_auto_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Auto of 32bit */
#define ADC_ANA_TS_AUTO_auto_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Auto of 16bit */
#define ADC_ANA_TS_AUTO_auto_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Auto of 8bit */
#define ADC_ANA_TS_AUTO_normal_w                    ((uint32_t)0x00008000)  /*!< Bit Value =(1):Normal of 32bit */
#define ADC_ANA_TS_AUTO_normal_h0                   ((uint16_t)0x8000)      /*!< Bit Value =(1):Normal of 16bit */
#define ADC_ANA_TS_AUTO_normal_b1                   ((uint8_t )0x80)        /*!< Bit Value =(1):Normal of 8bit */

#define ADC_ANA_CONV_TIME_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define ADC_ANA_CONV_TIME_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define ADC_ANA_CONV_TIME_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_ANA_CONV_TIME_24adck_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):24ADCK of 32bit */
#define ADC_ANA_CONV_TIME_24adck_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):24ADCK of 16bit */
#define ADC_ANA_CONV_TIME_24adck_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):24ADCK of 8bit */
#define ADC_ANA_CONV_TIME_30adck_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):30ADCK of 32bit */
#define ADC_ANA_CONV_TIME_30adck_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):30ADCK of 16bit */
#define ADC_ANA_CONV_TIME_30adck_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):30ADCK of 8bit */

#define ADC_ANA_BUF_BIAS_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define ADC_ANA_BUF_BIAS_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define ADC_ANA_BUF_BIAS_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define ADC_ANA_BUF_BIAS_shift_w                    (12)                    /*!< Bit Shift of 32bit */
#define ADC_ANA_BUF_BIAS_shift_h0                   (12)                    /*!< Bit Shift of 16bit */
#define ADC_ANA_BUF_BIAS_shift_b1                   (4)                     /*!< Bit Shift of 8bit */

#define ADC_ANA_BIAS_mask_w                         ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define ADC_ANA_BIAS_mask_h0                        ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define ADC_ANA_BIAS_mask_b1                        ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define ADC_ANA_BIAS_lvl0_w                         ((uint32_t)0x00000000)
#define ADC_ANA_BIAS_lvl0_h0                        ((uint16_t)0x0000)
#define ADC_ANA_BIAS_lvl0_b1                        ((uint8_t )0x00)
#define ADC_ANA_BIAS_lvl1_w                         ((uint32_t)0x00000100)
#define ADC_ANA_BIAS_lvl1_h0                        ((uint16_t)0x0100)
#define ADC_ANA_BIAS_lvl1_b1                        ((uint8_t )0x01)
#define ADC_ANA_BIAS_lvl2_w                         ((uint32_t)0x00000200)
#define ADC_ANA_BIAS_lvl2_h0                        ((uint16_t)0x0200)
#define ADC_ANA_BIAS_lvl2_b1                        ((uint8_t )0x02)
#define ADC_ANA_BIAS_lvl3_w                         ((uint32_t)0x00000300)
#define ADC_ANA_BIAS_lvl3_h0                        ((uint16_t)0x0300)
#define ADC_ANA_BIAS_lvl3_b1                        ((uint8_t )0x03)

#define ADC_ANA_PGAOUT_EN_mask_w                    ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define ADC_ANA_PGAOUT_EN_mask_h0                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define ADC_ANA_PGAOUT_EN_mask_b0                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_ANA_PGAOUT_EN_disable_w                 ((uint32_t)0x00000000)
#define ADC_ANA_PGAOUT_EN_disable_h0                ((uint16_t)0x0000)
#define ADC_ANA_PGAOUT_EN_disable_b0                ((uint8_t )0x00)
#define ADC_ANA_PGAOUT_EN_enable_w                  ((uint32_t)0x00000080)
#define ADC_ANA_PGAOUT_EN_enable_h0                 ((uint16_t)0x0080)
#define ADC_ANA_PGAOUT_EN_enable_b0                 ((uint8_t )0x80)

#define ADC_ANA_VBGOUT_EN_mask_w                    ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define ADC_ANA_VBGOUT_EN_mask_h0                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define ADC_ANA_VBGOUT_EN_mask_b0                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_ANA_VBGOUT_EN_disable_w                 ((uint32_t)0x00000000)
#define ADC_ANA_VBGOUT_EN_disable_h0                ((uint16_t)0x0000)
#define ADC_ANA_VBGOUT_EN_disable_b0                ((uint8_t )0x00)
#define ADC_ANA_VBGOUT_EN_enable_w                  ((uint32_t)0x00000040)
#define ADC_ANA_VBGOUT_EN_enable_h0                 ((uint16_t)0x0040)
#define ADC_ANA_VBGOUT_EN_enable_b0                 ((uint8_t )0x40)

#define ADC_ANA_IVREF_SEL_mask_w                    ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define ADC_ANA_IVREF_SEL_mask_h0                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define ADC_ANA_IVREF_SEL_mask_b0                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define ADC_ANA_IVREF_SEL_vref_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):VREF of 32bit */
#define ADC_ANA_IVREF_SEL_vref_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):VREF of 16bit */
#define ADC_ANA_IVREF_SEL_vref_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):VREF of 8bit */
#define ADC_ANA_IVREF_SEL_ivr24_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):IVR24 of 32bit */
#define ADC_ANA_IVREF_SEL_ivr24_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(0x1):IVR24 of 16bit */
#define ADC_ANA_IVREF_SEL_ivr24_b0                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):IVR24 of 8bit */

#define ADC_ANA_TS_EN_mask_w                        ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define ADC_ANA_TS_EN_mask_h0                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define ADC_ANA_TS_EN_mask_b0                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define ADC_ANA_TS_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_ANA_TS_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_ANA_TS_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_ANA_TS_EN_enable_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_ANA_TS_EN_enable_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_ANA_TS_EN_enable_b0                     ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_ANA_PGA_EN_mask_w                       ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define ADC_ANA_PGA_EN_mask_h0                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define ADC_ANA_PGA_EN_mask_b0                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_ANA_PGA_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_ANA_PGA_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_ANA_PGA_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_ANA_PGA_EN_enable_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_ANA_PGA_EN_enable_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_ANA_PGA_EN_enable_b0                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define ADC_ANA_IVR_EN_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define ADC_ANA_IVR_EN_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define ADC_ANA_IVR_EN_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_ANA_IVR_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_ANA_IVR_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_ANA_IVR_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_ANA_IVR_EN_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_ANA_IVR_EN_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_ANA_IVR_EN_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_CAL  [register's definitions]
 *              Offset[0x28]  ADC calibration control register
 ******************************************************************************
 */
///@{
#define ADC_CAL_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_CAL */
#define ADC_CAL_CAL_POFFT_mask_w                    ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define ADC_CAL_CAL_POFFT_mask_h0                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define ADC_CAL_CAL_POFFT_mask_b0                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define ADC_CAL_CAL_POFFT_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define ADC_CAL_CAL_POFFT_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define ADC_CAL_CAL_POFFT_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define ADC_CAL_CAL_POFFT_enable_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define ADC_CAL_CAL_POFFT_enable_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define ADC_CAL_CAL_POFFT_enable_b0                 ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_GAIN  [register's definitions]
 *              Offset[0x2C]  ADC gain control register
 ******************************************************************************
 */
///@{
#define ADC_GAIN_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_GAIN */
#define ADC_GAIN_OFFT_ADC_mask_w                    ((uint32_t)0x1F000000)  /*!< Bit Mask of 32bit */
#define ADC_GAIN_OFFT_ADC_mask_h1                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define ADC_GAIN_OFFT_ADC_mask_b3                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define ADC_GAIN_OFFT_ADC_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define ADC_GAIN_OFFT_ADC_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define ADC_GAIN_OFFT_ADC_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define ADC_GAIN_OFFT_PGA_mask_w                    ((uint32_t)0x003F0000)  /*!< Bit Mask of 32bit */
#define ADC_GAIN_OFFT_PGA_mask_h1                   ((uint16_t)0x003F)      /*!< Bit Mask of 16bit */
#define ADC_GAIN_OFFT_PGA_mask_b2                   ((uint8_t )0x3F)        /*!< Bit Mask of 8bit */
#define ADC_GAIN_OFFT_PGA_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define ADC_GAIN_OFFT_PGA_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define ADC_GAIN_OFFT_PGA_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define ADC_GAIN_GAIN_PGA_mask_w                    ((uint32_t)0x0000003F)  /*!< Bit Mask of 32bit */
#define ADC_GAIN_GAIN_PGA_mask_h0                   ((uint16_t)0x003F)      /*!< Bit Mask of 16bit */
#define ADC_GAIN_GAIN_PGA_mask_b0                   ((uint8_t )0x3F)        /*!< Bit Mask of 8bit */
#define ADC_GAIN_GAIN_PGA_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define ADC_GAIN_GAIN_PGA_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define ADC_GAIN_GAIN_PGA_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_SUM0  [register's definitions]
 *              Offset[0x30]  ADC accumulator sum result register 0
 ******************************************************************************
 */
///@{
#define ADC_SUM0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_SUM0 */
#define ADC_SUM0_SUM0_OVRF_mask_w                   ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define ADC_SUM0_SUM0_OVRF_mask_h1                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define ADC_SUM0_SUM0_OVRF_mask_b2                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_SUM0_SUM0_OVRF_shift_w                  (23)                    /*!< Bit Shift of 32bit */
#define ADC_SUM0_SUM0_OVRF_shift_h1                 (7)                     /*!< Bit Shift of 16bit */
#define ADC_SUM0_SUM0_OVRF_shift_b2                 (7)                     /*!< Bit Shift of 8bit */

#define ADC_SUM0_SUM0_CF_mask_w                     ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define ADC_SUM0_SUM0_CF_mask_h1                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define ADC_SUM0_SUM0_CF_mask_b2                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_SUM0_SUM0_CF_shift_w                    (22)                    /*!< Bit Shift of 32bit */
#define ADC_SUM0_SUM0_CF_shift_h1                   (6)                     /*!< Bit Shift of 16bit */
#define ADC_SUM0_SUM0_CF_shift_b2                   (6)                     /*!< Bit Shift of 8bit */

#define ADC_SUM0_SUM0_OF_mask_w                     ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define ADC_SUM0_SUM0_OF_mask_h1                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define ADC_SUM0_SUM0_OF_mask_b2                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_SUM0_SUM0_OF_shift_w                    (21)                    /*!< Bit Shift of 32bit */
#define ADC_SUM0_SUM0_OF_shift_h1                   (5)                     /*!< Bit Shift of 16bit */
#define ADC_SUM0_SUM0_OF_shift_b2                   (5)                     /*!< Bit Shift of 8bit */

#define ADC_SUM0_SUM0_UF_mask_w                     ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define ADC_SUM0_SUM0_UF_mask_h1                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define ADC_SUM0_SUM0_UF_mask_b2                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define ADC_SUM0_SUM0_UF_shift_w                    (20)                    /*!< Bit Shift of 32bit */
#define ADC_SUM0_SUM0_UF_shift_h1                   (4)                     /*!< Bit Shift of 16bit */
#define ADC_SUM0_SUM0_UF_shift_b2                   (4)                     /*!< Bit Shift of 8bit */

#define ADC_SUM0_SUM0_DAT_mask_w                    ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define ADC_SUM0_SUM0_DAT_mask_h0                   ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define ADC_SUM0_SUM0_DAT_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define ADC_SUM0_SUM0_DAT_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define ADC_SUM0_SUM0_DAT_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_SUM1  [register's definitions]
 *              Offset[0x34]  ADC accumulator sum result register 1
 ******************************************************************************
 */
///@{
#define ADC_SUM1_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_SUM1 */
#define ADC_SUM1_SUM1_OVRF_mask_w                   ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define ADC_SUM1_SUM1_OVRF_mask_h1                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define ADC_SUM1_SUM1_OVRF_mask_b2                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_SUM1_SUM1_OVRF_shift_w                  (23)                    /*!< Bit Shift of 32bit */
#define ADC_SUM1_SUM1_OVRF_shift_h1                 (7)                     /*!< Bit Shift of 16bit */
#define ADC_SUM1_SUM1_OVRF_shift_b2                 (7)                     /*!< Bit Shift of 8bit */

#define ADC_SUM1_SUM1_CF_mask_w                     ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define ADC_SUM1_SUM1_CF_mask_h1                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define ADC_SUM1_SUM1_CF_mask_b2                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_SUM1_SUM1_CF_shift_w                    (22)                    /*!< Bit Shift of 32bit */
#define ADC_SUM1_SUM1_CF_shift_h1                   (6)                     /*!< Bit Shift of 16bit */
#define ADC_SUM1_SUM1_CF_shift_b2                   (6)                     /*!< Bit Shift of 8bit */

#define ADC_SUM1_SUM1_OF_mask_w                     ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define ADC_SUM1_SUM1_OF_mask_h1                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define ADC_SUM1_SUM1_OF_mask_b2                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_SUM1_SUM1_OF_shift_w                    (21)                    /*!< Bit Shift of 32bit */
#define ADC_SUM1_SUM1_OF_shift_h1                   (5)                     /*!< Bit Shift of 16bit */
#define ADC_SUM1_SUM1_OF_shift_b2                   (5)                     /*!< Bit Shift of 8bit */

#define ADC_SUM1_SUM1_UF_mask_w                     ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define ADC_SUM1_SUM1_UF_mask_h1                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define ADC_SUM1_SUM1_UF_mask_b2                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define ADC_SUM1_SUM1_UF_shift_w                    (20)                    /*!< Bit Shift of 32bit */
#define ADC_SUM1_SUM1_UF_shift_h1                   (4)                     /*!< Bit Shift of 16bit */
#define ADC_SUM1_SUM1_UF_shift_b2                   (4)                     /*!< Bit Shift of 8bit */

#define ADC_SUM1_SUM1_DAT_mask_w                    ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define ADC_SUM1_SUM1_DAT_mask_h0                   ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define ADC_SUM1_SUM1_DAT_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define ADC_SUM1_SUM1_DAT_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define ADC_SUM1_SUM1_DAT_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_SUM2  [register's definitions]
 *              Offset[0x38]  ADC accumulator sum result register 2
 ******************************************************************************
 */
///@{
#define ADC_SUM2_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_SUM2 */
#define ADC_SUM2_SUM2_OVRF_mask_w                   ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define ADC_SUM2_SUM2_OVRF_mask_h1                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define ADC_SUM2_SUM2_OVRF_mask_b2                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_SUM2_SUM2_OVRF_shift_w                  (23)                    /*!< Bit Shift of 32bit */
#define ADC_SUM2_SUM2_OVRF_shift_h1                 (7)                     /*!< Bit Shift of 16bit */
#define ADC_SUM2_SUM2_OVRF_shift_b2                 (7)                     /*!< Bit Shift of 8bit */

#define ADC_SUM2_SUM2_CF_mask_w                     ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define ADC_SUM2_SUM2_CF_mask_h1                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define ADC_SUM2_SUM2_CF_mask_b2                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_SUM2_SUM2_CF_shift_w                    (22)                    /*!< Bit Shift of 32bit */
#define ADC_SUM2_SUM2_CF_shift_h1                   (6)                     /*!< Bit Shift of 16bit */
#define ADC_SUM2_SUM2_CF_shift_b2                   (6)                     /*!< Bit Shift of 8bit */

#define ADC_SUM2_SUM2_OF_mask_w                     ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define ADC_SUM2_SUM2_OF_mask_h1                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define ADC_SUM2_SUM2_OF_mask_b2                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define ADC_SUM2_SUM2_OF_shift_w                    (21)                    /*!< Bit Shift of 32bit */
#define ADC_SUM2_SUM2_OF_shift_h1                   (5)                     /*!< Bit Shift of 16bit */
#define ADC_SUM2_SUM2_OF_shift_b2                   (5)                     /*!< Bit Shift of 8bit */

#define ADC_SUM2_SUM2_UF_mask_w                     ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define ADC_SUM2_SUM2_UF_mask_h1                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define ADC_SUM2_SUM2_UF_mask_b2                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define ADC_SUM2_SUM2_UF_shift_w                    (20)                    /*!< Bit Shift of 32bit */
#define ADC_SUM2_SUM2_UF_shift_h1                   (4)                     /*!< Bit Shift of 16bit */
#define ADC_SUM2_SUM2_UF_shift_b2                   (4)                     /*!< Bit Shift of 8bit */

#define ADC_SUM2_SUM2_DAT_mask_w                    ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define ADC_SUM2_SUM2_DAT_mask_h0                   ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define ADC_SUM2_SUM2_DAT_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define ADC_SUM2_SUM2_DAT_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define ADC_SUM2_SUM2_DAT_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_TCAL  [register's definitions]
 *              Offset[0x3C]  ADC Temperature Sensor calibration register
 ******************************************************************************
 */
///@{
#define ADC_TCAL_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_TCAL */
#define ADC_TCAL_TCAL1_mask_w                       ((uint32_t)0x0FFF0000)  /*!< Bit Mask of 32bit */
#define ADC_TCAL_TCAL1_mask_h1                      ((uint16_t)0x0FFF)      /*!< Bit Mask of 16bit */
#define ADC_TCAL_TCAL1_shift_w                      (16)                    /*!< Bit Shift of 32bit */
#define ADC_TCAL_TCAL1_shift_h1                     (0)                     /*!< Bit Shift of 16bit */
#define ADC_TCAL_TCAL1_shift_b2                     (0)                     /*!< Bit Shift of 8bit */

#define ADC_TCAL_TCAL0_mask_w                       ((uint32_t)0x00000FFF)  /*!< Bit Mask of 32bit */
#define ADC_TCAL_TCAL0_mask_h0                      ((uint16_t)0x0FFF)      /*!< Bit Mask of 16bit */
#define ADC_TCAL_TCAL0_shift_w                      (0)                     /*!< Bit Shift of 32bit */
#define ADC_TCAL_TCAL0_shift_h0                     (0)                     /*!< Bit Shift of 16bit */
#define ADC_TCAL_TCAL0_shift_b0                     (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        ADC_DAT0  [register's definitions]
 *              Offset[0x40]  ADC conversion data register 0
 ******************************************************************************
 */
///@{
#define ADC_DAT0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of ADC_DAT0 */
#define ADC_DAT0_DAT0_CH_mask_w                     ((uint32_t)0xF0000000)  /*!< Bit Mask of 32bit */
#define ADC_DAT0_DAT0_CH_mask_h1                    ((uint16_t)0xF000)      /*!< Bit Mask of 16bit */
#define ADC_DAT0_DAT0_CH_mask_b3                    ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define ADC_DAT0_DAT0_CH_shift_w                    (28)                    /*!< Bit Shift of 32bit */
#define ADC_DAT0_DAT0_CH_shift_h1                   (12)                    /*!< Bit Shift of 16bit */
#define ADC_DAT0_DAT0_CH_shift_b3                   (4)                     /*!< Bit Shift of 8bit */

#define ADC_DAT0_DAT0_OVRF_mask_w                   ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define ADC_DAT0_DAT0_OVRF_mask_h1                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define ADC_DAT0_DAT0_OVRF_mask_b2                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define ADC_DAT0_DAT0_OVRF_shift_w                  (23)                    /*!< Bit Shift of 32bit */
#define ADC_DAT0_DAT0_OVRF_shift_h1                 (7)                     /*!< Bit Shift of 16bit */
#define ADC_DAT0_DAT0_OVRF_shift_b2                 (7)                     /*!< Bit Shift of 8bit */

#define ADC_DAT0_DAT0_CF_mask_w                     ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define ADC_DAT0_DAT0_CF_mask_h1                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define ADC_DAT0_DAT0_CF_mask_b2                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define ADC_DAT0_DAT0_CF_shift_w                    (22)                    /*!< Bit Shift of 32bit */
#define ADC_DAT0_DAT0_CF_shift_h1                   (6)                     /*!< Bit Shift of 16bit */
#define ADC_DAT0_DAT0_CF_shift_b2                   (6)                     /*!< Bit Shift of 8bit */

#define ADC_DAT0_DAT0_WDHF_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define ADC_DAT0_DAT0_WDHF_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define ADC_DAT0_DAT0_WDHF_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define ADC_DAT0_DAT0_WDHF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_DAT0_DAT0_WDHF_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_DAT0_DAT0_WDHF_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_DAT0_DAT0_WDHF_happened_w               ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_DAT0_DAT0_WDHF_happened_h1              ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_DAT0_DAT0_WDHF_happened_b2              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_DAT0_DAT0_WDIF_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define ADC_DAT0_DAT0_WDIF_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define ADC_DAT0_DAT0_WDIF_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define ADC_DAT0_DAT0_WDIF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_DAT0_DAT0_WDIF_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_DAT0_DAT0_WDIF_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_DAT0_DAT0_WDIF_happened_w               ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_DAT0_DAT0_WDIF_happened_h1              ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_DAT0_DAT0_WDIF_happened_b2              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_DAT0_DAT0_WDLF_mask_w                   ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define ADC_DAT0_DAT0_WDLF_mask_h1                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define ADC_DAT0_DAT0_WDLF_mask_b2                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define ADC_DAT0_DAT0_WDLF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define ADC_DAT0_DAT0_WDLF_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define ADC_DAT0_DAT0_WDLF_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define ADC_DAT0_DAT0_WDLF_happened_w               ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define ADC_DAT0_DAT0_WDLF_happened_h1              ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define ADC_DAT0_DAT0_WDLF_happened_b2              ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define ADC_DAT0_DAT0_mask_w                        ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define ADC_DAT0_DAT0_mask_h0                       ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define ADC_DAT0_DAT0_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define ADC_DAT0_DAT0_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define ADC_DAT0_DAT0_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_ADC_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_ADC.h                           */
/*----------------------------------------------------------------------------*/
