/*********************************************************************
*    Project: MGEQ1C064-DEMO
*			MGEQ1C064AD48 LQFP48 EV_V10 (TH249A)
*			CpuCLK=12MHz, SysCLK=12MHz
*    Description:
*			IO Mode 
*    Note:
* 
*    Creat time:
*    Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MGEQ1C064.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MGEQ1C064.H"
#include ".\include\API_Uart_BRGRL_MGEQ1C064.H"

/*************************************************
*Set SysClk (MAX.50MHz)
*Selection: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	33170000,36000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.36MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57

/*************************************************
*Function:     	void DelayXus(u16 xUs)
*Description:   	delay,unit:us
*Input:     		u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     	void DelayXms(u16 xMs)
*Description:    delay,unit:ms
*Input:     		u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   	void InitPort()
*Description:	Initialize IO Port
*Input:   
*Output:   		
*************************************************************************************/
void InitPort(void)
{
//	PORT_SetP0AInputOnly(BIT0|BIT1);				// Set P00,P01 as Analog-Input-Only
//	PORT_SetP0OpenDrainPu(BIT0|BIT1);				// Set P00,P01 as OpenDrain with pull up resistance
//	PORT_SetP0OpenDrain(BIT0|BIT1);					// Set P00,P01 as OpenDrain
//	PORT_SetP0PushPull(BIT0|BIT1);					// Set P00,P01 as Push pull

//	PORT_SetP1AInputOnly(BIT0|BIT1);				// Set P10,P11 as Analog-Input-Only
//	PORT_SetP1OpenDrainPu(BIT0|BIT1);				// Set P10,P11 as OpenDrain with pull up resistance
//	PORT_SetP1OpenDrain(BIT0|BIT1);					// Set P10,P11 as OpenDrain
//	PORT_SetP1PushPull(BIT0|BIT1);					// Set P10,P11 as Push pull

//	PORT_SetP2AInputOnly(BIT2|BIT4);				// Set P22,P24 as Analog-Input-Only
//	PORT_SetP2OpenDrainPu(BIT2|BIT4);				// Set P22,P24 as OpenDrain with pull up resistance
//	PORT_SetP2OpenDrain(BIT2|BIT4);					// Set P22,P24 as OpenDrain
//	PORT_SetP2PushPull(BIT2|BIT4);					// Set P22,P24 as Push pull

//	PORT_SetP3InputOnly(BIT3);						// Set P33 as Input-Only
//	PORT_SetP3OpenDrain(BIT3|BIT4|BIT5);			// Set P22,P24 as OpenDrain 
//	PORT_SetP3QuasiBi(BIT0|BIT1|BIT3|BIT4|BIT5);	// Set P30,P31,P33,P34,P35 as Quasi-Bidirectional
//	PORT_SetP3PushPull(BIT5);						// Set P35 as Push pull

//	PORT_SetP4AInputOnly(BIT4|BIT5);				// Set P44,P45 as Analog-Input-Only 
//	PORT_SetP4OpenDrainPu(BIT4|BIT5);				// Set P44,P45 as OpenDrain with pull up resistance
//	PORT_SetP4OpenDrain(BIT4|BIT5);					// Set P44,P45 as OpenDrain
//	PORT_SetP4PushPull(BIT4|BIT5);					// Set P44,P45 as Push pull

//	PORT_SetP5AInputOnly(BIT0|BIT1);				// Set P50,P51 as Analog-Input-Only 
//	PORT_SetP5OpenDrainPu(BIT0|BIT1);				// Set P50,P51 as OpenDrain with pull up resistance
//	PORT_SetP5OpenDrain(BIT0|BIT1);					// Set P50,P51 as OpenDrain
//	PORT_SetP5PushPull(BIT0|BIT1);					// Set P50,P51 as Push pull
	PORT_SetP5PushPull(BIT5|BIT6|BIT7);					// Set P55,P56,P57 as Push Pull(LED)

//	PORT_SetP6AInputOnly(BIT0|BIT1);				// Set P60,P61 as Analog-Input-Only 
//	PORT_SetP6OpenDrainPu(BIT0|BIT1);				// Set P60,P61 as OpenDrain with pull up resistance
//	PORT_SetP6OpenDrain(BIT0|BIT1);					// Set P60,P61 as OpenDrain
	PORT_SetP6PushPull(BIT0|BIT1);					// Set P60,P61 as Push pull

//	PORT_SetP7AInputOnly(BIT0|BIT1);				// Set P70,P71 as Analog-Input-Only 
//	PORT_SetP7OpenDrainPu(BIT0|BIT1); 				// Set P70,P71 as OpenDrain with pull up resistance
//	PORT_SetP7OpenDrain(BIT0|BIT1);					// Set P70,P71 as OpenDrain
	PORT_SetP7PushPull(BIT0|BIT1);					// Set P70,P71 as Push pull

}

/***********************************************************************************
*Function:       void InitSystem(void)
*Description:    Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	
}

void main()
{
    InitSystem();
					
	LED_G_0=0;LED_R=0;LED_G_1=0;
	DelayXms(1000);
	LED_G_0=1;LED_R=1;LED_G_1=1;
	
    while(1)
    {
		// P5, Page 0 only
		SFR_SetPage(0);
		LED_R=!LED_R;
		DelayXms(500);

		// P6, Page 1 only
		SFR_SetPage(1);
		P60=0;
		P61=0;
		DelayXus(100);
		P60=1;
		P61=1;
		DelayXus(100);
		SFR_SetPage(0);

		// P7, Page 2 only
		SFR_SetPage(2);
		P70=0;
		P71=0;
			DelayXus(100);
		P70=1;
		P71=1;
			DelayXus(100);
		SFR_SetPage(0);

		}
    }


