#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
Timer1 Interrupt => TF1_Flag
****************************************************************/
uint8_t TF1_Flag;

void main()
{
    /****************************************************************
    Variables
    count => For time delay
    ****************************************************************/
    uint8_t count = 0;

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer1 interrupt (ET1) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER1_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer1 Initialized
     *  Interrupt time => (1 / (SYSCLK/12)) * 65536 * 15 � 0.983 S
     ****************************************************************/
    __DRV_TIMER1_Mode_Select(TIMER1_MODE1_16BIT_TIMER);
    __DRV_TIMER1_Clock_Source_Select(TIMER1_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER1_Run_Cmd(MW_ENABLE);

    while (1)
    {
        if (TF1_Flag)
        {
            count += 1;
            if (count == 15)
            {
                __DRV_GPIO_InversePinP5(P55);
                count = 0;
            }
            TF1_Flag = 0;
        }
    }
}

/****************************************************************
Timer1 interrupt
Timer1 interrupt flag (TF1) is cleared by hardware interrupt.
****************************************************************/
void TIMER1_TF1_ISR(void) interrupt TIMER1_ISR_VECTOR
{
    TF1_Flag = 1;
}
