#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_RTC_DRV.h"
#include "MGEQ1C064_PW_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
RTC Interrupt => RTCF_Flag
****************************************************************/
uint8_t RTCF_Flag = 0;

/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

void main()
{
    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable RTCF interrupt (RTCFIE) = Enable;
     *  2. Enable System Flag interrupt (ESF) = Enable;
     *  3. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_RTC_IT_Cmd(MW_ENABLE);
    __DRV_INT_SystemFlag_IT_Enable();
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P57 used for LED_D6
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P57_PushPull);

    /****************************************************************
     *  RTC Initialized
     *  1. Clock Source = ILRCO
     *  1. Prescaler = 32768
     *  3. RTC = Enable
     ****************************************************************/
    __DRV_RTC_ClockSource_Select(RTC_CLK_ILRCO);
    __DRV_RTC_SetPrescaler(RTC_RTCCS_DIV_32768);
    __DRV_RTC_Cmd(MW_ENABLE);

    while (1)
    {
        /****************************************************************
         *  Interrupt time of RTC_Flag
         *  ILRCO(32KHz) / 32768 = 1 S
         *  When RTC interrupt occurs , MCU will wake up from power down mode.
         *  If MCU not in the power down mode,P5.7 can inverted pin level per 50mS.
         ****************************************************************/
        if (RTCF_Flag)
        {
            __DRV_GPIO_WriteP5(P57, 1);     //Disable LED_D6
            __DRV_PW_PowerDown_Enable();    //Power Down Mode
            RTCF_Flag = 0;
        }
        __DRV_GPIO_InversePinP5(P57);
        delay_ms(50);
    }
}

void SYSFlag_RTC_ISR() interrupt SYSFLAG_ISR_VECTOR
{
    // To check RTC Flag
    if ((PCON1 & RTCF) == RTCF)
    {
        RTCF_Flag = 1;
        __DRV_RTC_ClearFlag();
    }
}
