#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
 *  Delay function
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

void main()
{
    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P56 used for LED_D5
     *  3. P57 used for LED_D6
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull | P56_PushPull | P57_PushPull);

    while (1)
    {
        /****************************************************************
         *  LED Flash
         *  1. Inverse LED_D4, LED_D5, LED_D6 every 300ms.
         ****************************************************************/
        __DRV_GPIO_InversePinP5(P55);
        __DRV_GPIO_InversePinP5(P56);
        __DRV_GPIO_InversePinP5(P57);
        delay_ms(300);
    }
}
