/*********************************************************************
    Ŀ:MA82G5Cxx-DEMO
			԰ʹ MA82G5C64 LQFP64_V10	Ev Board (TH167A)
			CpuCLK=12MHz, SysCLK=12MHz
	
			ACMP AC0,AC1,AC2 
			AC0: +P02,-P01
			AC1: +P07,-P06
			AC2: +P63,-P62
	ע

    ʱ:
    ޸־:
    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MA82G5Cxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MA82G5Cxx.H"
#include ".\include\API_Uart_BRGRL_MA82G5Cxx.H"


/*************************************************
ϵͳʱSysClk (MAX.50MHz)
ѡ: 
	11059200,12000000,
	22118400,24000000,
	29491200,32000000,
	33170000,36000000,
	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
CPUʱ CpuClk (MAX.25MHz)
	1) CpuCLK=SysCLK
	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define IO_TEST_0		P52
#define IO_TEST_1		P53
#define IO_TEST_2		P54
#define IO_TEST_3		P55
#define IO_TEST_4		P56
#define IO_TEST_5		P57

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57


/***********************************************************************************
:   void INT_AC0(void)
:AC0 жϷ
		 
:   
ز:     
*************************************************************************************/
void INT_AC0(void) interrupt INT_VECTOR_AC0
{
	_push_(SFRPI);
	SFR_SetPage(0); 		
	IO_TEST_4=!IO_TEST_4;
	
	AC0CON=AC0CON&(~AC0F);		//AC0F־
	_pop_(SFRPI);
}

/***********************************************************************************
:   void INT_AC1(void)
:AC1 жϷ
		 
:   
ز:     
*************************************************************************************/
void INT_AC1(void) interrupt INT_VECTOR_AC1
{
	_push_(SFRPI);
	SFR_SetPage(0); 		
	IO_TEST_1=!IO_TEST_1;
	
	SFR_SetPage(1); 		
	AC1CON=AC1CON&(~AC1F);		//AC1F־
	_pop_(SFRPI);
}


/***********************************************************************************
:   void INT_AC2(void)
:AC2 жϷ
		 
:   
ز:     
*************************************************************************************/
void INT_AC2(void) interrupt INT_VECTOR_AC2
{
	_push_(SFRPI);
	SFR_SetPage(0); 		
	IO_TEST_2=!IO_TEST_2;
	
	SFR_SetPage(2); 		
	AC2CON=AC2CON&(~AC2F);		//AC2F־
	_pop_(SFRPI);
}

/*************************************************
:     void DelayXus(u16 xUs)
:   	ʱ,λΪus
ú:        
:     u8 Us -> *1us  (1~255)
:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
:     void DelayXms(u16 xMs)
:     ʱ,λΪms
:     u16 xMs -> *1ms  (1~65535)
:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
:   void InitAC0(void)
:AC0ʼ P02,P01
:   
ز:     
*************************************************************************************/
void InitAC0(void)
{
	AC0_Enable();										// ʹCMP0
	AC0_SetInterruptMode_Rising();						// жģʽж
	AC0_SetPosInputP02();								// CMP0P02
	AC0_SetNegaReferenceVoltage_AC0NI();				// CMP0P01
	AC0_SetFilter_SysclkDiv6_x3();						// ˲
}

/***********************************************************************************
:   void InitAC1(void)
:AC1ʼ P07,P06
:   
ز:     
*************************************************************************************/
void InitAC1(void)
{
	AC1_Enable();										// ʹCMP1
	AC1_SetInterruptMode_Rising();						// жģʽж
	AC1_SetNegaInput_AC1NI();							// CMP1P06
	AC1_SetFilter_SysclkDiv6_x3();						// ˲
}

/***********************************************************************************
:   void InitAC2(void)
:AC2ʼ P63,P62
:   
ز:     
*************************************************************************************/
void InitAC2(void)
{
	AC2_Enable();										// ʹCMP2
	AC2_SetInterruptMode_Rising();						// жģʽж
	AC2_SetNegaInput_AC2NI();							// CMP2P06
	AC2_SetFilter_SysclkDiv6_x3();						// ˲
}

/***********************************************************************************
:   void InitClock(void)
:   ϵͳʱӳʼ
:   
ز:     
*************************************************************************************/
void InitClock()
{
	
#if (MCU_CPUCLK>=24000000)
	CLK_SetCpuCLK_HighSpeed();
#endif		


#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif


#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}




/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT2|BIT3|BIT4|BIT5|BIT6|BIT7);				// P52~P57Ϊ
	PORT_SetP0AInputOnly(BIT1|BIT2|BIT6|BIT7);
	PORT_SetP62P63AInputOnly();
}

/***********************************************************************************
:   void InitInterrupt(void)
:   жϳʼ
:   
ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnAC0();										// ʹAC0ж
	INT_EnAC1();										// ʹAC1ж
	INT_EnAC2();										// ʹAC2ж
}	

/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();	
	InitAC0();
	InitAC1();
	InitAC2();
	InitInterrupt();
	
}


void main()
{
    InitSystem();
	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;

	INT_EnAll();									// ʹȫж
	
    while(1)
    {
		DelayXms(200);
		LED_G_0=!LED_G_0;
    }
}


