/*********************************************************************
    Ŀ:MA82G5Cxx-DEMO
        :LZD
			԰ʹMA82G5C64 LQFP64_V10   Ev Board (TH167A)
			CpuCLK=12MHz, SysCLK=12MHz
	
			T2ΪMode0:ԶغEXI,ʱΪSysclk/12	
			T3ΪMode0:ԶغEXI,ʱΪSysclk/12  
			T4ΪMode0:ԶغEXI,ʱΪSysclk/12	
	ע
	
    ʱ:
    ޸־:
    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MA82G5Cxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MA82G5Cxx.H"
#include ".\include\API_Uart_BRGRL_MA82G5Cxx.H"


/*************************************************
ϵͳʱSysClk (MAX.50MHz)
ѡ: 
	11059200,12000000,
	22118400,24000000,
	29491200,32000000,
	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
CPUʱ CpuClk (MAX.25MHz)
	1) CpuCLK=SysCLK
	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define IO_TEST_0		P52
#define IO_TEST_1		P53
#define IO_TEST_2		P54
#define IO_TEST_3		P55
#define IO_TEST_4		P56
#define IO_TEST_5		P57

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57


/***********************************************************************************
:   void INT_T2(void)
:T2 жϷ
:   
ز:     
*************************************************************************************/
void INT_T2(void) interrupt INT_VECTOR_T2
{
	_push_(SFRPI);
	SFR_SetPage(0);			// TF2,EXF20ҳ, ҳΪ0, ж豣SFRPI
	if(TF2)
	{
		TF2=0;
		IO_TEST_3=!IO_TEST_3;
	}
	if(EXF2)
	{
		EXF2=0;
		IO_TEST_0=!IO_TEST_0;
	}
	_pop_(SFRPI);
}

/***********************************************************************************
:   void INT_T0(void)
:T3 жϷ
:   
ز:     
*************************************************************************************/
void INT_T3(void) interrupt INT_VECTOR_T3
{
	_push_(SFRPI);
	SFR_SetPage(1);				// TF31ҳ
	if(TF3)						
	{
		TF3=0;
		SFR_SetPage(0);			// P5Page 0
		IO_TEST_4=!IO_TEST_4;
	}
	SFR_SetPage(1);				// EXF31ҳ
	if(EXF3)
	{
		EXF3=0;
		SFR_SetPage(0); 		// P5Page 0
		IO_TEST_1=!IO_TEST_1;
	}
	_pop_(SFRPI);				
}

/***********************************************************************************
:   void INT_T4(void)
:T4 жϷ
:   
ز:     
*************************************************************************************/
void INT_T4(void) interrupt INT_VECTOR_T4
{
	_push_(SFRPI);
	SFR_SetPage(2);				// TF42ҳ
	if(TF4)						
	{
		TF4=0;
		SFR_SetPage(0);			// P5Page 0
		IO_TEST_5=!IO_TEST_5;
	}
	SFR_SetPage(2);				// EXF42ҳ
	if(EXF4)
	{
		EXF4=0;
		SFR_SetPage(0); 		// P5Page 0
		IO_TEST_2=!IO_TEST_2;
	}
	_pop_(SFRPI);				
}


/***********************************************************************************

/*************************************************
:     void DelayXus(u16 xUs)
:   	ʱ,λΪus
ú:        
:     u8 Us -> *1us  (1~255)
:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
:     void DelayXms(u16 xMs)
:     ʱ,λΪms
:     u16 xMs -> *1ms  (1~65535)
:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
:   void InitTimer2(void)
:Timer2ʼ	
:   
ز:     
*************************************************************************************/
void InitTimer2(void)
{
	TM_SetT2Mode_AutoRLandExI();			// T2ģʽ0Ϊ16λԶغⲿжģʽ
	TM_SetT2Clock_SYSCLKDiv12();			// T2ʱԴΪ SYSCLK/12
	
	TM_SetT2LowByte(TIMER_12T_1ms_TL);						// T28λ
	TM_SetT2HighByte((TIMER_12T_1ms_TH));					// T28λ
	TM_SetT2RLLowByte((TIMER_12T_1ms_TL));					// ֵ8λ
	TM_SetT2RLHighByte((TIMER_12T_1ms_TH));					// ֵ8λ
	TM_EnableT2();							// ʹT2

	TM_SetT2Capture_T2EXPin();				// ʹT2ⲿжΪT2EX
	TM_SetT2CKOT2EX_P10P11();				// T2/T2CKO:P10,T3EX:P11
	TM_EnableT2EX_DetectFalling();			// ʹT2EXż½
	
}

/***********************************************************************************
:   void InitTimer3(void)
:Timer3ʼ
:   
ز:     
*************************************************************************************/
void InitTimer3(void)
{
	TM_SetT3Mode_AutoRLandExI();			// T3ģʽ0Ϊ16λԶغⲿжģʽ
	TM_SetT3Clock_SYSCLKDiv12();			// T3ʱԴΪ SYSCLK/12
	
	TM_SetT3LowByte(TIMER_12T_1ms_TL);		// T38λ
	TM_SetT3HighByte(TIMER_12T_1ms_TH);		// T38λ
	TM_SetT3RLLowByte(TIMER_12T_1ms_TL);	// ֵ8λ
	TM_SetT3RLHighByte(TIMER_12T_1ms_TH);	// ֵ8λ
	
	TM_EnableT3();							// ʹT3
	TM_SetT3Capture_T3EXPin();				// ʹT3ⲿжΪT2EX
	TM_SetT3CKOT3EX_P40P41();				// T3/T3CKO:P40,T3EX:P41
	TM_EnableT3EX_DetectFalling();			// ʹT3EXż½

}

/***********************************************************************************
:   void InitTimer4(void)
:Timer4ʼ
:   
ز:     
*************************************************************************************/
void InitTimer4(void)
{
	TM_SetT4Mode_AutoRLandExI();			// T4ģʽ0Ϊ16λԶغⲿжģʽ
	TM_SetT4Clock_SYSCLKDiv12();			// T4ʱԴΪ SYSCLK/12
	
	TM_SetT4LowByte(TIMER_12T_1ms_TL);		// T48λ
	TM_SetT4HighByte(TIMER_12T_1ms_TH);		// T48λ
	TM_SetT4RLLowByte(TIMER_12T_1ms_TL);	// ֵ8λ
	TM_SetT4RLHighByte(TIMER_12T_1ms_TH);	// ֵ8λ
	
	TM_EnableT4();							// ʹT4
	TM_SetT4Capture_T4EXPin();				// ʹT4ⲿжΪT4EX
	TM_SetT4CKOT4EX_P42P43();				// T4/T4CKO:P42,T4EX:P43
	TM_EnableT4EX_DetectFalling();			// ʹT4EXż½

}

/***********************************************************************************
:   void InitInterrupt(void)
:InitInterruptʼ
:   
ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER2();
	INT_EnTIMER3();
	INT_EnTIMER4();
	
}

/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT2|BIT3|BIT4|BIT5|BIT6|BIT7);					// P52,P53,P54,P55,P56,P57Ϊ

	PORT_SetP1OpenDrain(BIT0|BIT1);
	PORT_EnP10P11P12P13PullHigh();
	PORT_SetP4OpenDrain(BIT0|BIT1|BIT2|BIT3);
	PORT_EnP40P41P42P43PullHigh();
	
}


/***********************************************************************************
:   void InitClock(void)
:   ϵͳʱӳʼ
:   
ز:     
*************************************************************************************/
void InitClock()
{
	
#if (MCU_CPUCLK>=24000000)
	CLK_SetCpuCLK_HighSpeed();
#endif		


#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif


#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}


/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	
	InitTimer2();			
	InitTimer3();	
	InitTimer4();

	InitInterrupt();		// жϳʼ
	
	INT_EnAll();			// ʹȫж
}

void main()
{
	
    InitSystem();
	
 	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
 	LED_G_0=1;LED_G_1=1;LED_R=1;

					
    while(1)
    {
    }
}








