/*********************************************************************
    Ŀ:MA82G5Cxx-DEMO
			԰ʹMA82G5C64 LQFP64_V10   Ev Board (TH167A)
			CpuCLK=12MHz, SysCLK=12MHz
	
			IAP 
	ע
	
    ʱ:
    ޸־:
    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MA82G5Cxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MA82G5Cxx.H"
#include ".\include\API_Uart_BRGRL_MA82G5Cxx.H"


/*************************************************
ϵͳʱSysClk (MAX.50MHz)
ѡ: 
	11059200,12000000,
	22118400,24000000,
	29491200,32000000,
	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
CPUʱ CpuClk (MAX.25MHz)
	1) CpuCLK=SysCLK
	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57

#define ERR_CNT_MAX		4		// Լֵ

#define IAP_ADDRESS    0xF000	 //IAPʼַ  
#define NO_IAP_ADDRESS 0xFE	 	 //ISPʼַ  

idata u8 TrapFlag[3];

#define TEST_WRITE_BUF_IAP_ADDRESS    0xF221	 // дBufIAPʼַ
xdata u8 TestBuf[16];

/*************************************************
: char putchar (char c)   
: printf Ĵ
:     char c
:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
:     void DelayXus(u16 xUs)
:   	ʱ,λΪus
ú:        
:     u8 Us -> *1us  (1~255)
:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
:     void DelayXms(u16 xMs)
:     ʱ,λΪms
:     u16 xMs -> *1ms  (1~65535)
:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
:   	void CheckTrapFlag(void)
:   	Ƿȷ̽IAPֹ
				TrapFlag != "Win",ʾǷǷ,Ƭλ
:   	
ز:     
*************************************************************************************/
void CheckTrapFlag(void)
{ 
	if ((TrapFlag[0]!='W')||(TrapFlag[1]!='i')||(TrapFlag[2]!='n'))
	{
		//λ
		POW_ResetToAP();
	}
}

/***********************************************************************************
:   u8 IAP_ReadPPage(u8 PsfrAddr)
:ȡPҳ⹦
:   
		 u8 PsfrAddr: Pҳַ
ز:     
		 u8: Pҳ
*************************************************************************************/
u8 IAP_ReadPPage(u8 PsfrAddr)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFMT = ISP_READ_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	CheckTrapFlag();
	SCMD = 0x46;
	CheckTrapFlag();
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
	return IFD;
}


/***********************************************************************************
:void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
:дPҳ⹦
:   
		 u8 PsfrAddr: Pҳַ,u8 PsfrData:  Pҳ
ز:     
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFD= PsfrData;				//Pҳ
	IFMT = ISP_WRITE_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	CheckTrapFlag();
	SCMD = 0x46;
	CheckTrapFlag();
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
}


/***********************************************************************************
:u8 IAP_ReadByte(u16 ByteAddr)
:ַָIAP
:   
		 u16 ByteAddr: IAPַ
ز:     
*************************************************************************************/
u8 IAP_ReadByte(u16 ByteAddr)
{
		bit bEA=EA;
		IFADRH = ByteAddr>>8;		//͵ַֽ
		IFADRL= ByteAddr;			//͵ַֽ;
		EA = 0;						//ж
		IFMT = ISP_READ;
		ISPCR = 0x80; 				//ISP/IAP
		CheckTrapFlag();
		SCMD = 0x46;
		CheckTrapFlag();
		SCMD = 0xB9;
		IFMT=0;
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA; 					//ָж
		return IFD;
}
// ʹMOVCķʽȡIAP
#define	IAP_ReadByteByMOVC(x)	CBYTE[x]

/***********************************************************************************
:void IAP_ErasePage(u8 ByteAddr)
:ҳ, ַָڵҳ档
		һҳԼҪ30ms
:   
		 u8 ByteAddr: ָҳַ8λ
*************************************************************************************/
void IAP_ErasePage(u8 ByteAddr)
{
		bit bEA=EA;
		IFADRH = ByteAddr;		//͵ַֽ
		IFADRL= 0x00;			//͵ַֽ;
		EA = 0;					//ж
		IFMT = ISP_ERASE;
		ISPCR = 0x80; 			//ISP/IAP
		CheckTrapFlag();
		SCMD = 0x46;
		CheckTrapFlag();
		SCMD = 0xB9;
		nop();
		IFMT=0;
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA; 					//ָж
}

/***********************************************************************************
:void IAP_WriteByte(u16 ByteAddr,u8 ByteData)
:дֽڵַָ, õַΪ(0xFF),Ҫִҳ
		 дһֽݴԼҪ80us
:   
		 u16 ByteAddr: ָIAPַ, u8 ByteData: д
ز:     
*************************************************************************************/

void IAP_WriteByte(u16 ByteAddr,u8 ByteData)
{
		bit bEA=EA;
		IFD = ByteData;				//Ҫд	
		IFADRH = ByteAddr>>8;		//͵ַֽ
		IFADRL= ByteAddr;			//͵ַֽ;
		EA = 0;						//ж
		IFMT = ISP_WRITE;
		ISPCR = 0x80;               //ISP/IAP
		CheckTrapFlag();
		SCMD = 0x46;
		CheckTrapFlag();
		SCMD = 0xB9;
		nop();
		IFMT=0;
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA; 					//ָж
}

/***********************************************************************************
:		u8 IAP_WriteBuf_With_Protect_Verify(u16 ByteAddr,u8 *pBuf,u16 Cnt)
:		дһݵIAPַָ
		 	ʹõ512ֽXDATAԭ
		 	дһֽݴԼҪ80us
:   
		 	u16 ByteAddr: ָIAPַ, u8 *pBuf: дBufַu16 Cnt: д
ز:     
		 	u8 0ɹ,	other:ʧ
*************************************************************************************/
u8 IAP_WriteBuf_With_Protect_Verify(u16 ByteAddr,u8 *pBuf,u16 Cnt)
{
		xdata u8 TempBuf[512];
		u16 i;
		u8 ErrCnt;
		WordTypeDef SectorAddr;
		bit bEA=EA;
		// ȡ¼ԭݵʱ
		EA = 0;
		ErrCnt=0;
		
		SectorAddr.W=ByteAddr&0xFE00;
		for(i=0;i<512;i++)
		{
			IFADRH = SectorAddr.B.BHigh;//͵ַֽ
			IFADRL= SectorAddr.B.BLow;	//͵ַֽ;
			IFMT = ISP_READ;
			ISPCR = 0x80;				//ISP/IAP
			CheckTrapFlag();
			SCMD = 0x46;
			CheckTrapFlag();
			SCMD = 0xB9;
			IFMT=0;
			ISPCR = 0;					//ISP/IAPĴֹ
			SectorAddr.W++;
			TempBuf[i]=IFD;
		}
		// д
		i=ByteAddr&0x01FF;
		while(Cnt!=0)
		{
			TempBuf[i]=*pBuf;
			pBuf++;
			i++;
			Cnt--;
		}
	Err_Loop:
		// 
		SectorAddr.W=ByteAddr&0xFE00;
		IFADRH = SectorAddr.B.BHigh;	//͵ַֽ
		IFADRL= 0x00;					//͵ַֽ;
		IFMT = ISP_ERASE;
		ISPCR = 0x80; 					//ISP/IAP
		CheckTrapFlag();
		SCMD = 0x46;
		CheckTrapFlag();
		SCMD = 0xB9;
		nop();
		IFMT=0;
		ISPCR = 0;						//ISP/IAPĴֹ
		// ĺдIAP
		for(i=0;i<512;i++)
		{
			IFD = TempBuf[i];			//Ҫд	
			IFADRH =SectorAddr.B.BHigh;	//͵ַֽ
			IFADRL= SectorAddr.B.BLow;	//͵ַֽ;
			IFMT = ISP_WRITE;
			ISPCR = 0x80;               //ISP/IAP
			CheckTrapFlag();
			SCMD = 0x46;
			CheckTrapFlag();
			SCMD = 0xB9;
			nop();
			IFMT=0;
			ISPCR = 0;					//ISP/IAPĴֹ
			SectorAddr.W++;
		}
		// УǷȷ
		SectorAddr.W=ByteAddr&0xFE00;
		for(i=0;i<512;i++)
		{
			IFADRH = SectorAddr.B.BHigh;//͵ַֽ
			IFADRL= SectorAddr.B.BLow;	//͵ַֽ;
			IFMT = ISP_READ;
			ISPCR = 0x80;				//ISP/IAP
			CheckTrapFlag();
			SCMD = 0x46;
			CheckTrapFlag();
			SCMD = 0xB9;
			IFMT=0;
			ISPCR = 0;					//ISP/IAPĴֹ
			SectorAddr.W++;
			if(TempBuf[i]!=IFD)
			{
				ErrCnt++;
				if(ErrCnt<ERR_CNT_MAX)
				{
					goto Err_Loop;
				}
				else
				{
					goto Err_Return;
				}
			}
		}
		ErrCnt=0;
	Err_Return:
		EA = bEA;					//ָж
		return ErrCnt;		
}

/***********************************************************************************
:   void InitUart0_S1BRG(void)
:   Uart0ʼ ,ʹS1BRGΪԴ
:   
ز:     
*************************************************************************************/
void InitUart0_S1BRG(void)
{	
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART1
	UART0_SetBRGFromS1BRG();			// òԴΪ S1BRG
	UART0_SetS1BRGBaudRateX4();			// 4x
	UART1_SetS1BRGSelSYSCLK();			// S1BRGʱΪSysclk

    // ò
	UART1_SetS1BRGValue(S1BRG_BRGRL_115200_4X_12000000_1T);
	
	UART1_EnS1BRG();					// S1BRGʱ
}

/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(BIT4|BIT5|BIT6|BIT7);			//  P24,P25,P26,P27 Ϊ©
	PORT_EnP24P25P26P27PullHigh();						// ʹ P24,P25,P26,P27 

	PORT_SetP1OpenDrain(BIT0);							//  P10 Ϊ©ģʽ
	PORT_EnP10P11P12P13PullHigh();						// ʹ P10,P11,P12,P13 
}


/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitUart0_S1BRG();

	CLK_SetIAPTimeBase(12);
	
	TrapFlag[1]='i';
}


void main()
{
	u8 IAPData;
	u8 i;
	u8 rand;
	bit bOK=TRUE;

	TrapFlag[0]='W';
	
    InitSystem();
    
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	printf("\nStart IAP DEMO!");
	LED_G_0=1;LED_G_1=1;LED_R=1;

	TrapFlag[2]='n';
    
	//IAPʼʼַ
	i=IAP_ReadPPage(IAPLB_P);
    printf("\nRead IAPLB:%02bX",i);

	// IAPʼַΪ0xFE,IAPռ
	IAP_WritePPage(IAPLB_P,NO_IAP_ADDRESS);
	i=IAP_ReadPPage(IAPLB_P);
    printf("\nNOW IAPLB:%02bX",i);
	TrapFlag[2]=0xFF;

	printf("\nOld IAP %04X:\n",IAP_ADDRESS);
	i=0;
	do{
		LED_G_1=0;
		IAPData=IAP_ReadByteByMOVC(IAP_ADDRESS+i);	// MOVCķʽȡ
		LED_G_1=1;
		printf("%02bX ",IAPData);
		if((i&0x0F)==0x0F)
		{
			printf("\n");
		}
		i++;
	}while(i!=0);
    

    while(1)
    {
    	rand++;
		LED_G_0=!LED_G_0;
	   	DelayXms(100);
		if(P10==0)
		{
			DelayXms(50);
			if(P10==0)
			{
				TrapFlag[2]='n';
				// IAPʼַΪIAPַ
				printf("\nWrite IAPLB:%02bX  ",IAP_ADDRESS/256);
				IAP_WritePPage(IAPLB_P,IAP_ADDRESS/256);
				i=IAP_ReadPPage(IAPLB_P);
				printf("\nRead IAPLB:%02bX  ",i);
				LED_R=0;
				// ҳ
				IAP_ErasePage(IAP_ADDRESS/256);
				LED_R=1;
				TrapFlag[2]=0xFF;

				// д
				printf("\nWRITE IAP %04X:\n",IAP_ADDRESS);
				TrapFlag[2]='n';
				i=0;
				do{
					IAPData=rand+i;
					LED_G_1=0;
					IAP_WriteByte(IAP_ADDRESS+i,IAPData);
					LED_G_1=1;
					printf("%02bX ",IAPData);
					if((i&0x0F)==0x0F)
					{
						printf("\n");
					}
					i++;
				}while(i!=0);
				// IAPռ
				printf("\nWrite IAPLB:%02bX  ",NO_IAP_ADDRESS);
				IAP_WritePPage(IAPLB_P,NO_IAP_ADDRESS);
				i=IAP_ReadPPage(IAPLB_P);
				printf("\nRead IAPLB:%02bX  ",i);
				TrapFlag[2]=0xFF;
				printf("\nNow IAP %04X:\n",IAP_ADDRESS);
				i=0;
				bOK=TRUE;
				do{
					LED_G_1=0;
					IAPData=IAP_ReadByteByMOVC(IAP_ADDRESS+i);	// MOVCķʽȡ
					LED_G_1=1;
					printf("%02bX ",IAPData);
					if((i&0x0F)==0x0F)
					{
						printf("\n");
					}
					// ж϶Ƿдһ
					if(IAPData != (u8)(rand+i))
					{
						bOK=FALSE;
					}
					i++;
				}while(i!=0);
				LED_G_1=1;LED_R=1;
				if(bOK)
				{	// ͬ
					LED_G_1=0;
				}
				else
				{	// ݲͬ
					LED_R=0;
				}
				while(P10==0)
				{
					DelayXms(50);
				}
			}
		}

		if(P11==0)
		{
			DelayXms(50);
			if(P11==0)
			{
			
				TrapFlag[2]='n';
				// IAPʼַΪIAPַ
				printf("\nWrite IAPLB:%02bX  ",IAP_ADDRESS/256);
				IAP_WritePPage(IAPLB_P,IAP_ADDRESS/256);
				i=IAP_ReadPPage(IAPLB_P);
				printf("\nRead IAPLB:%02bX	",i);

				// ò
				printf("TestBuf: ");
				for(i=0;i<16;i++)
				{
					TestBuf[i]=rand+i;
					printf("%02bX ",TestBuf[i]);
				}

				// BufдIAP
				printf("\nWRITE IAP %04X:",TEST_WRITE_BUF_IAP_ADDRESS);
				i=IAP_WriteBuf_With_Protect_Verify(TEST_WRITE_BUF_IAP_ADDRESS, TestBuf,16);
				if(i!=0)
				{// ʧ
					LED_R=0;
					printf("Fail!!!");
				}
				else
				{// ɹ
					LED_G_1=0;
					printf("OK!!!");
				}
				// IAPʼַΪISPַ,IAPռ
				printf("\nWrite IAPLB:%02bX  ",NO_IAP_ADDRESS);
				IAP_WritePPage(IAPLB_P,NO_IAP_ADDRESS);
				i=IAP_ReadPPage(IAPLB_P);
				printf("\nRead IAPLB:%02bX  ",i);
				TrapFlag[2]=0xFF;
				while(P11==0)
				{
					DelayXms(50);
				}
			}
    }

		
    }

}


