

#define		uCHAR	unsigned char
#define		uINT	unsigned short
#define		uLONG	unsigned long

#include "REG_MG82FG5A64.H"


#define		T0_1MSL				0x67				//( 65536 - 1000 * 0.9216 ) % 256
#define		T0_1MSH				0xFC				//( 65536 - 1000 * 0.9216 ) / 256

#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00

uCHAR T0Cnt;
uCHAR UART0_Value;
uCHAR UART1_Value;
bit UART0_Tx_Busy;
bit UART1_Tx_Busy;

void PageP_Write( uCHAR Addr , uCHAR Data )
{
	IFADRH = 0x00;
	IFADRL = Addr;
	IFD = Data;
	IFMT = 0x04;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
}

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	ISPCR = ISP_ENABLE;
	IFADRH = 0x00;
	IFADRL = Addr;
	IFMT = 0x05;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
	Data = IFD;
	
	return Data;
}

void Delay_Xms( uCHAR X )
{
	TR0 = 0;                                   // Disable Timer0

	T0Cnt = X;                                   // X*1ms = Xms

	TL0 = T0_1MSL;
	TH0 = T0_1MSH;
	TR0 = 1;                                   // Enable Timer0
	while( T0Cnt );
}

void INT_TIMER0(void) interrupt 1 using 1        // Timer0 Interrupt
{
	TR0 = 0;                                   // Disable Timer0

	if ( T0Cnt )
	{
		T0Cnt--;
		TL0 = T0_1MSL;
		TH0 = T0_1MSH;
		TR0 = 1;                               // Enable Timer0
	}
}

void Initial_UART0(void)
{
	S0CFG = 0x40;
	S0CON = 0x50;
	T2CON = 0x30;
	T2MOD = 0x00;
	TH2 = RCAP2H = 65524 / 256;					// Baud Rate 115200, refer to Spec table 15-14, SMOD1 = 1
	TL2 = RCAP2L = 65524 % 256;
	TR2 = 1;
}

void Initial_UART1(void)
{
	SFRPI = 0x01;
	S1CON = 0x50;
	S1BRC = S1BRT = 244;
	SFRPI = 0x00;								// Baudrate 115200
	S1CFG = S1TR | S1MOD1 | S1TX12;
}

void INT_UART0(void)	interrupt	4	using	1
{
	uCHAR tmp_SFRPI;
	tmp_SFRPI = SFRPI;
	SFRPI = 0;
	if(RI0)
	{
		RI0 = 0;
		UART0_Value = S0BUF;
		P56 = ~P56;				//LED
	}
	if(TI0)
	{
		TI0 = 0;
		UART0_Tx_Busy = 0;
	}
	
	SFRPI = tmp_SFRPI;
}

void INT_UART1(void)	interrupt	12	using	1
{
	uCHAR tmp_SFRPI;
	tmp_SFRPI = SFRPI;
	SFRPI = 1;
	if(RI1)
	{
		RI1 = 0;
		UART1_Value = S1BUF;
		SFRPI = 0;
		P57 = ~P57;				//LED
		SFRPI = 1;
	}
	if(TI1)
	{
		TI1 = 0;
		UART1_Tx_Busy = 0;
	}
	SFRPI = tmp_SFRPI;
}

void UART0_Send_Byte(uCHAR dta)
{
	S0BUF = dta;
	UART0_Tx_Busy = 1;
	while(UART0_Tx_Busy);
}

void UART1_Send_Byte(uCHAR dta)
{
	SFRPI = 0x01;
	S1BUF = dta;
	SFRPI = 0x00;
	UART1_Tx_Busy = 1;
	while(UART1_Tx_Busy);
}

void main(void)
{
	uCHAR	tmp;

    TMOD = 0x01;                                 // Set Timer0/1 in Mode1/2 ( 16/8 bit )
    ET0 = 1;                                     // Enable Timer0 interrupt
	
    CKCON0 |= ENCKM;
	EA = 1;
	
	Delay_Xms(1);
	
	tmp = PageP_Read(PCON2);
	tmp |= HSE;
	PageP_Write(PCON2, tmp);
	
	tmp = PageP_Read(CKCON2);
	tmp |= MCKS0;
	PageP_Write(CKCON2, tmp);						//MCU run 22.1184MHz

	Initial_UART0();
	Initial_UART1();

	ES0 = 1;									//Enable UART0 INT
	EIE1 = 0x10;								//Enable UART1 INT

	P1M0 = 0x08;								//add I/O push-pull high, this is strong pull-high.
	
	UART0_Send_Byte(0x5A);
	UART1_Send_Byte(0xA5);
	

	
	while(1);
}
